/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.FileChecksumHelper;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFileChecksum {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileChecksum.class);
    private static final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private static final int dataBlocks = ecPolicy.getNumDataUnits();
    private static final int parityBlocks = ecPolicy.getNumParityUnits();
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;
    private static Configuration conf;
    private static DFSClient client;
    private static final int cellSize;
    private static final int stripesPerBlock = 6;
    private static final int blockSize;
    private static final int numBlockGroups = 10;
    private static final int stripSize;
    private static final int blockGroupSize;
    private static final int fileSize;
    private static int bytesPerCRC;
    private static final String ecDir = "/striped";
    private static final String stripedFile1 = "/striped/stripedFileChecksum1";
    private static final String stripedFile2 = "/striped/stripedFileChecksum2";
    private static final String replicatedFile = "/replicatedFileChecksum";
    private static String checksumCombineMode;

    public void initTestFileChecksum(String pMode) throws IOException {
        checksumCombineMode = pMode;
        TestFileChecksum.setup(pMode);
    }

    public static Object[] getParameters() {
        return new Object[]{Options.ChecksumCombineMode.MD5MD5CRC.name(), Options.ChecksumCombineMode.COMPOSITE_CRC.name()};
    }

    public static void setup(String mode) throws IOException {
        checksumCombineMode = mode;
        int numDNs = dataBlocks + parityBlocks + 2;
        conf = new Configuration();
        conf.setLong("dfs.blocksize", (long)blockSize);
        conf.setInt("dfs.namenode.replication.max-streams", 0);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.checksum.combine.mode", checksumCombineMode);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDNs).build();
        Path ecPath = new Path(ecDir);
        cluster.getFileSystem().mkdir(ecPath, FsPermission.getDirDefault());
        cluster.getFileSystem().getClient().setErasureCodingPolicy(ecDir, StripedFileTestUtil.getDefaultECPolicy().getName());
        fs = cluster.getFileSystem();
        client = fs.getClient();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        bytesPerCRC = conf.getInt("dfs.bytes-per-checksum", 512);
        GenericTestUtils.setLogLevel((Logger)FileChecksumHelper.LOG, (Level)Level.DEBUG);
    }

    @AfterEach
    public void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum1(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = 0;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, length + 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum2(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = stripSize - 1;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum3(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = stripSize;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum4(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = stripSize + cellSize * 2;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum5(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = blockGroupSize;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum6(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = blockGroupSize + blockSize;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksum7(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int length = -1;
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        this.testStripedFileChecksum(length, fileSize);
    }

    private void testStripedFileChecksum(int range1, int range2) throws Exception {
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(stripedFile1, range1, false);
        FileChecksum stripedFileChecksum2 = this.getFileChecksum(stripedFile2, range1, false);
        FileChecksum stripedFileChecksum3 = this.getFileChecksum(stripedFile2, range2, false);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksum2:" + stripedFileChecksum2);
        LOG.info("stripedFileChecksum3:" + stripedFileChecksum3);
        Assertions.assertTrue((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum2));
        if (range1 >= 0 && range1 != range2) {
            Assertions.assertFalse((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum3));
        }
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedAndReplicatedFileChecksum(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, replicatedFile});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(stripedFile1, 10, false);
        FileChecksum replicatedFileChecksum = this.getFileChecksum(replicatedFile, 10, false);
        if (checksumCombineMode.equals(Options.ChecksumCombineMode.COMPOSITE_CRC.name())) {
            Assertions.assertEquals((Object)stripedFileChecksum1, (Object)replicatedFileChecksum);
        } else {
            Assertions.assertNotEquals((Object)stripedFileChecksum1, (Object)replicatedFileChecksum);
        }
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedAndReplicatedFileChecksum2(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int lastBlockSize = (int)((double)blockSize * 0.5);
        int fullStripeLength = dataBlocks * blockSize;
        int testFileSize = fullStripeLength + lastBlockSize;
        this.prepareTestFiles(testFileSize, new String[]{stripedFile1, replicatedFile});
        int specialLength = (dataBlocks - 1) * blockSize + (int)((double)blockSize * 0.6);
        Assertions.assertTrue((specialLength % blockSize > lastBlockSize ? 1 : 0) != 0);
        Assertions.assertTrue((specialLength % fullStripeLength > lastBlockSize ? 1 : 0) != 0);
        FileChecksum stripedFileChecksum = this.getFileChecksum(stripedFile1, specialLength, false);
        FileChecksum replicatedFileChecksum = this.getFileChecksum(replicatedFile, specialLength, false);
        if (checksumCombineMode.equals(Options.ChecksumCombineMode.COMPOSITE_CRC.name())) {
            Assertions.assertEquals((Object)replicatedFileChecksum, (Object)stripedFileChecksum);
        } else {
            Assertions.assertNotEquals((Object)replicatedFileChecksum, (Object)stripedFileChecksum);
        }
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testDifferentBlockSizeReplicatedFileChecksum(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        byte[] fileData = StripedFileTestUtil.generateBytes(fileSize);
        String replicatedFile1 = "/replicatedFile1";
        String replicatedFile2 = "/replicatedFile2";
        DFSTestUtil.writeFile((FileSystem)fs, new Path(replicatedFile1), fileData, blockSize);
        DFSTestUtil.writeFile((FileSystem)fs, new Path(replicatedFile2), fileData, blockSize / 2);
        FileChecksum checksum1 = this.getFileChecksum(replicatedFile1, -1, false);
        FileChecksum checksum2 = this.getFileChecksum(replicatedFile2, -1, false);
        if (checksumCombineMode.equals(Options.ChecksumCombineMode.COMPOSITE_CRC.name())) {
            Assertions.assertEquals((Object)checksum1, (Object)checksum2);
        } else {
            Assertions.assertNotEquals((Object)checksum1, (Object)checksum2);
        }
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocks1(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.prepareTestFiles(fileSize, new String[]{stripedFile1});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(stripedFile1, fileSize, false);
        FileChecksum stripedFileChecksumRecon = this.getFileChecksum(stripedFile1, fileSize, true);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksumRecon:" + stripedFileChecksumRecon);
        Assertions.assertTrue((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksumRecon), (String)"Checksum mismatches!");
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocks2(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.prepareTestFiles(fileSize, new String[]{stripedFile1, stripedFile2});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(stripedFile1, -1, false);
        FileChecksum stripedFileChecksum2 = this.getFileChecksum(stripedFile2, -1, false);
        FileChecksum stripedFileChecksum2Recon = this.getFileChecksum(stripedFile2, -1, true);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksum2:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksum2Recon:" + stripedFileChecksum2Recon);
        Assertions.assertTrue((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum2), (String)"Checksum mismatches!");
        Assertions.assertTrue((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum2Recon), (String)"Checksum mismatches!");
        Assertions.assertTrue((boolean)stripedFileChecksum2.equals((Object)stripedFileChecksum2Recon), (String)"Checksum mismatches!");
    }

    private void testStripedFileChecksumWithMissedDataBlocksRangeQuery(String stripedFile, int requestedLen) throws Exception {
        LOG.info("Checksum file:{}, requested length:{}", (Object)stripedFile, (Object)requestedLen);
        this.prepareTestFiles(fileSize, new String[]{stripedFile});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(stripedFile, requestedLen, false);
        FileChecksum stripedFileChecksumRecon = this.getFileChecksum(stripedFile, requestedLen, true);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksumRecon:" + stripedFileChecksumRecon);
        Assertions.assertTrue((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksumRecon), (String)"Checksum mismatches!");
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery1(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery2(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery3(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, bytesPerCRC);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery4(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, cellSize);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery5(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, cellSize - 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery6(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, cellSize + 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery7(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, cellSize * 2);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery8(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, stripSize);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery9(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, stripSize - 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery10(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, stripSize + 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery11(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, blockGroupSize - 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery12(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, blockGroupSize + 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery13(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, blockGroupSize * 10 / 2);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery14(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, fileSize - 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery15(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile1, fileSize * 2);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery16(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int fileLength = 100;
        String stripedFile3 = "/striped/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, fileLength - 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery17(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int fileLength = 100;
        String stripedFile3 = "/striped/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, 1);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery18(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int fileLength = 100;
        String stripedFile3 = "/striped/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, 10);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery19(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int fileLength = 100;
        String stripedFile3 = "/striped/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, fileLength * 2);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery20(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int fileLength = bytesPerCRC;
        String stripedFile3 = "/striped/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, bytesPerCRC - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testStripedFileChecksumWithReconstructFail(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        String stripedFile4 = "/striped/stripedFileChecksum4";
        this.prepareTestFiles(fileSize, new String[]{stripedFile4});
        FileChecksum fileChecksum = this.getFileChecksum(stripedFile4, -1, false);
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector newInjector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
        ((DataNodeFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).doNothing().when((Object)newInjector)).stripedBlockChecksumReconstruction();
        DataNodeFaultInjector.set((DataNodeFaultInjector)newInjector);
        try {
            FileChecksum fileChecksum1 = this.getFileChecksum(stripedFile4, -1, true);
            Assertions.assertEquals((Object)fileChecksum, (Object)fileChecksum1, (String)"checksum should be same");
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    @Timeout(value=90L)
    public void testMixedBytesPerChecksum(String pMode) throws Exception {
        this.initTestFileChecksum(pMode);
        int fileLength = bytesPerCRC * 3;
        byte[] fileData = StripedFileTestUtil.generateBytes(fileLength);
        String replicatedFile1 = "/replicatedFile1";
        byte[] fileDataPart1 = new byte[bytesPerCRC * 2];
        System.arraycopy(fileData, 0, fileDataPart1, 0, fileDataPart1.length);
        byte[] fileDataPart2 = new byte[fileData.length - fileDataPart1.length];
        System.arraycopy(fileData, fileDataPart1.length, fileDataPart2, 0, fileDataPart2.length);
        DFSTestUtil.writeFile((FileSystem)fs, new Path(replicatedFile1), fileDataPart1);
        conf.setInt("dfs.bytes-per-checksum", bytesPerCRC / 2);
        DFSTestUtil.appendFileNewBlock((DistributedFileSystem)FileSystem.newInstance((Configuration)conf), new Path(replicatedFile1), fileDataPart2);
        if (checksumCombineMode.equals(Options.ChecksumCombineMode.COMPOSITE_CRC.name())) {
            String replicatedFile2 = "/replicatedFile2";
            DFSTestUtil.writeFile((FileSystem)fs, new Path(replicatedFile2), fileData);
            FileChecksum checksum1 = this.getFileChecksum(replicatedFile1, -1, false);
            FileChecksum checksum2 = this.getFileChecksum(replicatedFile2, -1, false);
            Assertions.assertEquals((Object)checksum1, (Object)checksum2);
        } else {
            Assertions.assertThrows(IOException.class, () -> {
                FileChecksum checksum = this.getFileChecksum(replicatedFile1, -1, false);
            });
        }
    }

    private FileChecksum getFileChecksum(String filePath, int range, boolean killDn) throws Exception {
        int dnIdxToDie = -1;
        if (killDn) {
            dnIdxToDie = this.getDataNodeToKill(filePath);
            DataNode dnToDie = cluster.getDataNodes().get(dnIdxToDie);
            this.shutdownDataNode(dnToDie);
        }
        Path testPath = new Path(filePath);
        FileChecksum fc = range >= 0 ? fs.getFileChecksum(testPath, (long)range) : fs.getFileChecksum(testPath);
        if (dnIdxToDie != -1) {
            cluster.restartDataNode(dnIdxToDie);
        }
        return fc;
    }

    private void prepareTestFiles(int fileLength, String[] filePaths) throws IOException {
        byte[] fileData = StripedFileTestUtil.generateBytes(fileLength);
        for (String filePath : filePaths) {
            Path testPath = new Path(filePath);
            DFSTestUtil.writeFile((FileSystem)fs, testPath, fileData);
        }
    }

    void shutdownDataNode(DataNode dataNode) throws IOException {
        dataNode.shutdown();
        cluster.setDataNodeDead(dataNode.getDatanodeId());
    }

    int getDataNodeToKill(String filePath) throws IOException {
        LocatedBlocks locatedBlocks = client.getLocatedBlocks(filePath, 0L);
        LocatedBlock locatedBlock = locatedBlocks.get(0);
        DatanodeInfoWithStorage[] datanodes = locatedBlock.getLocations();
        DatanodeInfoWithStorage chosenDn = datanodes[new Random().nextInt(datanodes.length)];
        int idx = 0;
        for (DataNode dn : cluster.getDataNodes()) {
            if (dn.getInfoPort() == chosenDn.getInfoPort()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    static {
        cellSize = ecPolicy.getCellSize();
        blockSize = cellSize * 6;
        stripSize = cellSize * dataBlocks;
        blockGroupSize = 6 * stripSize;
        fileSize = 10 * blockGroupSize;
    }
}

