/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.ErasureCodeBenchmarkThroughput;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=300L)
public class TestErasureCodeBenchmarkThroughput {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;

    @BeforeAll
    public static void setup() throws IOException {
        conf = new HdfsConfiguration();
        int numDN = ErasureCodeBenchmarkThroughput.getEcPolicy().getNumDataUnits() + ErasureCodeBenchmarkThroughput.getEcPolicy().getNumParityUnits();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDN).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        ((DistributedFileSystem)fs).enableErasureCodingPolicy(ErasureCodeBenchmarkThroughput.getEcPolicy().getName());
    }

    @AfterAll
    public static void tearDown() {
        if (cluster != null) {
            cluster.shutdown(true);
        }
    }

    private static void runBenchmark(String[] args) throws Exception {
        Assertions.assertNotNull((Object)conf);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new ErasureCodeBenchmarkThroughput(fs), (String[])args));
    }

    private static void verifyNumFile(final int dataSize, final boolean isEc, int numFile) throws IOException {
        Path path = isEc ? new Path(ErasureCodeBenchmarkThroughput.EC_DIR) : new Path(ErasureCodeBenchmarkThroughput.REP_DIR);
        FileStatus[] statuses = fs.listStatus(path, new PathFilter(){

            public boolean accept(Path path) {
                return path.toString().contains(ErasureCodeBenchmarkThroughput.getFilePath(dataSize, isEc));
            }
        });
        Assertions.assertEquals((int)numFile, (int)statuses.length);
    }

    @Test
    public void testReplicaReadWrite() throws Exception {
        Integer dataSize = 10;
        Integer numClient = 3;
        String[] args = new String[]{"write", dataSize.toString(), "rep", numClient.toString()};
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
        args[0] = "gen";
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
        args[0] = "read";
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
    }

    @Test
    public void testECReadWrite() throws Exception {
        Integer dataSize = 5;
        Integer numClient = 5;
        String[] args = new String[]{"write", dataSize.toString(), "ec", numClient.toString()};
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
        args[0] = "gen";
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
        args[0] = "read";
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
    }

    @Test
    public void testCleanUp() throws Exception {
        Integer dataSize = 5;
        Integer numClient = 5;
        String[] args = new String[]{"gen", dataSize.toString(), "ec", numClient.toString()};
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
        args[0] = "clean";
        TestErasureCodeBenchmarkThroughput.runBenchmark(args);
        TestErasureCodeBenchmarkThroughput.verifyNumFile(dataSize, true, 0);
    }
}

