/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestEncryptionZonesWithHA {
    private Configuration conf;
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private NameNode nn1;
    private DistributedFileSystem fs;
    private HdfsAdmin dfsAdmin0;
    private HdfsAdmin dfsAdmin1;
    private FileSystemTestHelper fsHelper;
    private File testRootDir;
    private final String TEST_KEY = "test_key";
    protected static final EnumSet<CreateEncryptionZoneFlag> NO_TRASH = EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH);

    @BeforeEach
    public void setupCluster() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        this.conf.set("hadoop.security.key.provider.path", "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri());
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        DFSTestUtil.createKey("test_key", this.cluster, 0, this.conf);
        DFSTestUtil.createKey("test_key", this.cluster, 1, this.conf);
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.dfsAdmin0 = new HdfsAdmin(this.cluster.getURI(0), this.conf);
        this.dfsAdmin1 = new HdfsAdmin(this.cluster.getURI(1), this.conf);
        KeyProviderCryptoExtension nn0Provider = this.cluster.getNameNode(0).getNamesystem().getProvider();
        this.fs.getClient().setKeyProvider((KeyProvider)nn0Provider);
    }

    @AfterEach
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testEncryptionZonesTrackedOnStandby() throws Exception {
        int len = 8196;
        Path dir = new Path("/enc");
        Path dirChild = new Path(dir, "child");
        Path dirFile = new Path(dir, "file");
        this.fs.mkdir(dir, FsPermission.getDirDefault());
        this.dfsAdmin0.createEncryptionZone(dir, "test_key", NO_TRASH);
        this.fs.mkdir(dirChild, FsPermission.getDirDefault());
        DFSTestUtil.createFile((FileSystem)this.fs, dirFile, 8196L, (short)1, 65261L);
        String contents = DFSTestUtil.readFile((FileSystem)this.fs, dirFile);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        Assertions.assertEquals((Object)dir.toString(), (Object)this.dfsAdmin1.getEncryptionZoneForPath(dir).getPath().toString(), (String)"Got unexpected ez path");
        Assertions.assertEquals((Object)dir.toString(), (Object)this.dfsAdmin1.getEncryptionZoneForPath(dirChild).getPath().toString(), (String)"Got unexpected ez path");
        Assertions.assertEquals((Object)contents, (Object)DFSTestUtil.readFile((FileSystem)this.fs, dirFile), (String)"File contents after failover were changed");
    }
}

