/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.server.namenode.EncryptionFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestEnclosingRoot
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestEnclosingRoot.class);
    private static final String TEST_KEY = "test_key";
    private static final EnumSet<CreateEncryptionZoneFlag> NO_TRASH = EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH);
    private Configuration conf;
    private FileSystemTestHelper fsHelper;
    private MiniDFSCluster cluster;
    private HdfsAdmin dfsAdmin;
    private DistributedFileSystem fs;
    private File testRootDir;

    private String getKeyProviderURI() {
        return "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri();
    }

    @BeforeEach
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        this.conf.set("hadoop.security.key.provider.path", this.getKeyProviderURI());
        this.conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(EncryptionZoneManager.class), (Level)Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.dfsAdmin = new HdfsAdmin(this.cluster.getURI(), this.conf);
        this.setProvider();
        DFSTestUtil.createKey(TEST_KEY, this.cluster, this.conf);
    }

    protected void setProvider() {
        this.fs.getClient().setKeyProvider((KeyProvider)this.cluster.getNameNode().getNamesystem().getProvider());
    }

    @AfterEach
    public void teardown() {
        try {
            if (this.cluster != null) {
                this.cluster.shutdown();
                this.cluster = null;
            }
        }
        finally {
            EncryptionFaultInjector.instance = new EncryptionFaultInjector();
        }
    }

    @Test
    public void testBasicOperations() throws Exception {
        Path rootDir = new Path("/");
        Path zone1 = new Path(rootDir, "zone1");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.fs.getEnclosingRoot(rootDir)).describedAs("enclosing root of %s", new Object[]{rootDir})).isEqualTo((Object)rootDir);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.fs.getEnclosingRoot(zone1)).describedAs("enclosing root of %s", new Object[]{zone1})).isEqualTo((Object)rootDir);
        this.fs.mkdirs(zone1);
        this.dfsAdmin.createEncryptionZone(zone1, TEST_KEY, NO_TRASH);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.fs.getEnclosingRoot(rootDir)).describedAs("enclosing root of %s", new Object[]{rootDir})).isEqualTo((Object)rootDir);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.fs.getEnclosingRoot(zone1)).describedAs("enclosing root of %s", new Object[]{zone1})).isEqualTo((Object)zone1);
        Path zone1FileDNE = new Path(zone1, "newDNE.txt");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.fs.getEnclosingRoot(zone1FileDNE)).describedAs("enclosing root of %s", new Object[]{zone1FileDNE})).isEqualTo((Object)zone1);
        Path zone1DirDNE = new Path(zone1, "zone2/newDNE.txt");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.fs.getEnclosingRoot(zone1DirDNE)).describedAs("enclosing root of %s", new Object[]{zone1DirDNE})).isEqualTo((Object)zone1);
    }
}

