/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.LeaseRenewer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestDistributedFileSystem {
    private static final Random RAN = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(TestDistributedFileSystem.class);
    private boolean dualPortTesting = false;
    private boolean noXmlDefaults = false;

    HdfsConfiguration getTestConfiguration() {
        HdfsConfiguration conf;
        if (this.noXmlDefaults) {
            conf = new HdfsConfiguration(false);
            String namenodeDir = new File(MiniDFSCluster.getBaseDirectory(), "name").getAbsolutePath();
            conf.set("dfs.namenode.name.dir", namenodeDir);
            conf.set("dfs.namenode.edits.dir", namenodeDir);
        } else {
            conf = new HdfsConfiguration();
        }
        if (this.dualPortTesting) {
            conf.set("dfs.namenode.servicerpc-address", "localhost:0");
        }
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyDelegationToken() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.getDelegationToken("");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemCloseAll() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        URI address = FileSystem.getDefaultUri((Configuration)conf);
        try {
            FileSystem.closeAll();
            conf = this.getTestConfiguration();
            FileSystem.setDefaultUri((Configuration)conf, (URI)address);
            FileSystem.get((Configuration)conf);
            FileSystem.get((Configuration)conf);
            FileSystem.closeAll();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClose() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.create(new Path("/test/dfsclose/file-1"));
            ArrayList<OpenFilesIterator.OpenFilesType> types = new ArrayList<OpenFilesIterator.OpenFilesType>();
            types.add(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES);
            RemoteIterator listOpenFiles = fileSys.listOpenFiles(EnumSet.copyOf(types));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)listOpenFiles.hasNext(), (String)"Two files should be open");
            int countOpenFiles = 0;
            while (listOpenFiles.hasNext()) {
                listOpenFiles.next();
                ++countOpenFiles;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)countOpenFiles, (String)"Mismatch of open files count");
            Path p = new Path("/non-empty-file");
            DFSTestUtil.createFile((FileSystem)fileSys, p, 1L, (short)1, 0L);
            DFSTestUtil.readFile((FileSystem)fileSys, p);
            fileSys.close();
            DFSClient dfsClient = fileSys.getClient();
            this.verifyOpsUsingClosedClient(dfsClient);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyOpsUsingClosedClient(DFSClient dfsClient) {
        Path p = new Path("/non-empty-file");
        try {
            dfsClient.getBlockSize(p.getName());
            org.junit.jupiter.api.Assertions.fail((String)"getBlockSize using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getServerDefaults();
            org.junit.jupiter.api.Assertions.fail((String)"getServerDefaults using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.reportBadBlocks(new LocatedBlock[0]);
            org.junit.jupiter.api.Assertions.fail((String)"reportBadBlocks using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getBlockLocations(p.getName(), 0L, 1L);
            org.junit.jupiter.api.Assertions.fail((String)"getBlockLocations using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.createSymlink("target", "link", true);
            org.junit.jupiter.api.Assertions.fail((String)"createSymlink using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getLinkTarget(p.getName());
            org.junit.jupiter.api.Assertions.fail((String)"getLinkTarget using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.setReplication(p.getName(), (short)3);
            org.junit.jupiter.api.Assertions.fail((String)"setReplication using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.setStoragePolicy(p.getName(), "ONE_SSD");
            org.junit.jupiter.api.Assertions.fail((String)"setStoragePolicy using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getStoragePolicies();
            org.junit.jupiter.api.Assertions.fail((String)"getStoragePolicies using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            org.junit.jupiter.api.Assertions.fail((String)"setSafeMode using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.refreshNodes();
            org.junit.jupiter.api.Assertions.fail((String)"refreshNodes using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.metaSave(p.getName());
            org.junit.jupiter.api.Assertions.fail((String)"metaSave using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.setBalancerBandwidth(1000L);
            org.junit.jupiter.api.Assertions.fail((String)"setBalancerBandwidth using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.finalizeUpgrade();
            org.junit.jupiter.api.Assertions.fail((String)"finalizeUpgrade using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
            org.junit.jupiter.api.Assertions.fail((String)"rollingUpgrade using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getInotifyEventStream();
            org.junit.jupiter.api.Assertions.fail((String)"getInotifyEventStream using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getInotifyEventStream(100L);
            org.junit.jupiter.api.Assertions.fail((String)"getInotifyEventStream using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.saveNamespace(1000L, 200L);
            org.junit.jupiter.api.Assertions.fail((String)"saveNamespace using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.rollEdits();
            org.junit.jupiter.api.Assertions.fail((String)"rollEdits using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.restoreFailedStorage("");
            org.junit.jupiter.api.Assertions.fail((String)"restoreFailedStorage using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.getContentSummary(p.getName());
            org.junit.jupiter.api.Assertions.fail((String)"getContentSummary using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.setQuota(p.getName(), 1000L, 500L);
            org.junit.jupiter.api.Assertions.fail((String)"setQuota using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfsClient.setQuotaByStorageType(p.getName(), StorageType.DISK, 500L);
            org.junit.jupiter.api.Assertions.fail((String)"setQuotaByStorageType using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
    }

    @Test
    public void testDFSCloseOrdering() throws Exception {
        MyDistributedFileSystem fs = new MyDistributedFileSystem();
        Path path = new Path("/a");
        fs.deleteOnExit(path);
        fs.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{fs.dfs});
        ((DFSClient)inOrder.verify((Object)fs.dfs)).closeOutputStreams(ArgumentMatchers.eq((boolean)false));
        ((DFSClient)inOrder.verify((Object)fs.dfs)).delete((String)ArgumentMatchers.eq((Object)path.toString()), ArgumentMatchers.eq((boolean)true));
        ((DFSClient)inOrder.verify((Object)fs.dfs)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSSeekExceptions() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            String file = "/test/fileclosethenseek/file-0";
            Path path = new Path(file);
            FSDataOutputStream output = fileSys.create(path);
            output.writeBytes("Some test data to write longer than 10 bytes");
            output.close();
            FSDataInputStream input = fileSys.open(path);
            input.seek(10L);
            boolean threw = false;
            try {
                input.seek(100L);
            }
            catch (IOException e) {
                threw = true;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)threw, (String)"Failed to throw IOE when seeking past end");
            input.close();
            threw = false;
            try {
                input.seek(1L);
            }
            catch (IOException e) {
                threw = true;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)threw, (String)"Failed to throw IOE when seeking after close");
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClient() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        long grace = 1000L;
        MiniDFSCluster cluster = null;
        LeaseRenewer.setLeaseRenewerGraceDefault((long)1000L);
        try {
            FSDataInputStream in2;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            String filepathstring = "/test/LeaseChecker/foo";
            Path[] filepaths = new Path[4];
            for (int i = 0; i < filepaths.length; ++i) {
                filepaths[i] = new Path("/test/LeaseChecker/foo" + i);
            }
            long millis = Time.now();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Method checkMethod = dfs.dfs.getLeaseRenewer().getClass().getDeclaredMethod("isRunning", new Class[0]);
            checkMethod.setAccessible(true);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out = dfs.create(filepaths[0]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out.writeLong(millis);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out.close();
            Thread.sleep(750L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            for (int i = 0; i < 3; ++i) {
                if (!((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])).booleanValue()) continue;
                Thread.sleep(500L);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out1 = dfs.create(filepaths[1]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out2 = dfs.create(filepaths[2]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out1.writeLong(millis);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out1.close();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out2.writeLong(millis);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out2.close();
            Thread.sleep(750L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            FSDataOutputStream out3 = dfs.create(filepaths[3]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            Thread.sleep(750L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out3.writeLong(millis);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            out3.close();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            Thread.sleep(750L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            for (int i = 0; i < 3; ++i) {
                if (!((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])).booleanValue()) continue;
                Thread.sleep(500L);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            dfs.close();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/wrwelkj");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(dir), (String)"File should not exist for test.");
            try {
                in2 = fs.open(dir);
                try {
                    in2.close();
                    fs.close();
                }
                finally {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)false, (String)"Did not get a FileNotFoundException for non-existing file.");
                }
            }
            catch (FileNotFoundException in2) {
                // empty catch block
            }
            dfs = cluster.getFileSystem();
            checkMethod = dfs.dfs.getLeaseRenewer().getClass().getDeclaredMethod("isRunning", new Class[0]);
            checkMethod.setAccessible(true);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            in2 = dfs.open(filepaths[0]);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            org.junit.jupiter.api.Assertions.assertEquals((long)millis, (long)in2.readLong());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            in2.close();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)checkMethod.invoke((Object)dfs.dfs.getLeaseRenewer(), new Object[0])));
            dfs.close();
            String uri = "hdfs://127.0.0.1:" + cluster.getNameNodePort() + "/test/ipAddress/file";
            Path path = new Path(uri);
            FileSystem fs2 = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            FSDataOutputStream out4 = fs2.create(path);
            byte[] buf = new byte[1024];
            out4.write(buf);
            out4.close();
            FSDataInputStream in3 = fs2.open(path);
            in3.readFully(buf);
            in3.close();
            fs2.close();
            fs = cluster.getFileSystem();
            fs.mkdirs(new Path("/test/nonEmptyDir"));
            fs.create(new Path("/tmp/nonEmptyDir/emptyFile")).close();
            try {
                fs.delete(new Path("/tmp/nonEmptyDir"), false);
                org.junit.jupiter.api.Assertions.fail((String)"Expecting PathIsNotEmptyDirectoryException");
            }
            catch (PathIsNotEmptyDirectoryException pathIsNotEmptyDirectoryException) {
                // empty catch block
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(new Path("/test/nonEmptyDir")));
            fs.delete(new Path("/tmp/nonEmptyDir"), true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearStatistics() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/testClearStatistics");
            long mkdirCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            long writeCount = DFSTestUtil.getStatistics((FileSystem)dfs).getWriteOps();
            dfs.mkdirs(dir);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, mkdirCount + 1L);
            org.junit.jupiter.api.Assertions.assertEquals((long)(++writeCount), (long)DFSTestUtil.getStatistics((FileSystem)dfs).getWriteOps());
            long createCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.CREATE);
            FSDataOutputStream out = dfs.create(new Path(dir, "tmpFile"), (short)1);
            out.write(40);
            out.close();
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE, createCount + 1L);
            org.junit.jupiter.api.Assertions.assertEquals((long)(++writeCount), (long)DFSTestUtil.getStatistics((FileSystem)dfs).getWriteOps());
            FileSystem.clearStatistics();
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, 0L);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE, 0L);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, 0, 0, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testGetListingLimit() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.ls.limit", 9);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();){
            cluster.waitActive();
            ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.dfs = (DFSClient)Mockito.spy((Object)fs.dfs);
            Path dir1 = new Path("/testRep");
            Path dir2 = new Path("/testEC");
            fs.mkdirs(dir1);
            fs.mkdirs(dir2);
            fs.setErasureCodingPolicy(dir2, ecPolicy.getName());
            for (int i = 0; i < 3; ++i) {
                DFSTestUtil.createFile((FileSystem)fs, new Path(dir1, String.valueOf(i)), 20480L, (short)3, 1L);
                DFSTestUtil.createStripedFile(cluster, new Path(dir2, String.valueOf(i)), dir2, 1, 1, false);
            }
            List str = RemoteIterators.toList((RemoteIterator)fs.listLocatedStatus(dir1));
            Assertions.assertThat((List)str).hasSize(3);
            ((DFSClient)Mockito.verify((Object)fs.dfs, (VerificationMode)Mockito.times((int)1))).listPaths(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
            str = RemoteIterators.toList((RemoteIterator)fs.listLocatedStatus(dir2));
            Assertions.assertThat((List)str).hasSize(3);
            ((DFSClient)Mockito.verify((Object)fs.dfs, (VerificationMode)Mockito.times((int)4))).listPaths(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatistics() throws IOException {
        FileSystem.getStatistics((String)"hdfs", DistributedFileSystem.class).reset();
        ThreadLocal data = (ThreadLocal)Whitebox.getInternalState((Object)FileSystem.getStatistics((String)"hdfs", DistributedFileSystem.class), (String)"threadData");
        data.set(null);
        int lsLimit = 2;
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.ls.limit", lsLimit);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/test");
            Path file = new Path(dir, "file");
            int readOps = 0;
            int writeOps = 0;
            int largeReadOps = 0;
            long opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            fs.mkdirs(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.CREATE);
            FSDataOutputStream out = fs.create(file, (short)1);
            out.close();
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_STATUS);
            FileStatus status = fs.getFileStatus(file);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_STATUS, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS);
            fs.getFileBlockLocations(file, 0L, 0L);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS, opCount + 1L);
            fs.getFileBlockLocations(status, 0L, 0L);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS, opCount + 2L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.OPEN);
            FSDataInputStream in = fs.open(file);
            in.close();
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.OPEN, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_REPLICATION);
            fs.setReplication(file, (short)2);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_REPLICATION, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.RENAME);
            Path file1 = new Path(dir, "file1");
            fs.rename(file, file1);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.RENAME, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_CONTENT_SUMMARY);
            fs.getContentSummary(file1);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_CONTENT_SUMMARY, opCount + 1L);
            long mkdirOp = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            long listStatusOp = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.LIST_STATUS);
            long locatedListStatusOP = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.LIST_LOCATED_STATUS);
            for (int i = 0; i < 10; ++i) {
                Path p = new Path(dir, Integer.toString(i));
                fs.mkdirs(p);
                ++mkdirOp;
                FileStatus[] list = fs.listStatus(dir);
                if (list.length > lsLimit) {
                    int iterations = (int)Math.ceil((double)list.length / (double)lsLimit);
                    largeReadOps += iterations;
                    readOps += iterations;
                    listStatusOp += (long)iterations;
                } else {
                    ++readOps;
                    ++listStatusOp;
                }
                TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
                TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, mkdirOp);
                TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.LIST_STATUS, listStatusOp);
                fs.listLocatedStatus(dir);
                TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
                TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.LIST_LOCATED_STATUS, ++locatedListStatusOP);
            }
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_STATUS);
            fs.getStatus(file1);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_STATUS, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM);
            fs.getFileChecksum(file1);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_PERMISSION);
            fs.setPermission(file1, new FsPermission(511));
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_PERMISSION, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_TIMES);
            fs.setTimes(file1, 0L, 0L);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_TIMES, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_OWNER);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            fs.setOwner(file1, ugi.getUserName(), ugi.getGroupNames()[0]);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_OWNER, opCount + 1L);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.DELETE);
            fs.delete(dir, true);
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.DELETE, opCount + 1L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testStatistics2() throws IOException, NoSuchAlgorithmException {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        File tmpDir = GenericTestUtils.getTestDir((String)UUID.randomUUID().toString());
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        conf.set("hadoop.security.key.provider.path", "jceks://file" + jksPath.toUri());
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/testStat");
            dfs.mkdirs(dir);
            int readOps = 0;
            int writeOps = 0;
            FileSystem.clearStatistics();
            long opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_QUOTA_USAGE);
            dfs.setQuota(dir, 100L, 1000L);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_QUOTA_USAGE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_QUOTA_BYTSTORAGEYPE);
            dfs.setQuotaByStorageType(dir, StorageType.DEFAULT, 2000L);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_QUOTA_BYTSTORAGEYPE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_QUOTA_USAGE);
            dfs.getQuotaUsage(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_QUOTA_USAGE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SATISFY_STORAGE_POLICY);
            dfs.satisfyStoragePolicy(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SATISFY_STORAGE_POLICY, opCount + 1L);
            CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.ADD_CACHE_POOL);
            dfs.addCachePool(cacheInfo);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.ADD_CACHE_POOL, opCount + 1L);
            CacheDirectiveInfo directive = new CacheDirectiveInfo.Builder().setPath(new Path(".")).setPool("pool1").build();
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.ADD_CACHE_DIRECTIVE);
            long id = dfs.addCacheDirective(directive);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.ADD_CACHE_DIRECTIVE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.LIST_CACHE_DIRECTIVE);
            dfs.listCacheDirectives(null);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.LIST_CACHE_DIRECTIVE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MODIFY_CACHE_DIRECTIVE);
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setReplication(Short.valueOf((short)2)).build());
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MODIFY_CACHE_DIRECTIVE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.REMOVE_CACHE_DIRECTIVE);
            dfs.removeCacheDirective(id);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.REMOVE_CACHE_DIRECTIVE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MODIFY_CACHE_POOL);
            dfs.modifyCachePool(cacheInfo);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MODIFY_CACHE_POOL, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.LIST_CACHE_POOL);
            dfs.listCachePools();
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.LIST_CACHE_POOL, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.REMOVE_CACHE_POOL);
            dfs.removeCachePool(cacheInfo.getPoolName());
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.REMOVE_CACHE_POOL, opCount + 1L);
            KeyProviderCryptoExtension provider = cluster.getNameNode().getNamesystem().getProvider();
            KeyProvider.Options options = KeyProvider.options((Configuration)conf);
            provider.createKey("key", options);
            provider.flush();
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.CREATE_ENCRYPTION_ZONE);
            dfs.createEncryptionZone(dir, "key");
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.CREATE_ENCRYPTION_ZONE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.LIST_ENCRYPTION_ZONE);
            dfs.listEncryptionZones();
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.LIST_ENCRYPTION_ZONE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_ENCRYPTION_ZONE);
            dfs.getEZForPath(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_ENCRYPTION_ZONE, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_ENCLOSING_ROOT);
            dfs.getEnclosingRoot(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_ENCLOSING_ROOT, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_SNAPSHOTTABLE_DIRECTORY_LIST);
            dfs.getSnapshottableDirListing();
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_SNAPSHOTTABLE_DIRECTORY_LIST, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICIES);
            dfs.getAllStoragePolicies();
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICIES, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_TRASH_ROOT);
            dfs.getTrashRoot(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_TRASH_ROOT, opCount + 1L);
        }
    }

    @Test
    public void testECStatistics() throws IOException {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)this.getTestConfiguration()).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/test");
            dfs.mkdirs(dir);
            int readOps = 0;
            int writeOps = 0;
            FileSystem.clearStatistics();
            long opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.ENABLE_EC_POLICY);
            dfs.enableErasureCodingPolicy("RS-10-4-1024k");
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.ENABLE_EC_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SET_EC_POLICY);
            dfs.setErasureCodingPolicy(dir, "RS-10-4-1024k");
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SET_EC_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_EC_POLICY);
            dfs.getErasureCodingPolicy(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_EC_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.UNSET_EC_POLICY);
            dfs.unsetErasureCodingPolicy(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.UNSET_EC_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_EC_POLICIES);
            dfs.getAllErasureCodingPolicies();
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_EC_POLICIES, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_EC_CODECS);
            dfs.getAllErasureCodingCodecs();
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_EC_CODECS, opCount + 1L);
            ErasureCodingPolicy newPolicy = new ErasureCodingPolicy(new ECSchema("rs", 5, 3), 0x100000);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.ADD_EC_POLICY);
            dfs.addErasureCodingPolicies(new ErasureCodingPolicy[]{newPolicy});
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.ADD_EC_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.REMOVE_EC_POLICY);
            dfs.removeErasureCodingPolicy("RS-5-3-1024k");
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.REMOVE_EC_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.DISABLE_EC_POLICY);
            dfs.disableErasureCodingPolicy("RS-10-4-1024k");
            TestDistributedFileSystem.checkStatistics((FileSystem)dfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.DISABLE_EC_POLICY, opCount + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=180L)
    public void testConcurrentStatistics() throws IOException, InterruptedException {
        FileSystem.getStatistics((String)"hdfs", DistributedFileSystem.class).reset();
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(new Configuration()).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        int numThreads = 5;
        ExecutorService threadPool = HadoopExecutors.newFixedThreadPool((int)5);
        try {
            final CountDownLatch allExecutorThreadsReady = new CountDownLatch(5);
            final CountDownLatch startBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(5);
            final AtomicReference childError = new AtomicReference();
            for (int i = 0; i < 5; ++i) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allExecutorThreadsReady.countDown();
                        try {
                            startBlocker.await();
                            DistributedFileSystem fs = cluster.getFileSystem();
                            fs.mkdirs(new Path("/testStatisticsParallelChild"));
                        }
                        catch (Throwable t) {
                            LOG.error("Child failed when calling mkdir", t);
                            childError.compareAndSet(null, t);
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            long oldMkdirOpCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS);
            allExecutorThreadsReady.await();
            startBlocker.countDown();
            allDone.await();
            org.junit.jupiter.api.Assertions.assertNull(childError.get(), (String)("Child failed with exception " + childError.get()));
            TestDistributedFileSystem.checkStatistics((FileSystem)fs, 0, 5, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.MKDIRS, 5L + oldMkdirOpCount);
            Iterator opCountIter = FileSystem.getGlobalStorageStatistics().get("DFSOpsCountStatistics").getLongStatistics();
            while (opCountIter.hasNext()) {
                StorageStatistics.LongStatistic opCount = (StorageStatistics.LongStatistic)opCountIter.next();
                if (DFSOpsCountStatistics.OpType.MKDIRS.getSymbol().equals(opCount.getName())) {
                    org.junit.jupiter.api.Assertions.assertEquals((long)(5L + oldMkdirOpCount), (long)opCount.getValue(), (String)"Unexpected op count from iterator!");
                }
                LOG.info(opCount.getName() + "\t" + opCount.getValue());
            }
        }
        finally {
            threadPool.shutdownNow();
            cluster.shutdown();
        }
    }

    public static void checkStatistics(FileSystem fs, int readOps, int writeOps, int largeReadOps) {
        org.junit.jupiter.api.Assertions.assertEquals((int)readOps, (int)DFSTestUtil.getStatistics(fs).getReadOps());
        org.junit.jupiter.api.Assertions.assertEquals((int)writeOps, (int)DFSTestUtil.getStatistics(fs).getWriteOps());
        org.junit.jupiter.api.Assertions.assertEquals((int)largeReadOps, (int)DFSTestUtil.getStatistics(fs).getLargeReadOps());
    }

    private void checkReadStatistics(FileSystem fs, int distance, long expectedReadBytes) {
        long bytesRead = DFSTestUtil.getStatistics(fs).getBytesReadByDistance(distance);
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedReadBytes, (long)bytesRead);
    }

    @Test
    public void testLocalHostReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(0, false, false);
    }

    @Test
    public void testLocalRackReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(2, false, false);
    }

    @Test
    public void testRemoteRackOfFirstDegreeReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(4, false, false);
    }

    @Test
    public void testInvalidScriptMappingFileReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(0, true, true);
    }

    @Test
    public void testEmptyScriptMappingFileReadStatistics() throws Exception {
        this.testReadFileSystemStatistics(0, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFileSystemStatistics(int expectedDistance, boolean useScriptMapping, boolean invalidScriptMappingFile) throws IOException {
        MiniDFSCluster cluster = null;
        StaticMapping.addNodeToRack((String)NetUtils.getLocalHostname(), (String)"/rackClient");
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("fs.client.resolve.topology.enabled", true);
        conf.set("dfs.client.context", "testContext_" + expectedDistance);
        if (useScriptMapping) {
            conf.setClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
            if (invalidScriptMappingFile) {
                conf.set("net.topology.script.file.name", "invalidScriptFile.txt");
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).useConfiguredTopologyMappingClass(true).build();
        } else if (expectedDistance == 0) {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).hosts(new String[]{NetUtils.getLocalHostname()}).build();
        } else if (expectedDistance == 2) {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(new String[]{"/rackClient"}).build();
        } else if (expectedDistance == 4) {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(new String[]{"/rackFoo"}).build();
        }
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.getStatistics((FileSystem)fs).reset();
            Path dir = new Path("/test");
            Path file = new Path(dir, "file");
            String input = "hello world";
            DFSTestUtil.writeFile((FileSystem)fs, file, input);
            FSDataInputStream stm = fs.open(file);
            byte[] actual = new byte[4096];
            stm.read(actual);
            this.checkReadStatistics((FileSystem)fs, expectedDistance, input.length());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static void checkOpStatistics(DFSOpsCountStatistics.OpType op, long count) {
        org.junit.jupiter.api.Assertions.assertEquals((long)count, (long)TestDistributedFileSystem.getOpStatistics(op), (String)("Op " + op.getSymbol() + " has unexpected count!"));
    }

    public static long getOpStatistics(DFSOpsCountStatistics.OpType op) {
        return GlobalStorageStatistics.INSTANCE.get("DFSOpsCountStatistics").getLong(op.getSymbol());
    }

    @Test
    public void testFileChecksum() throws Exception {
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem hdfs = cluster.getFileSystem();
        String nnAddr = conf.get("dfs.namenode.http-address");
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        try {
            hdfs.getFileChecksum(new Path("/test/TestNonExistingFile"));
            org.junit.jupiter.api.Assertions.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("File does not exist: /test/TestNonExistingFile"), (String)"Not throwing the intended exception message");
        }
        try {
            Path path = new Path("/test/TestExistingDir/");
            hdfs.mkdirs(path);
            hdfs.getFileChecksum(path);
            org.junit.jupiter.api.Assertions.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("Path is not a file: /test/TestExistingDir"), (String)"Not throwing the intended exception message");
        }
        final String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>((Configuration)conf){
            final /* synthetic */ Configuration val$conf;
            {
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws Exception {
                return new Path(webhdfsuri).getFileSystem(this.val$conf);
            }
        });
        Path dir = new Path("/filechecksum");
        int block_size = 1024;
        int buffer_size = conf.getInt("io.file.buffer.size", 4096);
        conf.setInt("dfs.bytes-per-checksum", 512);
        for (int n = 0; n < 5; ++n) {
            byte[] data = new byte[RAN.nextInt(511) + n * 1024 + 1];
            RAN.nextBytes(data);
            System.out.println("data.length=" + data.length);
            Path foo = new Path(dir, "foo" + n);
            FSDataOutputStream out = hdfs.create(foo, false, buffer_size, (short)2, 1024L);
            out.write(data);
            out.close();
            FileChecksum hdfsfoocs = hdfs.getFileChecksum(foo);
            System.out.println("hdfsfoocs=" + hdfsfoocs);
            FileChecksum webhdfsfoocs = webhdfs.getFileChecksum(foo);
            System.out.println("webhdfsfoocs=" + webhdfsfoocs);
            Path webhdfsqualified = new Path(webhdfsuri + dir, "foo" + n);
            FileChecksum webhdfs_qfoocs = webhdfs.getFileChecksum(webhdfsqualified);
            System.out.println("webhdfs_qfoocs=" + webhdfs_qfoocs);
            Path zeroByteFile = new Path(dir, "zeroByteFile" + n);
            FSDataOutputStream out2 = hdfs.create(zeroByteFile, false, buffer_size, (short)2, 1024L);
            out2.close();
            Path bar = new Path(dir, "bar" + n);
            FSDataOutputStream out3 = hdfs.create(bar, false, buffer_size, (short)2, 1024L);
            out3.write(data);
            out3.close();
            FileChecksum zeroChecksum = hdfs.getFileChecksum(zeroByteFile);
            String magicValue = "MD5-of-0MD5-of-0CRC32:70bc8f4b72a86921468bf8e8441dce51";
            org.junit.jupiter.api.Assertions.assertEquals((Object)"MD5-of-0MD5-of-0CRC32:70bc8f4b72a86921468bf8e8441dce51", (Object)zeroChecksum.toString());
            FileChecksum checksumWith0 = hdfs.getFileChecksum(bar, 0L);
            org.junit.jupiter.api.Assertions.assertEquals((Object)zeroChecksum, (Object)checksumWith0);
            FileChecksum barcs = hdfs.getFileChecksum(bar);
            int barhashcode = barcs.hashCode();
            org.junit.jupiter.api.Assertions.assertEquals((int)hdfsfoocs.hashCode(), (int)barhashcode);
            org.junit.jupiter.api.Assertions.assertEquals((Object)hdfsfoocs, (Object)barcs);
            org.junit.jupiter.api.Assertions.assertEquals((int)webhdfsfoocs.hashCode(), (int)barhashcode);
            org.junit.jupiter.api.Assertions.assertEquals((Object)webhdfsfoocs, (Object)barcs);
            org.junit.jupiter.api.Assertions.assertEquals((int)webhdfs_qfoocs.hashCode(), (int)barhashcode);
            org.junit.jupiter.api.Assertions.assertEquals((Object)webhdfs_qfoocs, (Object)barcs);
            hdfs.setPermission(dir, new FsPermission(0));
            try {
                webhdfs.getFileChecksum(webhdfsqualified);
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info("GOOD: getting an exception", (Throwable)ioe);
            }
            hdfs.setPermission(dir, new FsPermission(511));
        }
        cluster.shutdown();
    }

    @Test
    public void testAllWithDualPort() throws Exception {
        this.dualPortTesting = true;
        try {
            this.testFileSystemCloseAll();
            this.testDFSClose();
            this.testDFSClient();
            this.testFileChecksum();
        }
        finally {
            this.dualPortTesting = false;
        }
    }

    @Test
    public void testAllWithNoXmlDefaults() throws Exception {
        this.noXmlDefaults = true;
        try {
            this.testFileSystemCloseAll();
            this.testDFSClose();
            this.testDFSClient();
            this.testFileChecksum();
        }
        finally {
            this.noXmlDefaults = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testLocatedFileStatusStorageIdsTypes() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testListLocatedStatus");
            int blockSize = 4096;
            int numBlocks = 10;
            int repl = 2;
            DFSTestUtil.createFile((FileSystem)fs, testFile, 4096, 40960L, 4096L, (short)2, 712173L);
            DFSTestUtil.waitForReplication(fs, testFile, (short)2, 30000);
            RemoteIterator it = fs.listLocatedStatus(testFile);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext(), (String)"Expected file to be present");
            LocatedFileStatus stat = (LocatedFileStatus)it.next();
            BlockLocation[] locs = stat.getBlockLocations();
            org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)locs.length, (String)"Unexpected number of locations");
            HashSet<String> dnStorageIds = new HashSet<String>();
            for (DataNode d : cluster.getDataNodes()) {
                FsDatasetSpi.FsVolumeReferences volumes = d.getFSDataset().getFsVolumeReferences();
                Throwable throwable = null;
                try {
                    for (FsVolumeSpi vol : volumes) {
                        dnStorageIds.add(vol.getStorageID());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (volumes == null) continue;
                    if (throwable != null) {
                        try {
                            volumes.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    volumes.close();
                }
            }
            for (BlockLocation loc : locs) {
                String[] ids = loc.getStorageIds();
                HashSet storageIds = new HashSet();
                Collections.addAll(storageIds, ids);
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)storageIds.size(), (String)"Unexpected num storage ids");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)dnStorageIds.containsAll(storageIds), (String)"Unknown storage IDs found!");
                StorageType[] types = loc.getStorageTypes();
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)types.length, (String)"Unexpected num storage types");
                for (StorageType t : types) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)StorageType.DEFAULT, (Object)t, (String)"Unexpected storage type");
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithCustomChecksum() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        Path testBasePath = new Path("/test/csum");
        Path path1 = new Path(testBasePath, "file_wtih_crc1");
        Path path2 = new Path(testBasePath, "file_with_crc2");
        Options.ChecksumOpt opt1 = new Options.ChecksumOpt(DataChecksum.Type.CRC32C, 512);
        Options.ChecksumOpt opt2 = new Options.ChecksumOpt(DataChecksum.Type.CRC32, 512);
        FsPermission perm = FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)conf));
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.OVERWRITE, CreateFlag.CREATE);
        short repl = 1;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(testBasePath);
            FSDataOutputStream out1 = dfs.create(path1, perm, flags, 4096, repl, 131072L, null, opt1);
            FSDataOutputStream out2 = dfs.create(path2, perm, flags, 4096, repl, 131072L, null, opt2);
            for (int i = 0; i < 1024; ++i) {
                out1.write(i);
                out2.write(i);
            }
            out1.close();
            out2.close();
            MD5MD5CRC32FileChecksum sum1 = (MD5MD5CRC32FileChecksum)dfs.getFileChecksum(path1);
            MD5MD5CRC32FileChecksum sum2 = (MD5MD5CRC32FileChecksum)dfs.getFileChecksum(path2);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)sum1.equals((Object)sum2));
            org.junit.jupiter.api.Assertions.assertEquals((Object)DataChecksum.Type.CRC32C, (Object)sum1.getCrcType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)DataChecksum.Type.CRC32, (Object)sum2.getCrcType());
        }
        finally {
            if (cluster != null) {
                cluster.getFileSystem().delete(testBasePath, true);
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testFileCloseStatus() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file = new Path("/simpleFlush.dat");
            FSDataOutputStream output = fs.create(file);
            output.writeBytes("Some test data");
            output.flush();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.isFileClosed(file), (String)"File status should be open");
            output.close();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isFileClosed(file), (String)"File status should be closed");
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testCreateWithStoragePolicy() throws Throwable {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.SSD}).storagesPerDatanode(3).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            Path file1 = new Path("/tmp/file1");
            Path file2 = new Path("/tmp/file2");
            fs.mkdirs(new Path("/tmp"));
            fs.setStoragePolicy(new Path("/tmp"), "ALL_SSD");
            FSDataOutputStream outputStream = fs.createFile(file1).storagePolicyName("COLD").build();
            outputStream.write(1);
            outputStream.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)StorageType.ARCHIVE, (Object)DFSTestUtil.getAllBlocks((FileSystem)fs, file1).get(0).getStorageTypes()[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)fs.getStoragePolicy(file1).getName(), (Object)"COLD");
            outputStream = fs.createFile(file2).build();
            outputStream.write(1);
            outputStream.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)StorageType.SSD, (Object)DFSTestUtil.getAllBlocks((FileSystem)fs, file2).get(0).getStorageTypes()[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)fs.getStoragePolicy(file2).getName(), (Object)"ALL_SSD");
            outputStream = fs.createFile(new Path("/default")).build();
            outputStream.write(1);
            outputStream.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)StorageType.DISK, (Object)DFSTestUtil.getAllBlocks((FileSystem)fs, new Path("/default")).get(0).getStorageTypes()[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)fs.getStoragePolicy(new Path("/default")).getName(), (Object)"HOT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testListFiles() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path relative = new Path("relative");
            fs.create(new Path(relative, "foo")).close();
            ArrayList<Object> retVal = new ArrayList<Object>();
            RemoteIterator iter = fs.listFiles(relative, true);
            while (iter.hasNext()) {
                retVal.add(iter.next());
            }
            System.out.println("retVal = " + retVal);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testListFilesRecursive() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            Path subDir1 = fs.makeQualified(new Path(dir, "subDir1"));
            Path subDir2 = fs.makeQualified(new Path(dir, "subDir2"));
            fs.create(new Path(dir, "foo1")).close();
            fs.create(new Path(dir, "foo2")).close();
            fs.create(new Path(subDir1, "foo3")).close();
            fs.create(new Path(subDir2, "foo4")).close();
            FileSystem mockFs = (FileSystem)Mockito.spy((Object)fs);
            ((FileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new FileNotFoundException("")}).when((Object)mockFs)).listLocatedStatus((Path)ArgumentMatchers.eq((Object)subDir1));
            List str = RemoteIterators.toList((RemoteIterator)mockFs.listFiles(dir, true));
            Assertions.assertThat((List)str).hasSize(3);
            ((FileSystem)Mockito.doReturn(TestDistributedFileSystem.getMockedIterator(subDir1)).when((Object)mockFs)).listLocatedStatus((Path)ArgumentMatchers.eq((Object)subDir1));
            str = RemoteIterators.toList((RemoteIterator)mockFs.listFiles(dir, true));
            Assertions.assertThat((List)str).hasSize(4);
        }
    }

    private static RemoteIterator<LocatedFileStatus> getMockedIterator(final Path subDir1) {
        return new RemoteIterator<LocatedFileStatus>(){
            private int remainingEntries = 1;

            public boolean hasNext() throws IOException {
                return this.remainingEntries > 0;
            }

            public LocatedFileStatus next() throws IOException {
                --this.remainingEntries;
                return new LocatedFileStatus(0L, false, 1, 1024L, 0L, 0L, null, null, null, null, subDir1, false, false, false, null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListStatusOfSnapshotDirs() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)this.getTestConfiguration()).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.create(new Path("/parent/test1/dfsclose/file-0"));
            Path snapShotDir = new Path("/parent/test1/");
            dfs.allowSnapshot(snapShotDir);
            FileStatus status = dfs.getFileStatus(new Path("/parent/test1"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)status.isSnapshotEnabled());
            status = dfs.getFileStatus(new Path("/parent/"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)status.isSnapshotEnabled());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testDFSClientPeerReadTimeout() throws IOException {
        int timeout = 1000;
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.client.socket-timeout", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            ServerSocket socket = new ServerSocket(0);
            Peer peer = dfs.getClient().newConnectedPeer((InetSocketAddress)socket.getLocalSocketAddress(), null, null);
            long start = Time.now();
            try {
                peer.getInputStream().read();
                org.junit.jupiter.api.Assertions.fail((String)"read should timeout");
            }
            catch (SocketTimeoutException ste) {
                long delta = Time.now() - start;
                if ((double)delta < 900.0) {
                    throw new IOException("read timedout too soon in " + delta + " ms.", ste);
                }
                if ((double)delta > 1100.0) {
                    throw new IOException("read timedout too late in " + delta + " ms.", ste);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testGetServerDefaults() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FsServerDefaults fsServerDefaults = dfs.getServerDefaults();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)fsServerDefaults);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testDFSClientPeerWriteTimeout() throws IOException {
        int timeout = 1000;
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.client.socket-timeout", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            ServerSocket socket = new ServerSocket(0);
            Peer peer = dfs.getClient().newConnectedPeer((InetSocketAddress)socket.getLocalSocketAddress(), null, null);
            long start = Time.now();
            try {
                byte[] buf = new byte[0xA00000];
                peer.getOutputStream().write(buf);
                long delta = Time.now() - start;
                org.junit.jupiter.api.Assertions.fail((String)("write finish in " + delta + " msbut should timedout"));
            }
            catch (SocketTimeoutException ste) {
                long delta = Time.now() - start;
                if ((double)delta < 900.0) {
                    throw new IOException("write timedout too soon in " + delta + " ms.", ste);
                }
                if ((double)delta > 1200.0) {
                    throw new IOException("write timedout too late in " + delta + " ms.", ste);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testTotalDfsUsed() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream File1 = fs.create(new Path("/File1"));
            File1.write("hi".getBytes());
            File1.close();
            FSDataOutputStream File2 = fs.create(new Path("/Folder1/File2"));
            File2.write("hi".getBytes());
            File2.close();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)fs.getUsed(new Path("/Folder1")));
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)fs.getUsed());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSCloseFilesBeingWritten() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.delete(new Path("/test/dfsclose/file-0"), true);
            DFSClient dfsClient = fileSys.getClient();
            DFSClient newDfsClient = new DFSClient(cluster.getFileSystem(0).getUri(), (Configuration)conf);
            LeaseRenewer leaseRenewer = newDfsClient.getLeaseRenewer();
            dfsClient.closeAllFilesBeingWritten(false);
            leaseRenewer.closeClient(newDfsClient);
            org.junit.jupiter.api.Assertions.assertEquals((Object)true, (Object)leaseRenewer.isEmpty());
            org.junit.jupiter.api.Assertions.assertEquals((Object)true, (Object)dfsClient.isFilesBeingWrittenEmpty());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testBuilderSetters(DistributedFileSystem fs) {
        Path testFilePath = new Path("/testBuilderSetters");
        DistributedFileSystem.HdfsDataOutputStreamBuilder builder = fs.createFile(testFilePath);
        ((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)builder.append()).overwrite(false)).newBlock().lazyPersist().noLocalWrite().ecPolicyName("ec-policy").noLocalRack();
        EnumSet flags = builder.getFlags();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)flags.contains(CreateFlag.APPEND));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)flags.contains(CreateFlag.CREATE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)flags.contains(CreateFlag.NEW_BLOCK));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)flags.contains(CreateFlag.NO_LOCAL_WRITE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)flags.contains(CreateFlag.OVERWRITE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)flags.contains(CreateFlag.SYNC_BLOCK));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)flags.contains(CreateFlag.NO_LOCAL_RACK));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ec-policy", (Object)builder.getEcPolicyName());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.shouldReplicate());
    }

    @Test
    public void testHdfsDataOutputStreamBuilderSetParameters() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            this.testBuilderSetters(fs);
        }
    }

    @Test
    public void testDFSDataOutputStreamBuilderForCreation() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        String testFile = "/testDFSDataOutputStreamBuilder";
        Path testFilePath = new Path(testFile);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            Throwable throwable;
            FSDataOutputStream out4;
            DistributedFileSystem fs = cluster.getFileSystem();
            DistributedFileSystem.HdfsDataOutputStreamBuilder builder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(testFilePath).blockSize(4096L)).replication((short)1);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(testFilePath));
            try (FSDataOutputStream out2 = fs.createFile(testFilePath).build();){
                LOG.info("Test create an empty file");
            }
            String content = "This is a test!";
            try (FSDataOutputStream out1 = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(testFilePath).bufferSize(4096)).replication((short)1)).blockSize(4096L)).build();){
                byte[] contentOrigin = content.getBytes(StandardCharsets.UTF_8);
                out1.write(contentOrigin);
            }
            ContractTestUtils.verifyFileContents((FileSystem)fs, (Path)testFilePath, (byte[])content.getBytes());
            try {
                var10_15 = null;
                try (FSDataOutputStream out3 = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(testFilePath).overwrite(false)).build();){
                    org.junit.jupiter.api.Assertions.fail((String)"it should fail to overwrite an existing file");
                }
                catch (Throwable throwable2) {
                    var10_15 = throwable2;
                    throw throwable2;
                }
            }
            catch (FileAlreadyExistsException out3) {
                // empty catch block
            }
            Path nonParentFile = new Path("/parent/test");
            try {
                out4 = fs.createFile(nonParentFile).build();
                throwable = null;
                try {
                    org.junit.jupiter.api.Assertions.fail((String)"parent directory not exist");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out4 != null) {
                        if (throwable != null) {
                            try {
                                out4.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            out4.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException out4) {
                // empty catch block
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(new Path("/parent")), (String)"parent directory should not be created");
            out4 = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)fs.createFile(nonParentFile).recursive()).build();
            throwable = null;
            try {
                out4.write(1);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (out4 != null) {
                    if (throwable != null) {
                        try {
                            out4.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        out4.close();
                    }
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(new Path("/parent")), (String)"parent directory has not been created");
        }
    }

    @Test
    public void testDFSDataOutputStreamBuilderForAppend() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        String testFile = "/testDFSDataOutputStreamBuilderForAppend";
        Path path = new Path(testFile);
        Random random = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            Throwable throwable;
            FSDataOutputStream out;
            DistributedFileSystem fs = cluster.getFileSystem();
            byte[] buf = new byte[16];
            random.nextBytes(buf);
            try {
                out = fs.appendFile(path).build();
                throwable = null;
                try {
                    out.write(buf);
                    org.junit.jupiter.api.Assertions.fail((String)"should fail on appending to non-existent file");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)"non-existent", (Throwable)e);
            }
            random.nextBytes(buf);
            out = fs.createFile(path).build();
            throwable = null;
            try {
                out.write(buf);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            random.nextBytes(buf);
            out = fs.appendFile(path).build();
            throwable = null;
            try {
                out.write(buf);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            FileStatus status = fs.getFileStatus(path);
            org.junit.jupiter.api.Assertions.assertEquals((long)32L, (long)status.getLen());
        }
    }

    @Test
    public void testSuperUserPrivilege() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        File tmpDir = GenericTestUtils.getTestDir((String)UUID.randomUUID().toString());
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        conf.set("hadoop.security.key.provider.path", "jceks://file" + jksPath.toUri());
        try (final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/testPrivilege");
            dfs.mkdirs(dir);
            KeyProviderCryptoExtension provider = cluster.getNameNode().getNamesystem().getProvider();
            KeyProvider.Options options = KeyProvider.options((Configuration)conf);
            provider.createKey("key", options);
            provider.flush();
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"Non_SuperUser", (String[])new String[]{"Non_SuperGroup"});
            DistributedFileSystem userfs = (DistributedFileSystem)user.doAs(() -> FileSystem.get((Configuration)conf));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"Superuser privilege is required", () -> userfs.createEncryptionZone(dir, "key"));
            RemoteException re = (RemoteException)LambdaTestUtils.intercept(RemoteException.class, (String)"Superuser privilege is required", () -> userfs.listEncryptionZones().hasNext());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(re.unwrapRemoteException() instanceof AccessControlException));
            re = (RemoteException)LambdaTestUtils.intercept(RemoteException.class, (String)"Superuser privilege is required", () -> userfs.listReencryptionStatus().hasNext());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(re.unwrapRemoteException() instanceof AccessControlException));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"Superuser privilege is required", () -> (Void)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cluster.getNameNode().getRpcServer().rollEditLog();
                    return null;
                }
            }));
        }
    }

    @Test
    public void testListingStoragePolicyNonSuperUser() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            dfs.setPermission(dir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"Non_SuperUser", (String[])new String[]{"Non_SuperGroup"});
            DistributedFileSystem userfs = (DistributedFileSystem)user.doAs(() -> FileSystem.get((Configuration)conf));
            Path sDir = new Path("/dir/sPolicy");
            userfs.mkdirs(sDir);
            userfs.setStoragePolicy(sDir, "COLD");
            HdfsFileStatus[] list = userfs.getClient().listPaths(dir.toString(), HdfsFileStatus.EMPTY_NAME).getPartialListing();
            org.junit.jupiter.api.Assertions.assertEquals((byte)2, (byte)list[0].getStoragePolicy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveErasureCodingPolicy() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            ECSchema toAddSchema = new ECSchema("rs", 3, 2);
            ErasureCodingPolicy toAddPolicy = new ErasureCodingPolicy(toAddSchema, 131072, -2);
            final String policyName = toAddPolicy.getName();
            ErasureCodingPolicy[] policies = new ErasureCodingPolicy[]{toAddPolicy};
            fs.addErasureCodingPolicies(policies);
            org.junit.jupiter.api.Assertions.assertEquals((Object)policyName, (Object)ErasureCodingPolicyManager.getInstance().getByName(policyName).getName());
            fs.removeErasureCodingPolicy(policyName);
            org.junit.jupiter.api.Assertions.assertEquals((Object)policyName, (Object)((ErasureCodingPolicy)ErasureCodingPolicyManager.getInstance().getRemovedPolicies().get(0)).getName());
            UserGroupInformation fakeUGI = UserGroupInformation.createUserForTesting((String)"ProbablyNotARealUserName", (String[])new String[]{"ShangriLa"});
            final MiniDFSCluster finalCluster = cluster;
            fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem fs = finalCluster.getFileSystem();
                    try {
                        fs.removeErasureCodingPolicy(policyName);
                        org.junit.jupiter.api.Assertions.fail();
                    }
                    catch (AccessControlException ace) {
                        GenericTestUtils.assertExceptionContains((String)"Access denied for user ProbablyNotARealUserName. Superuser privilege is required", (Throwable)ace);
                    }
                    return null;
                }
            });
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableAndDisableErasureCodingPolicy() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            ECSchema toAddSchema = new ECSchema("rs", 3, 2);
            ErasureCodingPolicy toAddPolicy = new ErasureCodingPolicy(toAddSchema, 131072, -2);
            final String policyName = toAddPolicy.getName();
            ErasureCodingPolicy[] policies = new ErasureCodingPolicy[]{toAddPolicy};
            fs.addErasureCodingPolicies(policies);
            org.junit.jupiter.api.Assertions.assertEquals((Object)policyName, (Object)ErasureCodingPolicyManager.getInstance().getByName(policyName).getName());
            fs.enableErasureCodingPolicy(policyName);
            org.junit.jupiter.api.Assertions.assertEquals((Object)policyName, (Object)ErasureCodingPolicyManager.getInstance().getEnabledPolicyByName(policyName).getName());
            fs.disableErasureCodingPolicy(policyName);
            org.junit.jupiter.api.Assertions.assertNull((Object)ErasureCodingPolicyManager.getInstance().getEnabledPolicyByName(policyName));
            try {
                fs.enableErasureCodingPolicy("notExistECName");
                org.junit.jupiter.api.Assertions.fail((String)"enable the policy that doesn't exist should fail");
            }
            catch (Exception e) {
                GenericTestUtils.assertExceptionContains((String)"does not exist", (Throwable)e);
            }
            try {
                fs.disableErasureCodingPolicy("notExistECName");
                org.junit.jupiter.api.Assertions.fail((String)"disable the policy that doesn't exist should fail");
            }
            catch (Exception e) {
                GenericTestUtils.assertExceptionContains((String)"does not exist", (Throwable)e);
            }
            UserGroupInformation fakeUGI = UserGroupInformation.createUserForTesting((String)"ProbablyNotARealUserName", (String[])new String[]{"ShangriLa"});
            final MiniDFSCluster finalCluster = cluster;
            fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem fs = finalCluster.getFileSystem();
                    try {
                        fs.disableErasureCodingPolicy(policyName);
                        org.junit.jupiter.api.Assertions.fail();
                    }
                    catch (AccessControlException ace) {
                        GenericTestUtils.assertExceptionContains((String)"Access denied for user ProbablyNotARealUserName. Superuser privilege is required", (Throwable)ace);
                    }
                    try {
                        fs.enableErasureCodingPolicy(policyName);
                        org.junit.jupiter.api.Assertions.fail();
                    }
                    catch (AccessControlException ace) {
                        GenericTestUtils.assertExceptionContains((String)"Access denied for user ProbablyNotARealUserName. Superuser privilege is required", (Throwable)ace);
                    }
                    return null;
                }
            });
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testStorageFavouredNodes() throws IOException, InterruptedException, TimeoutException {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[]{StorageType.SSD, StorageType.DISK}).numDataNodes(3).storagesPerDatanode(2).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            Path file1 = new Path("/tmp/file1");
            fs.mkdirs(new Path("/tmp"));
            fs.setStoragePolicy(new Path("/tmp"), "ONE_SSD");
            InetSocketAddress[] addrs = new InetSocketAddress[]{cluster.getDataNodes().get(0).getXferAddress()};
            HdfsDataOutputStream stream = fs.create(file1, FsPermission.getDefault(), false, 1024, (short)3, 1024L, null, addrs);
            stream.write("Some Bytes".getBytes());
            stream.close();
            DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)3);
            BlockLocation[] locations = fs.getClient().getBlockLocations(file1.toUri().getPath(), 0L, Long.MAX_VALUE);
            int numSSD = Collections.frequency(Arrays.asList(locations[0].getStorageTypes()), StorageType.SSD);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)numSSD, (String)("Number of SSD should be 1 but was : " + numSSD));
        }
    }

    @Test
    public void testGetECTopologyResultForPolicies() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        try (MiniDFSCluster cluster = DFSTestUtil.setupCluster((Configuration)conf, 9, 3, 0);){
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.enableErasureCodingPolicy("RS-6-3-1024k");
            ECTopologyVerifierResult result = dfs.getECTopologyResultForPolicies(new String[0]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSupported());
            result = dfs.getECTopologyResultForPolicies(new String[]{"RS-10-4-1024k"});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSupported());
            result = dfs.getECTopologyResultForPolicies(new String[]{"XOR-2-1-1024k", "RS-3-2-1024k"});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSupported());
            result = dfs.getECTopologyResultForPolicies(new String[]{"RS-10-4-1024k", "RS-3-2-1024k"});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSupported());
            dfs.enableErasureCodingPolicy("RS-10-4-1024k");
            result = dfs.getECTopologyResultForPolicies(new String[0]);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSupported());
        }
    }

    @Test
    public void testECCloseCommittedBlock() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.namenode.file.close.num-committed-allowed", 1);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            dfs.enableErasureCodingPolicy("XOR-2-1-1024k");
            dfs.setErasureCodingPolicy(dir, "XOR-2-1-1024k");
            try (FSDataOutputStream str = dfs.create(new Path("/dir/file"));){
                for (int i = 0; i < 0x400000; ++i) {
                    str.write(i);
                }
                DataNodeTestUtils.pauseIBR(cluster.getDataNodes().get(0));
                DataNodeTestUtils.pauseIBR(cluster.getDataNodes().get(1));
            }
            DataNodeTestUtils.resumeIBR(cluster.getDataNodes().get(0));
            DataNodeTestUtils.resumeIBR(cluster.getDataNodes().get(1));
            cluster.getDataNodes().get(0).shutdown();
            str = dfs.create(new Path("/dir/file1"));
            for (int i = 0; i < 0x400000; ++i) {
                str.write(i);
            }
            DataNodeTestUtils.pauseIBR(cluster.getDataNodes().get(1));
            DataNodeTestUtils.pauseIBR(cluster.getDataNodes().get(2));
            LambdaTestUtils.intercept(IOException.class, (String)"", () -> str.close());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTrashRoot() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/ssgtr/test1/");
            Path testDirTrashRoot = new Path(testDir, ".Trash");
            Path file0path = new Path(testDir, "file-0");
            dfs.create(file0path).close();
            Path trBeforeAllowSnapshot = dfs.getTrashRoot(file0path);
            String trBeforeAllowSnapshotStr = trBeforeAllowSnapshot.toUri().getPath();
            String homeDirStr = dfs.getHomeDirectory().toUri().getPath();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)trBeforeAllowSnapshotStr.startsWith(homeDirStr));
            dfs.allowSnapshot(testDir);
            dfs.provisionSnapshotTrash(testDir, HdfsAdmin.TRASH_PERMISSION);
            FileStatus trashRootFileStatus = dfs.getFileStatus(testDirTrashRoot);
            org.junit.jupiter.api.Assertions.assertEquals((Object)HdfsAdmin.TRASH_PERMISSION, (Object)trashRootFileStatus.getPermission());
            Path trAfterAllowSnapshot = dfs.getTrashRoot(file0path);
            String trAfterAllowSnapshotStr = trAfterAllowSnapshot.toUri().getPath();
            String testDirStr = testDir.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)trAfterAllowSnapshotStr.startsWith(testDirStr));
            Path test2Dir = new Path("/ssgtr/test12/");
            Path file1path = new Path(test2Dir, "file-1");
            trAfterAllowSnapshot = dfs.getTrashRoot(file1path);
            trAfterAllowSnapshotStr = trAfterAllowSnapshot.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)trAfterAllowSnapshotStr.startsWith(testDirStr));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)trBeforeAllowSnapshotStr.startsWith(homeDirStr));
            dfs.disallowSnapshot(testDir);
            dfs.delete(testDir, true);
            dfs.delete(test2Dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private boolean isPathInUserHome(String pathStr, DistributedFileSystem dfs) {
        String homeDirStr = dfs.getHomeDirectory().toUri().getPath();
        return pathStr.startsWith(homeDirStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTrashRoots() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/ssgtr/test1/");
            Path file0path = new Path(testDir, "file-0");
            dfs.create(file0path);
            Path currUserHome = dfs.getHomeDirectory();
            Path currUserTrash = new Path(currUserHome, ".Trash");
            dfs.mkdirs(currUserTrash);
            Path testDirTrash = new Path(testDir, ".Trash");
            Path testDirTrashCurrUser = new Path(testDirTrash, UserGroupInformation.getCurrentUser().getShortUserName());
            dfs.mkdirs(testDirTrashCurrUser);
            Collection trashRoots = dfs.getTrashRoots(false);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)trashRoots.size());
            FileStatus firstFileStatus = (FileStatus)trashRoots.iterator().next();
            String pathStr = firstFileStatus.getPath().toUri().getPath();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isPathInUserHome(pathStr, dfs));
            Collection trashRootsAllUsers = dfs.getTrashRoots(true);
            org.junit.jupiter.api.Assertions.assertEquals((Object)trashRoots, (Object)trashRootsAllUsers);
            dfs.allowSnapshot(testDir);
            Collection trashRootsAfter = dfs.getTrashRoots(false);
            org.junit.jupiter.api.Assertions.assertEquals((int)(trashRoots.size() + 1), (int)trashRootsAfter.size());
            boolean foundUserHomeTrash = false;
            boolean foundSnapDirUserTrash = false;
            String testDirStr = testDir.toUri().getPath();
            for (FileStatus fileStatus : trashRootsAfter) {
                String currPathStr = fileStatus.getPath().toUri().getPath();
                if (this.isPathInUserHome(currPathStr, dfs)) {
                    foundUserHomeTrash = true;
                    continue;
                }
                if (!currPathStr.startsWith(testDirStr)) continue;
                foundSnapDirUserTrash = true;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foundUserHomeTrash);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foundSnapDirUserTrash);
            Collection trashRootsAfterAllUsers = dfs.getTrashRoots(true);
            org.junit.jupiter.api.Assertions.assertEquals((Object)trashRootsAfter, (Object)trashRootsAfterAllUsers);
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"user0");
            String user0HomeStr = DFSUtilClient.getHomeDirectory((Configuration)conf, (UserGroupInformation)ugi);
            Path user0Trash = new Path(user0HomeStr, ".Trash");
            dfs.mkdirs(user0Trash);
            Collection trashRootsAfter2 = dfs.getTrashRoots(false);
            org.junit.jupiter.api.Assertions.assertEquals((Object)trashRootsAfter, (Object)trashRootsAfter2);
            trashRootsAfter2 = dfs.getTrashRoots(true);
            org.junit.jupiter.api.Assertions.assertEquals((int)(trashRootsAfter.size() + 1), (int)trashRootsAfter2.size());
            Path testDirTrashUser0 = new Path(testDirTrash, ugi.getShortUserName());
            dfs.mkdirs(testDirTrashUser0);
            Collection trashRootsAfter3 = dfs.getTrashRoots(true);
            org.junit.jupiter.api.Assertions.assertEquals((int)(trashRootsAfter2.size() + 1), (int)trashRootsAfter3.size());
            dfs.delete(new Path(testDir, ".Trash"), true);
            dfs.disallowSnapshot(testDir);
            dfs.delete(testDir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTrashRootsOnSnapshottableDirWithEZ() throws IOException, NoSuchAlgorithmException {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        File tmpDir = GenericTestUtils.getTestDir((String)UUID.randomUUID().toString());
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        conf.set("hadoop.security.key.provider.path", "jceks://file" + jksPath.toUri());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        KeyProviderCryptoExtension provider = cluster.getNameNode().getNamesystem().getProvider();
        KeyProvider.Options options = KeyProvider.options((Configuration)conf);
        provider.createKey("key", options);
        provider.flush();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/ssgtr/test2/");
            dfs.mkdirs(testDir);
            dfs.createEncryptionZone(testDir, "key");
            Path testDirTrash = new Path(testDir, ".Trash");
            Path testDirTrashCurrUser = new Path(testDirTrash, UserGroupInformation.getCurrentUser().getShortUserName());
            dfs.mkdirs(testDirTrashCurrUser);
            Collection trashRoots = dfs.getTrashRoots(false);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)trashRoots.size());
            FileStatus firstFileStatus = (FileStatus)trashRoots.iterator().next();
            String pathStr = firstFileStatus.getPath().toUri().getPath();
            String testDirStr = testDir.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)pathStr.startsWith(testDirStr));
            dfs.allowSnapshot(testDir);
            Collection trashRootsAfter = dfs.getTrashRoots(false);
            org.junit.jupiter.api.Assertions.assertEquals((Object)trashRoots, (Object)trashRootsAfter);
            dfs.delete(new Path(testDir, ".Trash"), true);
            dfs.disallowSnapshot(testDir);
            dfs.delete(testDir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTrashRootOnSnapshottableDirInEZ() throws IOException, NoSuchAlgorithmException {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        File tmpDir = GenericTestUtils.getTestDir((String)UUID.randomUUID().toString());
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        conf.set("hadoop.security.key.provider.path", "jceks://file" + jksPath.toUri());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        KeyProviderCryptoExtension provider = cluster.getNameNode().getNamesystem().getProvider();
        KeyProvider.Options options = KeyProvider.options((Configuration)conf);
        provider.createKey("key", options);
        provider.flush();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/ssgtr/test3ez/");
            dfs.mkdirs(testDir);
            dfs.createEncryptionZone(testDir, "key");
            Path testSubD = new Path(testDir, "sssubdir");
            Path file1Path = new Path(testSubD, "file1");
            dfs.create(file1Path);
            Path trBefore = dfs.getTrashRoot(file1Path);
            String trBeforeStr = trBefore.toUri().getPath();
            Path testDirTrash = new Path(testDir, ".Trash");
            String testDirTrashStr = testDirTrash.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)trBeforeStr.startsWith(testDirTrashStr));
            dfs.allowSnapshot(testSubD);
            Path trAfter = dfs.getTrashRoot(file1Path);
            String trAfterStr = trAfter.toUri().getPath();
            Path testSubDirTrash = new Path(testSubD, ".Trash");
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Path testSubDirUserTrash = new Path(testSubDirTrash, ugi.getShortUserName());
            String testSubDirUserTrashStr = testSubDirUserTrash.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertEquals((Object)testSubDirUserTrashStr, (Object)trAfterStr);
            dfs.disallowSnapshot(testSubD);
            dfs.delete(testDir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTrashRootOnEZInSnapshottableDir() throws IOException, NoSuchAlgorithmException {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        File tmpDir = GenericTestUtils.getTestDir((String)UUID.randomUUID().toString());
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        conf.set("hadoop.security.key.provider.path", "jceks://file" + jksPath.toUri());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        KeyProviderCryptoExtension provider = cluster.getNameNode().getNamesystem().getProvider();
        KeyProvider.Options options = KeyProvider.options((Configuration)conf);
        provider.createKey("key", options);
        provider.flush();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/ssgtr/test3ss/");
            dfs.mkdirs(testDir);
            dfs.allowSnapshot(testDir);
            Path testSubD = new Path(testDir, "ezsubdir");
            dfs.mkdirs(testSubD);
            Path file1Path = new Path(testSubD, "file1");
            dfs.create(file1Path);
            Path trBefore = dfs.getTrashRoot(file1Path);
            String trBeforeStr = trBefore.toUri().getPath();
            Path testDirTrash = new Path(testDir, ".Trash");
            String testDirTrashStr = testDirTrash.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)trBeforeStr.startsWith(testDirTrashStr));
            dfs.delete(file1Path, false);
            dfs.createEncryptionZone(testSubD, "key");
            dfs.create(file1Path);
            Path trAfter = dfs.getTrashRoot(file1Path);
            String trAfterStr = trAfter.toUri().getPath();
            Path testSubDirTrash = new Path(testSubD, ".Trash");
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Path testSubDirUserTrash = new Path(testSubDirTrash, ugi.getShortUserName());
            String testSubDirUserTrashStr = testSubDirUserTrash.toUri().getPath();
            org.junit.jupiter.api.Assertions.assertEquals((Object)testSubDirUserTrashStr, (Object)trAfterStr);
            dfs.disallowSnapshot(testDir);
            dfs.delete(testDir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowSnapshotShouldThrowWhenTrashRootExists() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/disallowss/test1/");
            Path file0path = new Path(testDir, "file-0");
            dfs.create(file0path);
            dfs.allowSnapshot(testDir);
            Path testDirTrashRoot = new Path(testDir, ".Trash");
            Path dirInsideTrash = new Path(testDirTrashRoot, "user1");
            dfs.mkdirs(dirInsideTrash);
            LambdaTestUtils.intercept(IOException.class, () -> dfs.disallowSnapshot(testDir));
            dfs.delete(testDirTrashRoot, true);
            dfs.disallowSnapshot(testDir);
            dfs.delete(testDir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeCreateSnapshotTrashRootOnStartup() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path testDir = new Path("/disallowss/test2/");
            Path file0path = new Path(testDir, "file-0");
            dfs.create(file0path).close();
            dfs.allowSnapshot(testDir);
            Path trashRoot = new Path(testDir, ".Trash");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)dfs.exists(trashRoot));
            conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
            cluster.setNameNodeConf(0, (Configuration)conf);
            cluster.shutdown();
            conf.setInt("dfs.namenode.safemode.extension", 0);
            conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
            cluster.restartNameNode(0);
            dfs = cluster.getFileSystem();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cluster.getNameNode().isInSafeMode());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)dfs.exists(trashRoot));
            cluster.startDataNodes((Configuration)conf, 1, true, null, null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dfs.exists(trashRoot));
            FileStatus trashRootStatus = dfs.getFileStatus(trashRoot);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)trashRootStatus);
            org.junit.jupiter.api.Assertions.assertEquals((Object)HdfsAdmin.TRASH_PERMISSION, (Object)trashRootStatus.getPermission());
            dfs.delete(trashRoot, true);
            dfs.disallowSnapshot(testDir);
            dfs.delete(testDir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testSingleRackFailureDuringPipelineSetupMinReplicationPossible() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        conf.setInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", 2);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).racks(new String[]{"/rack1", "/rack2", "/rack3"}).build();){
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            cluster.stopDataNode(0);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testFile"), 1024L, (short)3, 1024L);
        }
    }

    @Test
    public void testSingleRackFailureDuringPipelineSetupMinReplicationImpossible() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        conf.setInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", 3);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).racks(new String[]{"/rack1", "/rack2", "/rack3"}).build();){
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            cluster.stopDataNode(0);
            LambdaTestUtils.intercept(IOException.class, () -> DFSTestUtil.createFile((FileSystem)fs, new Path("/testFile"), 1024L, (short)3, 1024L));
        }
    }

    @Test
    public void testMultipleRackFailureDuringPipelineSetupMinReplicationPossible() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        conf.setInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", 1);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).racks(new String[]{"/rack1", "/rack2", "/rack3"}).build();){
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            cluster.stopDataNode(0);
            cluster.stopDataNode(1);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testFile"), 1024L, (short)3, 1024L);
        }
    }

    @Test
    public void testMultipleRackFailureDuringPipelineSetupMinReplicationImpossible() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        conf.setInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", 2);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).racks(new String[]{"/rack1", "/rack2", "/rack3"}).build();){
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            cluster.stopDataNode(0);
            cluster.stopDataNode(1);
            LambdaTestUtils.intercept(IOException.class, () -> DFSTestUtil.createFile((FileSystem)fs, new Path("/testFile"), 1024L, (short)3, 1024L));
        }
    }

    @Test
    public void testAllRackFailureDuringPipelineSetup() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).racks(new String[]{"/rack1", "/rack2", "/rack3"}).build();){
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            cluster.shutdownDataNodes();
            LambdaTestUtils.intercept(IOException.class, () -> DFSTestUtil.createFile((FileSystem)fs, new Path("/testFile"), 1024L, (short)3, 1024L));
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)LeaseRenewer.LOG, (Level)Level.DEBUG);
    }

    private static class MyDistributedFileSystem
    extends DistributedFileSystem {
        MyDistributedFileSystem() {
            this.dfs = (DFSClient)Mockito.mock(DFSClient.class);
        }

        public boolean exists(Path p) {
            return true;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return this.dfs.delete(f.toUri().getPath(), recursive);
        }
    }
}

