/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSUpgradeFromImage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDatanodeStartupFixesLegacyStorageIDs {
    private static void runLayoutUpgradeTest(String testCaseName, final String expectedStorageId) throws IOException {
        TestDFSUpgradeFromImage upgrade = new TestDFSUpgradeFromImage();
        upgrade.unpackStorage(testCaseName + ".tgz", testCaseName + ".txt");
        Configuration conf = new Configuration(TestDFSUpgradeFromImage.upgradeConf);
        TestDatanodeStartupFixesLegacyStorageIDs.initStorageDirs(conf, testCaseName);
        TestDatanodeStartupFixesLegacyStorageIDs.upgradeAndVerify(upgrade, conf, new TestDFSUpgradeFromImage.ClusterVerifier(){

            @Override
            public void verifyClusterPostUpgrade(MiniDFSCluster cluster) throws IOException {
                String bpid = cluster.getNamesystem().getBlockPoolId();
                StorageReport[] reports = cluster.getDataNodes().get(0).getFSDataset().getStorageReports(bpid);
                Assertions.assertThat((int)reports.length).isEqualTo(1);
                String storageID = reports[0].getStorage().getStorageID();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)DatanodeStorage.isValidStorageId((String)storageID));
                if (expectedStorageId != null) {
                    Assertions.assertThat((String)storageID).isEqualTo((Object)expectedStorageId);
                }
            }
        });
    }

    private static void initStorageDirs(Configuration conf, String testName) {
        conf.set("dfs.datanode.data.dir", GenericTestUtils.getTempPath((String)(testName + File.separator + "dfs" + File.separator + "data")));
        conf.set("dfs.namenode.name.dir", GenericTestUtils.getTempPath((String)(testName + File.separator + "dfs" + File.separator + "name")));
    }

    private static void upgradeAndVerify(TestDFSUpgradeFromImage upgrade, Configuration conf, TestDFSUpgradeFromImage.ClusterVerifier verifier) throws IOException {
        upgrade.upgradeAndVerify(new MiniDFSCluster.Builder(conf).numDataNodes(1).manageDataDfsDirs(false).manageNameDfsDirs(false), verifier);
    }

    @Test
    @Timeout(value=300L)
    public void testUpgradeFrom22FixesStorageIDs() throws IOException {
        TestDatanodeStartupFixesLegacyStorageIDs.runLayoutUpgradeTest(GenericTestUtils.getMethodName(), null);
    }

    @Test
    @Timeout(value=300L)
    public void testUpgradeFrom22via26FixesStorageIDs() throws IOException {
        TestDatanodeStartupFixesLegacyStorageIDs.runLayoutUpgradeTest(GenericTestUtils.getMethodName(), null);
    }

    @Test
    @Timeout(value=300L)
    public void testUpgradeFrom26PreservesStorageIDs() throws IOException {
        TestDatanodeStartupFixesLegacyStorageIDs.runLayoutUpgradeTest(GenericTestUtils.getMethodName(), "DS-a0e39cfa-930f-4abd-813c-e22b59223774");
    }
}

