/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;

public class TestDFSRename {
    final Path dir = new Path("/test/rename/");

    static int countLease(MiniDFSCluster cluster) {
        return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).countLease();
    }

    void list(FileSystem fs, String name) throws IOException {
        FileSystem.LOG.info("\n\n" + name);
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info("" + s.getPath());
        }
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        a_out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assertions.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path aa = new Path(this.dir, "aa");
            Path b = new Path(this.dir, "b");
            TestDFSRename.createFile((FileSystem)fs, a);
            Assertions.assertEquals((int)0, (int)TestDFSRename.countLease(cluster));
            FSDataOutputStream aa_out = fs.create(aa);
            aa_out.writeBytes("something");
            Assertions.assertEquals((int)1, (int)TestDFSRename.countLease(cluster));
            this.list((FileSystem)fs, "rename0");
            fs.rename(a, b);
            this.list((FileSystem)fs, "rename1");
            aa_out.writeBytes(" more");
            aa_out.close();
            this.list((FileSystem)fs, "rename2");
            Assertions.assertEquals((int)0, (int)TestDFSRename.countLease(cluster));
            Path dstPath = new Path("/c/d");
            Assertions.assertFalse((boolean)fs.exists(dstPath));
            Assertions.assertFalse((boolean)fs.rename(this.dir, dstPath));
            Path src = new Path("/a/b");
            Path dst = new Path("/a/b/c");
            TestDFSRename.createFile((FileSystem)fs, new Path(src, "foo"));
            Assertions.assertFalse((boolean)fs.rename(src, dst));
            Assertions.assertFalse((boolean)fs.rename(src.getParent(), dst.getParent()));
            src = new Path("/testPrefix");
            dst = new Path("/testPrefixfile");
            TestDFSRename.createFile((FileSystem)fs, src);
            Assertions.assertTrue((boolean)fs.rename(src, dst));
            src = new Path("/a/b/c");
            TestDFSRename.createFile((FileSystem)fs, src);
            Assertions.assertTrue((boolean)fs.rename(src, src));
            Assertions.assertFalse((boolean)fs.rename(new Path("/a/b"), new Path("/a/b/")));
            Assertions.assertTrue((boolean)fs.rename(src, new Path("/a/b/c/")));
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testRenameWithOverwrite() throws Exception {
        int replFactor = 2;
        long blockSize = 512L;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            long fileLen = 1536L;
            String src = "/foo/src";
            String dst = "/foo/dst";
            Path srcPath = new Path(src);
            Path dstPath = new Path(dst);
            DFSTestUtil.createFile((FileSystem)dfs, srcPath, fileLen, (short)2, 1L);
            DFSTestUtil.createFile((FileSystem)dfs, dstPath, fileLen, (short)2, 1L);
            LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(cluster.getNameNode(), dst, 0L, fileLen);
            BlockManager bm = NameNodeAdapter.getNamesystem(cluster.getNameNode()).getBlockManager();
            Assertions.assertTrue((bm.getStoredBlock(((LocatedBlock)lbs.getLocatedBlocks().get(0)).getBlock().getLocalBlock()) != null ? 1 : 0) != 0);
            dfs.rename(srcPath, dstPath, new Options.Rename[]{Options.Rename.OVERWRITE});
            BlockManagerTestUtil.waitForMarkedDeleteQueueIsEmpty(cluster.getNamesystem(0).getBlockManager());
            Assertions.assertTrue((bm.getStoredBlock(((LocatedBlock)lbs.getLocatedBlocks().get(0)).getBlock().getLocalBlock()) == null ? 1 : 0) != 0);
            cluster.restartNameNodes();
            Assertions.assertFalse((boolean)dfs.exists(srcPath));
            Assertions.assertTrue((boolean)dfs.exists(dstPath));
        }
        finally {
            if (dfs != null) {
                dfs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testRename2Options() throws Exception {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path path = new Path("/test");
            dfs.mkdirs(path);
            GenericTestUtils.LogCapturer auditLog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
            dfs.rename(path, new Path("/dir1"), new Options.Rename[]{Options.Rename.OVERWRITE, Options.Rename.TO_TRASH});
            String auditOut = auditLog.getOutput();
            Assertions.assertTrue((boolean)auditOut.contains("options=[OVERWRITE, TO_TRASH]"), (String)("Rename should have both OVERWRITE and TO_TRASH flags at namenode but had only " + auditOut));
        }
    }
}

