/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConnCache {
    static final Logger LOG = LoggerFactory.getLogger(TestConnCache.class);
    static final int BLOCK_SIZE = 4096;
    static final int FILE_SIZE = 12288;

    private void pread(DFSInputStream in, long pos, byte[] buffer, int offset, int length, byte[] authenticData) throws IOException {
        Assertions.assertTrue((buffer.length >= offset + length ? 1 : 0) != 0, (String)"Test buffer too small");
        if (pos >= 0L) {
            in.seek(pos);
        }
        LOG.info("Reading from file of size " + in.getFileLength() + " at offset " + in.getPos());
        while (length > 0) {
            int cnt = in.read(buffer, offset, length);
            Assertions.assertTrue((cnt > 0 ? 1 : 0) != 0, (String)"Error in read");
            offset += cnt;
            length -= cnt;
        }
        for (int i = 0; i < length; ++i) {
            byte actual = buffer[i];
            byte expect = authenticData[(int)pos + i];
            Assertions.assertEquals((byte)actual, (byte)expect, (String)("Read data mismatch at file offset " + (pos + (long)i) + ". Expects " + expect + "; got " + actual));
        }
    }

    @Test
    public void testReadFromOneDN() throws Exception {
        HdfsConfiguration configuration = new HdfsConfiguration();
        String contextName = "testReadFromOneDNContext";
        configuration.set("dfs.client.context", "testReadFromOneDNContext");
        configuration.setLong("dfs.client.socket-timeout", 100000000L);
        BlockReaderTestUtil util = new BlockReaderTestUtil(1, configuration);
        Path testFile = new Path("/testConnCache.dat");
        byte[] authenticData = util.writeFile(testFile, 12);
        DFSClient client = new DFSClient(new InetSocketAddress("localhost", util.getCluster().getNameNodePort()), (Configuration)util.getConf());
        DFSInputStream in = client.open(testFile.toString());
        LOG.info("opened " + testFile.toString());
        byte[] dataBuf = new byte[4096];
        this.pread(in, 0L, dataBuf, 0, dataBuf.length, authenticData);
        this.pread(in, 12288 - dataBuf.length, dataBuf, 0, dataBuf.length, authenticData);
        this.pread(in, 1024L, dataBuf, 0, dataBuf.length, authenticData);
        this.pread(in, -1L, dataBuf, 0, dataBuf.length, authenticData);
        this.pread(in, 64L, dataBuf, 0, dataBuf.length / 2, authenticData);
        in.close();
        client.close();
        Assertions.assertEquals((int)1, (int)ClientContext.getFromConf((Configuration)configuration).getPeerCache().size());
    }
}

