/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestViewFsLinkFallback {
    private static FileSystem fsDefault;
    private FileSystem fsTarget;
    private static MiniDFSCluster cluster;
    private static URI viewFsDefaultClusterUri;
    private Path targetTestRoot;

    @BeforeAll
    public static void clusterSetupAtBeginning() throws IOException, URISyntaxException {
        int nameSpacesCount = 3;
        int dataNodesCount = 3;
        int fsIndexDefault = 0;
        Configuration conf = new Configuration();
        FileSystem[] fsHdfs = new FileSystem[nameSpacesCount];
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(nameSpacesCount)).numDataNodes(dataNodesCount).build();
        cluster.waitClusterUp();
        for (int i = 0; i < nameSpacesCount; ++i) {
            fsHdfs[i] = cluster.getFileSystem(i);
        }
        fsDefault = fsHdfs[fsIndexDefault];
        viewFsDefaultClusterUri = new URI("viewfs", "default", "/", null, null);
    }

    @AfterAll
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        this.initializeTargetTestRoot();
    }

    private void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    @Test
    public void testMkdirOfLinkParentWithFallbackLinkWithSameMountDirectoryTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/partition-0");
        this.fsTarget.mkdirs(dir1);
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path p = new Path("/user1/hive/warehouse/test");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
        Assertions.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(p, null, true);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirOfRootWithFallbackLinkAndMountWithSameDirTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1");
        this.fsTarget.mkdirs(dir1);
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path p = new Path("/");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
        vfs.mkdir(p, null, true);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirOfNewDirWithOutMatchingToMountOrFallbackDirTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path p = new Path("/user2");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
        Assertions.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(p, null, true);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testGetDelegationToken() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user", (URI)new Path(this.targetTestRoot.toString(), "user").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)"/data", (URI)new Path(this.targetTestRoot.toString(), "data").toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)this.targetTestRoot.toUri());
        FileContext fcView = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        List tokens = fcView.getDelegationTokens(new Path("/"), "tester");
        Assertions.assertEquals((int)3, (int)tokens.size());
    }

    @Test
    public void testMkdirWithFallbackLinkWithMountPathMatchingDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path immediateLevelToInternalDir = new Path("/user1/test");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)immediateLevelToInternalDir);
        Assertions.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(immediateLevelToInternalDir, null, true);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirOfDeepTreeWithFallbackLinkAndMountPathMatchingDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path multipleLevelToInternalDir = new Path("/user1/test/test");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)multipleLevelToInternalDir);
        Assertions.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(multipleLevelToInternalDir, null, true);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirShouldCreateParentDirInFallbackWhenMountDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/test", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path multipleLevelToInternalDir = new Path("/user1/hive/test1");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)multipleLevelToInternalDir);
        Assertions.assertFalse((boolean)this.fsTarget.exists(test));
        Assertions.assertNotNull((Object)vfs.getFileStatus(new Path("/user1/hive")));
        Assertions.assertFalse((boolean)this.fsTarget.exists(test.getParent()));
        vfs.mkdir(multipleLevelToInternalDir, FsPermission.getDirDefault(), false);
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirShouldFailWhenFallbackFSNotAvailable() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/test", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path nextLevelToInternalDir = new Path("/user1/test1");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)nextLevelToInternalDir);
        Assertions.assertFalse((boolean)this.fsTarget.exists(test));
        Assertions.assertNotNull((Object)vfs.getFileStatus(new Path("/user1")));
        Assertions.assertFalse((boolean)this.fsTarget.exists(test.getParent()));
        cluster.shutdownNameNodes();
        try {
            vfs.mkdir(nextLevelToInternalDir, FsPermission.getDirDefault(), false);
            Assertions.fail((String)"It should throw IOE when fallback fs not available.");
        }
        catch (IOException e) {
            cluster.restartNameNodes();
            vfs.mkdir(nextLevelToInternalDir, FsPermission.getDirDefault(), false);
        }
        Assertions.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testCreateFileOnInternalMountDirWithSameDirTreeExistInFallback() throws Exception {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        Path dir1 = new Path(fallbackTarget, "user1/hive/warehouse/partition-0");
        this.fsTarget.mkdirs(dir1);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/user1/hive/warehouse/test.file");
        Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
        Assertions.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
        Assertions.assertTrue((boolean)this.fsTarget.exists(testFileInFallback.getParent()));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        Assertions.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
    }

    @Test
    public void testCreateNewFileWithOutMatchingToMountDirOrFallbackDirPath() throws Exception {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/user2/test.file");
        Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
        Assertions.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
        Assertions.assertFalse((boolean)this.fsTarget.exists(testFileInFallback.getParent()));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault()), Options.CreateOpts.createParent()}).close();
        Assertions.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
    }

    @Test
    public void testCreateFileOnRootWithFallbackEnabled() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/test.file");
        Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
        Assertions.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        Assertions.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
    }

    @Test
    public void testCreateFileOnRootWithFallbackWithFileAlreadyExist() throws Exception {
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> {
            Configuration conf = new Configuration();
            Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
            Path testFile = new Path(fallbackTarget, "test.file");
            this.fsTarget.create(testFile).close();
            ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
            ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
            AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
            Path vfsTestFile = new Path("/test.file");
            Assertions.assertTrue((boolean)this.fsTarget.exists(testFile));
            vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        });
    }

    @Test
    public void testCreateFileWhereThePathIsSameAsItsMountLinkPath() throws Exception {
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> {
            Configuration conf = new Configuration();
            Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
            this.fsTarget.mkdirs(fallbackTarget);
            ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
            ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
            AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
            Path vfsTestDir = new Path("/user1/hive");
            Assertions.assertFalse((boolean)this.fsTarget.exists(Path.mergePaths((Path)fallbackTarget, (Path)vfsTestDir)));
            vfs.create(vfsTestDir, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        });
    }

    @Test
    public void testCreateFileSameAsInternalDirPath() throws Exception {
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> {
            Configuration conf = new Configuration();
            Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
            this.fsTarget.mkdirs(fallbackTarget);
            ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
            ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
            AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
            Path vfsTestDir = new Path("/user1");
            Assertions.assertFalse((boolean)this.fsTarget.exists(Path.mergePaths((Path)fallbackTarget, (Path)vfsTestDir)));
            vfs.create(vfsTestDir, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        });
    }

    @Test
    public void testListFiles() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        Path fileInFallBackRoot = new Path(fallbackTarget, "GetFileBlockLocations");
        this.fsTarget.create(fileInFallBackRoot).close();
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        FileContext fc = FileContext.getFileContext((URI)viewFsDefaultClusterUri, (Configuration)conf);
        RemoteIterator iterator = fc.util().listFiles(new Path("/"), false);
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)fileInFallBackRoot.getName(), (Object)((LocatedFileStatus)iterator.next()).getPath().getName());
    }

    @Test
    public void testRenameOnInternalDirWithFallback() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1", (URI)new Path(this.targetTestRoot.toString() + "/user1").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)"/NewHDFSUser/next", (URI)new Path(this.targetTestRoot.toString() + "/newUser1").toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (DistributedFileSystem dfs = new DistributedFileSystem();){
            dfs.initialize(fsDefault.getUri(), conf);
            dfs.mkdirs(new Path(this.targetTestRoot.toString() + "/user1"));
            dfs.mkdirs(new Path(fallbackTarget.toString() + "/newUser1"));
        }
        AbstractFileSystem fs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path src = new Path("/newFileOnRoot");
        Path dst = new Path("/newFileOnRoot1");
        fs.create(src, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        this.verifyRename(fs, src, dst);
        src = new Path("/newFileOnRoot1");
        dst = new Path("/newUser1/newFileOnRoot");
        fs.mkdir(dst.getParent(), FsPermission.getDefault(), true);
        this.verifyRename(fs, src, dst);
        src = new Path("/newUser1/newFileOnRoot");
        dst = new Path("/newUser1/newFileOnRoot1");
        this.verifyRename(fs, src, dst);
        src = new Path("/newUser1/newFileOnRoot1");
        dst = new Path("/newFileOnRoot");
        this.verifyRename(fs, src, dst);
        src = new Path("/user1/newFileOnRoot1");
        dst = new Path("/user1/newFileOnRoot");
        fs.create(src, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        this.verifyRename(fs, src, dst);
    }

    @Test
    public void testRenameWhenDstOnInternalDirWithFallback() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/InternalDirDoesNotExistInFallback/test", (URI)new Path(this.targetTestRoot.toString() + "/user1").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)"/NewHDFSUser/next/next1", (URI)new Path(this.targetTestRoot.toString() + "/newUser1").toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (DistributedFileSystem dfs = new DistributedFileSystem();){
            dfs.initialize(fsDefault.getUri(), conf);
            dfs.mkdirs(new Path(this.targetTestRoot.toString() + "/newUser1"));
            dfs.mkdirs(new Path(fallbackTarget.toString() + "/NewHDFSUser/next/next1"));
        }
        AbstractFileSystem fs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path src = new Path("/newFileOnRoot");
        Path dst = new Path("/NewHDFSUser/next");
        fs.mkdir(src, FsPermission.getDefault(), true);
        LambdaTestUtils.intercept(IOException.class, () -> fs.rename(src, dst, new Options.Rename[]{Options.Rename.OVERWRITE}));
        Path src1 = new Path("/newFileOnRoot1");
        Path dst1 = new Path("/NewHDFSUser/next/file");
        fs.create(src1, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        this.verifyRename(fs, src1, dst1);
        Path src2 = new Path("/newFileOnRoot2");
        Path dst2 = new Path("/InternalDirDoesNotExistInFallback/file");
        fs.create(src2, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.rename(src2, dst2, new Options.Rename[]{Options.Rename.OVERWRITE}));
    }

    private void verifyRename(AbstractFileSystem fs, Path src, Path dst) throws Exception {
        fs.rename(src, dst, new Options.Rename[]{Options.Rename.OVERWRITE});
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getFileStatus(src));
        Assertions.assertNotNull((Object)fs.getFileStatus(dst));
    }
}

