/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestHDFSFileSystemContract;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestViewFileSystemOverloadSchemeHdfsFileSystemContract
extends TestHDFSFileSystemContract {
    private static MiniDFSCluster cluster;
    private static String defaultWorkingDirectory;
    private static Configuration conf;

    @BeforeAll
    public static void init() throws IOException {
        File basedir = GenericTestUtils.getRandomizedTestDir();
        conf.set("fs.permissions.umask-mode", "062");
        cluster = new MiniDFSCluster.Builder(conf, basedir).numDataNodes(2).build();
        defaultWorkingDirectory = "/user/" + UserGroupInformation.getCurrentUser().getShortUserName();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        conf.set(String.format("fs.%s.impl", "hdfs"), ViewFileSystemOverloadScheme.class.getName());
        conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", "hdfs"), DistributedFileSystem.class.getName());
        conf.setBoolean("fs.viewfs.ignore.port.in.mount.table.name", false);
        URI defaultFSURI = URI.create(conf.get("fs.defaultFS"));
        ConfigUtil.addLink((Configuration)conf, (String)defaultFSURI.getAuthority(), (String)"/user", (URI)defaultFSURI);
        ConfigUtil.addLink((Configuration)conf, (String)defaultFSURI.getAuthority(), (String)"/append", (URI)defaultFSURI);
        ConfigUtil.addLink((Configuration)conf, (String)defaultFSURI.getAuthority(), (String)"/FileSystemContractBaseTest/", (URI)new URI(defaultFSURI.toString() + "/FileSystemContractBaseTest/"));
        this.fs = FileSystem.get((Configuration)conf);
    }

    @AfterAll
    public static void tearDownAfter() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Override
    protected String getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    @Override
    @Test
    @Timeout(value=60L)
    public void testAppend() throws IOException {
        AppendTestUtil.testAppend(this.fs, new Path("/append/f"));
    }

    @Test
    public void testRenameRootDirForbidden() throws Exception {
        Assertions.assertThrows(AccessControlException.class, () -> super.testRenameRootDirForbidden());
    }

    @Test
    public void testListStatusRootDir() throws Throwable {
        Assumptions.assumeTrue((boolean)this.rootDirTestEnabled());
        Path dir = this.path("/");
        Path child = this.path("/FileSystemContractBaseTest");
        try (FileSystem dfs = ((ViewFileSystemOverloadScheme)this.fs).getRawFileSystem(new Path(conf.get("fs.defaultFS"), "/"), conf);){
            dfs.mkdirs(child);
        }
        this.assertListStatusFinds(dir, child);
    }

    @Disabled
    public void testLSRootDir() throws Throwable {
    }

    static {
        conf = new HdfsConfiguration();
    }
}

