/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNNStartupWhenViewFSOverloadSchemeEnabled {
    private MiniDFSCluster cluster;
    private static final String FS_IMPL_PATTERN_KEY = "fs.%s.impl";
    private static final String HDFS_SCHEME = "hdfs";
    private static final Configuration CONF = new Configuration();

    @BeforeAll
    public static void setUp() {
        CONF.setInt("dfs.heartbeat.interval", 1);
        CONF.setInt("dfs.ha.tail-edits.period", 1);
        CONF.setInt("ipc.client.connect.max.retries", 1);
        CONF.set(String.format(FS_IMPL_PATTERN_KEY, HDFS_SCHEME), ViewFileSystemOverloadScheme.class.getName());
        CONF.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", HDFS_SCHEME), DistributedFileSystem.class.getName());
        CONF.setLong("fs.trash.interval", 100L);
    }

    @Test
    @Timeout(value=30L)
    public void testHANameNodeAndDataNodeStartup() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).waitSafeMode(false).build();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
    }

    @Test
    @Timeout(value=30L)
    public void testNameNodeAndDataNodeStartup() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(0).waitSafeMode(false).build();
        this.cluster.waitActive();
    }

    @AfterEach
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }
}

