/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestSymlinkHdfs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSymlinkHdfsFileSystem
extends TestSymlinkHdfs {
    @BeforeAll
    public static void testSetup() throws Exception {
        wrapper = new FileSystemTestWrapper((FileSystem)dfs, "/tmp/TestSymlinkHdfsFileSystem");
    }

    @Override
    @Disabled(value="FileSystem adds missing authority in absolute URIs")
    @Test
    @Timeout(value=10L)
    public void testCreateWithPartQualPathFails() throws IOException {
    }

    @Disabled(value="FileSystem#create creates parent directories, so dangling links to directories are created")
    @Test
    @Timeout(value=10L)
    public void testCreateFileViaDanglingLinkParent() throws IOException {
    }

    @Test
    @Timeout(value=10L)
    public void testRecoverLease() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "link");
        wrapper.setWorkingDirectory(dir);
        TestSymlinkHdfsFileSystem.createAndWriteFile((Path)file);
        wrapper.createSymlink(file, link, false);
        boolean closed = dfs.recoverLease(link);
        Assertions.assertTrue((boolean)closed, (String)"Expected recoverLease to return true");
    }

    @Test
    @Timeout(value=10L)
    public void testIsFileClosed() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "link");
        wrapper.setWorkingDirectory(dir);
        TestSymlinkHdfsFileSystem.createAndWriteFile((Path)file);
        wrapper.createSymlink(file, link, false);
        boolean closed = dfs.isFileClosed(link);
        Assertions.assertTrue((boolean)closed, (String)"Expected isFileClosed to return true");
    }

    @Test
    @Timeout(value=10L)
    public void testConcat() throws Exception {
        Path dir = new Path(this.testBaseDir1());
        Path link = new Path(this.testBaseDir1(), "link");
        Path dir2 = new Path(this.testBaseDir2());
        wrapper.createSymlink(dir2, link, false);
        wrapper.setWorkingDirectory(dir);
        Path target = new Path(link, "target");
        TestSymlinkHdfsFileSystem.createAndWriteFile((Path)target);
        Path[] srcs = new Path[3];
        for (int i = 0; i < srcs.length; ++i) {
            srcs[i] = new Path(link, "src-" + i);
            TestSymlinkHdfsFileSystem.createAndWriteFile((Path)srcs[i]);
        }
        dfs.concat(target, srcs);
    }

    @Test
    @Timeout(value=10L)
    public void testSnapshot() throws Exception {
        Path dir = new Path(this.testBaseDir1());
        Path link = new Path(this.testBaseDir1(), "link");
        Path dir2 = new Path(this.testBaseDir2());
        wrapper.createSymlink(dir2, link, false);
        wrapper.setWorkingDirectory(dir);
        dfs.allowSnapshot(link);
        dfs.disallowSnapshot(link);
        dfs.allowSnapshot(link);
        dfs.createSnapshot(link, "mcmillan");
        dfs.renameSnapshot(link, "mcmillan", "seaborg");
        dfs.deleteSnapshot(link, "seaborg");
    }
}

