/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParamFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            chain.doFilter((ServletRequest)new CustomHttpServletRequestWrapper(httpServletRequest), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private static final class CustomHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> lowerCaseParams = new HashMap<String, String[]>();

        private CustomHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
            Map originalParams = request.getParameterMap();
            for (Map.Entry entry : originalParams.entrySet()) {
                this.lowerCaseParams.put(((String)entry.getKey()).toLowerCase(), (String[])entry.getValue());
            }
        }

        public String getParameter(String name) {
            String[] values = this.getParameterValues(name);
            if (values != null && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.lowerCaseParams);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.lowerCaseParams.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.lowerCaseParams.get(name.toLowerCase());
        }
    }
}

