/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.util.EnumSet;

public class PBImageCorruption {
    private static final String WITH = "With";
    private long id;
    private EnumSet<PBImageCorruptionType> type;
    private int numOfCorruptChildren;

    PBImageCorruption(long id, boolean missingChild, boolean corruptNode, int numOfCorruptChildren) {
        if (!missingChild && !corruptNode) {
            throw new IllegalArgumentException("Corruption must have at least one aspect!");
        }
        this.id = id;
        this.type = EnumSet.noneOf(PBImageCorruptionType.class);
        if (missingChild) {
            this.type.add(PBImageCorruptionType.MISSING_CHILD);
        }
        if (corruptNode) {
            this.type.add(PBImageCorruptionType.CORRUPT_NODE);
        }
        this.numOfCorruptChildren = numOfCorruptChildren;
    }

    void addMissingChildCorruption() {
        this.type.add(PBImageCorruptionType.MISSING_CHILD);
    }

    void addCorruptNodeCorruption() {
        this.type.add(PBImageCorruptionType.CORRUPT_NODE);
    }

    void setNumberOfCorruption(int numOfCorruption) {
        this.numOfCorruptChildren = numOfCorruption;
    }

    long getId() {
        return this.id;
    }

    String getType() {
        StringBuilder s = new StringBuilder();
        if (this.type.contains((Object)PBImageCorruptionType.CORRUPT_NODE)) {
            s.append((Object)PBImageCorruptionType.CORRUPT_NODE);
        }
        if (this.type.contains((Object)PBImageCorruptionType.CORRUPT_NODE) && this.type.contains((Object)PBImageCorruptionType.MISSING_CHILD)) {
            s.append(WITH);
        }
        if (this.type.contains((Object)PBImageCorruptionType.MISSING_CHILD)) {
            s.append((Object)PBImageCorruptionType.MISSING_CHILD);
        }
        return s.toString();
    }

    int getNumOfCorruptChildren() {
        return this.numOfCorruptChildren;
    }

    private static enum PBImageCorruptionType {
        CORRUPT_NODE("CorruptNode"),
        MISSING_CHILD("MissingChild");

        private final String name;

        private PBImageCorruptionType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

