/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReferenceValidation;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.hdfs.server.namenode.visitor.INodeCountVisitor;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsImageValidation {
    static final Logger LOG = LoggerFactory.getLogger(FsImageValidation.class);
    static final String FS_IMAGE = "FS_IMAGE";
    static final boolean PRINT_ERROR = FsImageValidation.getEnvBoolean("PRINT_ERROR", true);
    private final File fsImageFile;

    static boolean getEnvBoolean(String property, boolean defaultValue) {
        String env = System.getenv().get(property);
        boolean setToNonDefault = ("" + !defaultValue).equalsIgnoreCase(env);
        boolean value = defaultValue != setToNonDefault;
        LOG.info("ENV: {} = {} (\"{}\")", new Object[]{property, value, env});
        return value;
    }

    static String getEnv(String property) {
        String value = System.getenv().get(property);
        LOG.info("ENV: {} = {}", (Object)property, (Object)value);
        return value;
    }

    static FsImageValidation newInstance(String ... args) {
        String f = Cli.parse(args);
        if (f == null) {
            throw new HadoopIllegalArgumentException("FS_IMAGE is not specified.");
        }
        return new FsImageValidation(new File(f));
    }

    static void initConf(Configuration conf) {
        int aDay = 86400000;
        conf.setInt("dfs.namenode.read-lock-reporting-threshold-ms", 86400000);
        conf.setInt("dfs.namenode.write-lock-reporting-threshold-ms", 86400000);
        conf.setBoolean("dfs.namenode.enable.retrycache", false);
    }

    static void setHaConf(String nsId, Configuration conf) {
        conf.set("dfs.nameservices", nsId);
        String haNNKey = "dfs.ha.namenodes." + nsId;
        conf.set(haNNKey, "nn0,nn1");
        String rpcKey = "dfs.namenode.rpc-address." + nsId + ".";
        conf.set(rpcKey + "nn0", "127.0.0.1:8080");
        conf.set(rpcKey + "nn1", "127.0.0.1:8080");
    }

    static void initLogLevels() {
        Util.setLogLevel(FSImage.class, Level.TRACE);
        Util.setLogLevel(FileJournalManager.class, Level.TRACE);
        Util.setLogLevel(GSet.class, Level.OFF);
        Util.setLogLevel(BlockManager.class, Level.OFF);
        Util.setLogLevel(DatanodeManager.class, Level.OFF);
        Util.setLogLevel(TopMetrics.class, Level.OFF);
    }

    FsImageValidation(File fsImageFile) {
        this.fsImageFile = fsImageFile;
    }

    int run() throws Exception {
        return this.run(new Configuration(), new AtomicInteger());
    }

    int run(AtomicInteger errorCount) throws Exception {
        return this.run(new Configuration(), errorCount);
    }

    int run(Configuration conf, AtomicInteger errorCount) throws Exception {
        int initCount = errorCount.get();
        LOG.info(Util.memoryInfo());
        FsImageValidation.initConf(conf);
        NameNode.initMetrics(conf, HdfsServerConstants.NamenodeRole.NAMENODE);
        FSNamesystem namesystem = this.checkINodeReference(conf, errorCount);
        boolean changed = INodeMapValidation.run(namesystem.getFSDirectory(), errorCount);
        LOG.info(Util.memoryInfo());
        int d = errorCount.get() - initCount;
        if (d > 0) {
            Cli.println("Found %d error(s) in %s", d, this.fsImageFile.getAbsolutePath());
        }
        if (changed) {
            File dir = this.fsImageFile.isDirectory() ? this.fsImageFile : this.fsImageFile.getParentFile();
            Path temp = Files.createTempDirectory(dir.toPath(), "newFsImage", new FileAttribute[0]);
            Cli.println("INodeMap changed, save a new FSImage to %s", temp);
            namesystem.getFSImage().save(namesystem, temp.toFile());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSNamesystem loadImage(Configuration conf) throws IOException {
        FSNamesystem namesystem;
        TimerTask checkProgress = new TimerTask(){

            @Override
            public void run() {
                double percent = NameNode.getStartupProgress().createView().getPercentComplete(Phase.LOADING_FSIMAGE);
                LOG.info(String.format("%s Progress: %.1f%% (%s)", new Object[]{Phase.LOADING_FSIMAGE, 100.0 * percent, Util.memoryInfo()}));
            }
        };
        Timer t = new Timer();
        t.scheduleAtFixedRate(checkProgress, 0L, 60000L);
        long loadStart = Time.now();
        if (this.fsImageFile.isDirectory()) {
            Cli.println("Loading %s as a directory.", this.fsImageFile);
            String dir = this.fsImageFile.getCanonicalPath();
            conf.set("dfs.namenode.name.dir", dir);
            conf.set("dfs.namenode.edits.dir", dir);
            FSImage fsImage = new FSImage(conf);
            namesystem = new FSNamesystem(conf, fsImage, true);
            namesystem.setRollingUpgradeInfo(false, 0L);
            namesystem.loadFSImage(HdfsServerConstants.StartupOption.REGULAR);
        } else {
            Cli.println("Loading %s as a file.", this.fsImageFile);
            FSImage fsImage = new FSImage(conf);
            namesystem = new FSNamesystem(conf, fsImage, true);
            NamespaceInfo namespaceInfo = NNStorage.newNamespaceInfo();
            namespaceInfo.clusterID = "cluster0";
            fsImage.getStorage().setStorageInfo(namespaceInfo);
            FSImageFormat.LoaderDelegator loader = FSImageFormat.newLoader(conf, namesystem);
            namesystem.writeLock(RwLockMode.GLOBAL);
            namesystem.getFSDirectory().writeLock();
            try {
                loader.load(this.fsImageFile, false);
                fsImage.setLastAppliedTxId(loader);
            }
            finally {
                namesystem.getFSDirectory().writeUnlock();
                namesystem.writeUnlock(RwLockMode.GLOBAL, "loadImage");
            }
        }
        t.cancel();
        Cli.println("Loaded %s %s with txid %d successfully in %s", FS_IMAGE, this.fsImageFile, namesystem.getFSImage().getLastAppliedTxId(), StringUtils.formatTime((long)(Time.now() - loadStart)));
        return namesystem;
    }

    FSNamesystem checkINodeReference(Configuration conf, AtomicInteger errorCount) throws Exception {
        INodeReferenceValidation.start();
        FSNamesystem namesystem = this.loadImage(conf);
        LOG.info(Util.memoryInfo());
        INodeReferenceValidation.end(errorCount);
        LOG.info(Util.memoryInfo());
        return namesystem;
    }

    public static int validate(FSNamesystem namesystem) throws Exception {
        AtomicInteger errorCount = new AtomicInteger();
        NNStorage nnStorage = namesystem.getFSImage().getStorage();
        for (Storage.StorageDirectory sd : nnStorage.getStorageDirs()) {
            FsImageValidation.validate(sd.getCurrentDir(), errorCount);
        }
        return errorCount.get();
    }

    public static void validate(File path, AtomicInteger errorCount) throws Exception {
        if (path.isFile()) {
            new FsImageValidation(path).run(errorCount);
        } else if (path.isDirectory()) {
            File[] images = path.listFiles(Util.newFilenameFilter(NNStorage.NameNodeFile.IMAGE));
            if (images == null || images.length == 0) {
                Cli.warn("%s not found in %s", FSImage.class.getSimpleName(), path.getAbsolutePath());
                return;
            }
            Arrays.sort(images, Collections.reverseOrder());
            for (int i = 0; i < images.length; ++i) {
                File image = images[i];
                Cli.println("%s %d) %s", FSImage.class.getSimpleName(), i, image.getAbsolutePath());
                FsImageValidation.validate(image, errorCount);
            }
        }
        Cli.warn("%s is neither a file nor a directory", path.getAbsolutePath());
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, Cli.USAGE, System.out, true)) {
            System.exit(0);
        }
        try {
            System.exit(ToolRunner.run((Configuration)new Configuration(), (Tool)new Cli(), (String[])args));
        }
        catch (HadoopIllegalArgumentException e) {
            e.printStackTrace(System.err);
            System.err.println(Cli.USAGE);
            System.exit(-1);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        }
        catch (Throwable e) {
            Cli.printError("Failed to run " + Cli.COMMAND, e);
            System.exit(-2);
        }
    }

    static class Cli
    extends Configured
    implements Tool {
        static final String COMMAND;
        static final String USAGE;

        Cli() {
        }

        public int run(String[] args) throws Exception {
            FsImageValidation.initLogLevels();
            FsImageValidation validation = FsImageValidation.newInstance(args);
            AtomicInteger errorCount = new AtomicInteger();
            validation.run(this.getConf(), errorCount);
            Cli.println("Error Count: %s", errorCount);
            return errorCount.get() == 0 ? 0 : 1;
        }

        static String parse(String ... args) {
            String f;
            if (args == null || args.length == 0) {
                f = FsImageValidation.getEnv(FsImageValidation.FS_IMAGE);
            } else if (args.length == 1) {
                f = args[0];
            } else {
                throw new HadoopIllegalArgumentException("args = " + Arrays.toString(args));
            }
            Cli.println("%s = %s", FsImageValidation.FS_IMAGE, f);
            return f;
        }

        static synchronized void println(String format, Object ... args) {
            String s = String.format(format, args);
            System.out.println(s);
            LOG.info(s);
        }

        static synchronized void warn(String format, Object ... args) {
            String s = "WARN: " + String.format(format, args);
            System.out.println(s);
            LOG.warn(s);
        }

        static synchronized void printError(String message, Throwable t) {
            System.out.println(message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
            LOG.error(message, t);
        }

        static synchronized void printError(AtomicInteger errorCount, String format, Object ... args) {
            int count = errorCount.incrementAndGet();
            if (!PRINT_ERROR) {
                return;
            }
            String s = "FSIMAGE_ERROR " + count + ": " + String.format(format, args);
            System.out.println(s);
            LOG.info(s);
        }

        static {
            String clazz = FsImageValidation.class.getSimpleName();
            COMMAND = Character.toLowerCase(clazz.charAt(0)) + clazz.substring(1);
            USAGE = "Usage: hdfs " + COMMAND + " <" + FsImageValidation.FS_IMAGE + ">";
        }
    }

    static class INodeMapValidation {
        INodeMapValidation() {
        }

        static boolean run(FSDirectory fsdir, AtomicInteger errorCount) {
            String name = INodeMapValidation.class.getSimpleName();
            int initErrorCount = errorCount.get();
            INodeCountVisitor.Counts counts = INodeCountVisitor.countTree(fsdir.getRoot());
            INodeMap map = fsdir.getINodeMap();
            int oldSize = map.size();
            Cli.println("%s INodeMap old size: %d", name, oldSize);
            Iterator<INodeWithAdditionalFields> j = map.getMapIterator();
            while (j.hasNext()) {
                INodeWithAdditionalFields i = j.next();
                if (counts.getCount(i) != 0) continue;
                j.remove();
                Cli.printError(errorCount, "%s (%d) is inaccessible (%s)", i, i.getId(), i.getFullPathName());
            }
            int newSize = map.size();
            Cli.println("%s INodeMap new size: %d", name, newSize);
            Cli.println("%s ended successfully: %d error(s) found.", name, errorCount.get() - initErrorCount);
            return newSize != oldSize;
        }
    }

    static class Util {
        Util() {
        }

        static String memoryInfo() {
            Runtime runtime = Runtime.getRuntime();
            return "Memory Info: free=" + StringUtils.byteDesc((long)runtime.freeMemory()) + ", total=" + StringUtils.byteDesc((long)runtime.totalMemory()) + ", max=" + StringUtils.byteDesc((long)runtime.maxMemory());
        }

        static void setLogLevel(Class<?> clazz, Level level) {
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(clazz);
            logger.setLevel(level);
            LOG.info("setLogLevel {} to {}, getEffectiveLevel() = {}", new Object[]{clazz.getName(), level, logger.getEffectiveLevel()});
        }

        static String toCommaSeparatedNumber(long n) {
            StringBuilder b = new StringBuilder();
            while (n > 999L) {
                b.insert(0, String.format(",%03d", n % 1000L));
                n /= 1000L;
            }
            return b.insert(0, n).toString();
        }

        static FilenameFilter newFilenameFilter(NNStorage.NameNodeFile type) {
            final String prefix = type.getName() + "_";
            return new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (!name.startsWith(prefix)) {
                        return false;
                    }
                    for (int i = prefix.length(); i < name.length(); ++i) {
                        if (Character.isDigit(name.charAt(i))) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
    }
}

