/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Timeout(value=30L)
public class TestNetworkTopology {
    private static final Logger LOG = LoggerFactory.getLogger(TestNetworkTopology.class);
    private static final NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
    private DatanodeDescriptor[] dataNodes;

    @BeforeEach
    public void setupDatanodes() {
        this.dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("9.9.9.9", "/d3/r1"), DFSTestUtil.getDatanodeDescriptor("10.10.10.10", "/d3/r1"), DFSTestUtil.getDatanodeDescriptor("11.11.11.11", "/d3/r1"), DFSTestUtil.getDatanodeDescriptor("12.12.12.12", "/d3/r2"), DFSTestUtil.getDatanodeDescriptor("13.13.13.13", "/d3/r2"), DFSTestUtil.getDatanodeDescriptor("14.14.14.14", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("15.15.15.15", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("16.16.16.16", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("17.17.17.17", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("18.18.18.18", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("19.19.19.19", "/d4/r1"), DFSTestUtil.getDatanodeDescriptor("20.20.20.20", "/d4/r1")};
        for (int i = 0; i < this.dataNodes.length; ++i) {
            cluster.add((Node)this.dataNodes[i]);
        }
        this.dataNodes[9].setDecommissioned();
        this.dataNodes[10].setDecommissioned();
        GenericTestUtils.setLogLevel((Logger)NetworkTopology.LOG, (Level)Level.TRACE);
    }

    @Test
    public void testContains() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r4");
        for (int i = 0; i < this.dataNodes.length; ++i) {
            Assertions.assertTrue((boolean)cluster.contains((Node)this.dataNodes[i]));
        }
        Assertions.assertFalse((boolean)cluster.contains((Node)nodeNotInMap));
    }

    @Test
    public void testNumOfChildren() throws Exception {
        Assertions.assertEquals((int)cluster.getNumOfLeaves(), (int)this.dataNodes.length);
    }

    @Test
    public void testCreateInvalidTopology() throws Exception {
        NetworkTopology invalCluster = NetworkTopology.getInstance((Configuration)new Configuration());
        DatanodeDescriptor[] invalDataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1")};
        invalCluster.add((Node)invalDataNodes[0]);
        invalCluster.add((Node)invalDataNodes[1]);
        try {
            invalCluster.add((Node)invalDataNodes[2]);
            Assertions.fail((String)"expected InvalidTopologyException");
        }
        catch (NetworkTopology.InvalidTopologyException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Failed to add "));
            Assertions.assertTrue((boolean)e.getMessage().contains("You cannot have a rack and a non-rack node at the same level of the network topology."));
        }
    }

    @Test
    public void testRacks() throws Exception {
        Assertions.assertEquals((int)cluster.getNumOfRacks(), (int)6);
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[0], (Node)this.dataNodes[1]));
        Assertions.assertFalse((boolean)cluster.isOnSameRack((Node)this.dataNodes[1], (Node)this.dataNodes[2]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[2], (Node)this.dataNodes[3]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[3], (Node)this.dataNodes[4]));
        Assertions.assertFalse((boolean)cluster.isOnSameRack((Node)this.dataNodes[4], (Node)this.dataNodes[5]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)this.dataNodes[5], (Node)this.dataNodes[6]));
    }

    @Test
    public void testGetWeight() throws Exception {
        DatanodeDescriptor nodeInMap = this.dataNodes[0];
        Assertions.assertEquals((int)0, (int)cluster.getWeight((Node)nodeInMap, (Node)this.dataNodes[0]));
        Assertions.assertEquals((int)2, (int)cluster.getWeight((Node)nodeInMap, (Node)this.dataNodes[1]));
        Assertions.assertEquals((int)4, (int)cluster.getWeight((Node)nodeInMap, (Node)this.dataNodes[2]));
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("21.21.21.21", "/d1/r2");
        Assertions.assertEquals((int)4, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)this.dataNodes[0]));
        Assertions.assertEquals((int)4, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)this.dataNodes[1]));
        Assertions.assertEquals((int)2, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)this.dataNodes[2]));
    }

    @Test
    public void testGetWeightForDepth() throws Exception {
        NetworkTopology topology = NetworkTopology.getInstance((Configuration)new Configuration());
        DatanodeDescriptor[] dns = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/z1/d1/p1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/z1/d1/p1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/z1/d1/p2/r2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/z1/d2/p1/r2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/z2/d3/p1/r1")};
        for (int i = 0; i < dns.length; ++i) {
            topology.add((Node)dns[i]);
        }
        DatanodeDescriptor nodeInMap = dns[0];
        Assertions.assertEquals((int)0, (int)topology.getWeight((Node)nodeInMap, (Node)dns[0]));
        Assertions.assertEquals((int)2, (int)topology.getWeight((Node)nodeInMap, (Node)dns[1]));
        Assertions.assertEquals((int)6, (int)topology.getWeight((Node)nodeInMap, (Node)dns[2]));
        Assertions.assertEquals((int)8, (int)topology.getWeight((Node)nodeInMap, (Node)dns[3]));
        Assertions.assertEquals((int)10, (int)topology.getWeight((Node)nodeInMap, (Node)dns[4]));
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/z1/d1/p1/r2");
        Assertions.assertEquals((int)4, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)dns[0]));
        Assertions.assertEquals((int)4, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)dns[1]));
        Assertions.assertEquals((int)6, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)dns[2]));
        Assertions.assertEquals((int)8, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)dns[3]));
        Assertions.assertEquals((int)10, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)nodeNotInMap, (Node)dns[4]));
    }

    @Test
    public void testGetDistance() throws Exception {
        Assertions.assertEquals((int)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[0]), (int)0);
        Assertions.assertEquals((int)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[1]), (int)2);
        Assertions.assertEquals((int)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[3]), (int)4);
        Assertions.assertEquals((int)cluster.getDistance((Node)this.dataNodes[0], (Node)this.dataNodes[6]), (int)6);
        NodeBase node1 = new NodeBase(this.dataNodes[0].getHostName(), this.dataNodes[0].getNetworkLocation());
        NodeBase node2 = new NodeBase(this.dataNodes[0].getHostName(), this.dataNodes[0].getNetworkLocation());
        Assertions.assertEquals((int)0, (int)cluster.getDistance((Node)node1, (Node)node2));
        NodeBase node3 = new NodeBase(this.dataNodes[3].getHostName(), this.dataNodes[3].getNetworkLocation());
        NodeBase node4 = new NodeBase(this.dataNodes[6].getHostName(), this.dataNodes[6].getNetworkLocation());
        Assertions.assertEquals((int)0, (int)NetworkTopology.getDistanceByPath((Node)node1, (Node)node2));
        Assertions.assertEquals((int)4, (int)NetworkTopology.getDistanceByPath((Node)node2, (Node)node3));
        Assertions.assertEquals((int)6, (int)NetworkTopology.getDistanceByPath((Node)node2, (Node)node4));
    }

    @Test
    public void testSortByDistance() throws Exception {
        int i;
        DatanodeDescriptor[] testNodes = new DatanodeDescriptor[]{this.dataNodes[1], this.dataNodes[2], this.dataNodes[0]};
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[1] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[2] ? 1 : 0) != 0);
        DatanodeDescriptor[] dtestNodes = new DatanodeDescriptor[]{this.dataNodes[8], this.dataNodes[12], this.dataNodes[11], this.dataNodes[9], this.dataNodes[10]};
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[8], (Node[])dtestNodes, dtestNodes.length - 2);
        Assertions.assertTrue((dtestNodes[0] == this.dataNodes[8] ? 1 : 0) != 0);
        Assertions.assertTrue((dtestNodes[1] != dtestNodes[2] ? 1 : 0) != 0);
        Assertions.assertTrue((dtestNodes[1] == this.dataNodes[11] || dtestNodes[1] == this.dataNodes[12] ? 1 : 0) != 0);
        Assertions.assertTrue((dtestNodes[2] == this.dataNodes[11] || dtestNodes[2] == this.dataNodes[12] ? 1 : 0) != 0);
        Assertions.assertTrue((dtestNodes[3] != dtestNodes[4] ? 1 : 0) != 0);
        Assertions.assertTrue((dtestNodes[3] == this.dataNodes[9] || dtestNodes[3] == this.dataNodes[10] ? 1 : 0) != 0);
        Assertions.assertTrue((dtestNodes[4] == this.dataNodes[9] || dtestNodes[4] == this.dataNodes[10] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[3];
        testNodes[2] = this.dataNodes[0];
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[1] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[5];
        testNodes[1] = this.dataNodes[3];
        testNodes[2] = this.dataNodes[1];
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[3] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[3];
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[3] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[1];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[3];
        cluster.setRandomSeed(57005L);
        cluster.sortByDistance((Node)this.dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[1] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[3] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        DatanodeDescriptor first = null;
        boolean foundRandom = false;
        for (i = 5; i <= 7; ++i) {
            testNodes[0] = this.dataNodes[5];
            testNodes[1] = this.dataNodes[6];
            testNodes[2] = this.dataNodes[7];
            cluster.sortByDistance((Node)this.dataNodes[i], (Node[])testNodes, testNodes.length);
            if (first == null) {
                first = testNodes[0];
                continue;
            }
            if (first == testNodes[0]) continue;
            foundRandom = true;
            break;
        }
        Assertions.assertTrue((boolean)foundRandom, (String)"Expected to find a different first location");
        first = null;
        for (i = 1; i <= 4; ++i) {
            testNodes[0] = this.dataNodes[13];
            testNodes[1] = this.dataNodes[14];
            testNodes[2] = this.dataNodes[15];
            cluster.sortByDistance((Node)this.dataNodes[i], (Node[])testNodes, testNodes.length);
            if (first == null) {
                first = testNodes[0];
                continue;
            }
            if (first == testNodes[0]) continue;
            foundRandom = true;
            break;
        }
        Assertions.assertTrue((boolean)foundRandom, (String)"Expected to find a different first location");
        testNodes[0] = this.dataNodes[0];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[8];
        NodeBase rackClient = new NodeBase("/d3/r1/25.25.25");
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistanceUsingNetworkLocation((Node)rackClient, (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[8] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] != testNodes[2] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[0] || testNodes[1] == this.dataNodes[5] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[0] || testNodes[2] == this.dataNodes[5] ? 1 : 0) != 0);
        testNodes[0] = this.dataNodes[8];
        testNodes[1] = this.dataNodes[5];
        testNodes[2] = this.dataNodes[0];
        NodeBase dcClient = new NodeBase("/d1/r2/25.25.25");
        cluster.setRandomSeed(-559038737L);
        cluster.sortByDistanceUsingNetworkLocation((Node)dcClient, (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == this.dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] != testNodes[2] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == this.dataNodes[5] || testNodes[1] == this.dataNodes[8] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == this.dataNodes[5] || testNodes[2] == this.dataNodes[8] ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        int i;
        Assertions.assertEquals((int)4, (int)TestNetworkTopology.cluster.clusterMap.getNumOfChildren());
        for (i = 0; i < this.dataNodes.length; ++i) {
            cluster.remove((Node)this.dataNodes[i]);
        }
        for (i = 0; i < this.dataNodes.length; ++i) {
            Assertions.assertFalse((boolean)cluster.contains((Node)this.dataNodes[i]));
        }
        Assertions.assertEquals((int)0, (int)cluster.getNumOfLeaves());
        Assertions.assertEquals((int)0, (int)TestNetworkTopology.cluster.clusterMap.getChildren().size());
        Assertions.assertEquals((int)0, (int)TestNetworkTopology.cluster.clusterMap.getNumOfChildren());
        for (i = 0; i < this.dataNodes.length; ++i) {
            cluster.add((Node)this.dataNodes[i]);
        }
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope, Collection<Node> excludedNodes) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (DatanodeDescriptor dnd : this.dataNodes) {
            frequency.put((Node)dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope, excludedNodes);
            if (random == null) continue;
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        LOG.info("Result:" + frequency);
        return frequency;
    }

    @Test
    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath((Node)this.dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope, null);
        for (DatanodeDescriptor key : this.dataNodes) {
            Assertions.assertTrue((frequency.get(key) > 0 || key == this.dataNodes[0] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChooseRandomExcludedRack() {
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, "~/d2", null);
        for (int j = 0; j < this.dataNodes.length; ++j) {
            int freq = frequency.get(this.dataNodes[j]);
            if (this.dataNodes[j].getNetworkLocation().startsWith("/d2")) {
                Assertions.assertEquals((int)0, (int)freq);
                continue;
            }
            Assertions.assertTrue((freq > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChooseRandomExcludedNodeList() {
        String scope = "~" + NodeBase.getPath((Node)this.dataNodes[0]);
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add((Node)this.dataNodes[3]);
        excludedNodes.add((Node)this.dataNodes[5]);
        excludedNodes.add((Node)this.dataNodes[7]);
        excludedNodes.add((Node)this.dataNodes[9]);
        excludedNodes.add((Node)this.dataNodes[13]);
        excludedNodes.add((Node)this.dataNodes[18]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope, excludedNodes);
        Assertions.assertEquals((int)0, (int)frequency.get(this.dataNodes[3]), (String)"dn[3] should be excluded");
        Assertions.assertEquals((int)0, (int)frequency.get(this.dataNodes[5]), (String)"dn[5] should be exclude18d");
        Assertions.assertEquals((int)0, (int)frequency.get(this.dataNodes[7]), (String)"dn[7] should be excluded");
        Assertions.assertEquals((int)0, (int)frequency.get(this.dataNodes[9]), (String)"dn[9] should be excluded");
        Assertions.assertEquals((int)0, (int)frequency.get(this.dataNodes[13]), (String)"dn[13] should be excluded");
        Assertions.assertEquals((int)0, (int)frequency.get(this.dataNodes[18]), (String)"dn[18] should be excluded");
        for (DatanodeDescriptor key : this.dataNodes) {
            if (excludedNodes.contains(key)) continue;
            Assertions.assertTrue((frequency.get(key) > 0 || key == this.dataNodes[0] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChooseRandomExcludeAllNodes() {
        String scope = "~" + NodeBase.getPath((Node)this.dataNodes[0]);
        HashSet<Node> excludedNodes = new HashSet<Node>();
        for (int i = 0; i < this.dataNodes.length; ++i) {
            excludedNodes.add((Node)this.dataNodes[i]);
        }
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope, excludedNodes);
        for (DatanodeDescriptor key : this.dataNodes) {
            Assertions.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=180L)
    public void testInvalidNetworkTopologiesNotCachedInHdfs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            DatanodeInfo[] info;
            String[] racks = new String[]{"/a/b", "/c"};
            String[] hosts = new String[]{"foo1.example.com", "foo2.example.com"};
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).racks(racks).hosts(hosts).build();
            cluster.waitActive();
            NamenodeProtocols nn = cluster.getNameNodeRpc();
            Assertions.assertNotNull((Object)nn);
            while (true) {
                Assertions.assertFalse(((info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length == 2 ? 1 : 0) != 0);
                if (info.length == 1) break;
                Thread.sleep(1000L);
            }
            int validIdx = info[0].getHostName().equals(hosts[0]) ? 0 : 1;
            int invalidIdx = validIdx == 1 ? 0 : 1;
            StaticMapping.addNodeToRack((String)hosts[invalidIdx], (String)racks[validIdx]);
            LOG.info("datanode " + validIdx + " came up with network location " + info[0].getNetworkLocation());
            cluster.restartDataNode(invalidIdx);
            Thread.sleep(5000L);
            while ((info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length != 2) {
                if (info.length == 0) {
                    LOG.info("got no valid DNs");
                } else if (info.length == 1) {
                    LOG.info("got one valid DN: " + info[0].getHostName() + " (at " + info[0].getNetworkLocation() + ")");
                }
                Thread.sleep(1000L);
            }
            Assertions.assertEquals((Object)info[0].getNetworkLocation(), (Object)info[1].getNetworkLocation());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testChooseRandomInclude1() {
        String scope = "/d1";
        HashSet<Node> excludedNodes = new HashSet<Node>();
        Random r = new Random();
        for (int i = 0; i < 4; ++i) {
            int index = r.nextInt(5);
            excludedNodes.add((Node)this.dataNodes[index]);
        }
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, "/d1", excludedNodes);
        this.verifyResults(5, excludedNodes, frequency);
    }

    @Test
    public void testChooseRandomInclude2() {
        String scope = this.dataNodes[0].getNetworkLocation();
        HashSet<Node> excludedNodes = new HashSet<Node>();
        Random r = new Random();
        int index = r.nextInt(1);
        excludedNodes.add((Node)this.dataNodes[index]);
        int count = 100;
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope, excludedNodes);
        this.verifyResults(1, excludedNodes, frequency);
    }

    private void verifyResults(int upperbound, Set<Node> excludedNodes, Map<Node, Integer> frequency) {
        LOG.info("Excluded nodes are: {}", excludedNodes);
        for (int i = 0; i < upperbound; ++i) {
            DatanodeDescriptor n = this.dataNodes[i];
            LOG.info("Verifying node {}", (Object)n);
            if (excludedNodes.contains(n)) {
                Assertions.assertEquals((int)0, (int)frequency.get(n), (String)(n + " should not have been chosen."));
                continue;
            }
            Assertions.assertTrue((frequency.get(n) > 0 ? 1 : 0) != 0, (String)(n + " should have been chosen"));
        }
    }

    @Test
    public void testChooseRandomInclude3() {
        String scope = "/d1";
        Map<Node, Integer> frequency = this.pickNodesAtRandom(200, scope, null);
        LOG.info("No node is excluded.");
        for (int i = 0; i < 5; ++i) {
            Assertions.assertTrue((frequency.get(this.dataNodes[i]) > 0 ? 1 : 0) != 0, (String)(this.dataNodes[i] + " should have been chosen."));
        }
    }

    @Test
    public void testCountNumOfAvailableNodes() {
        int numNodes = cluster.countNumOfAvailableNodes("", null);
        Assertions.assertEquals((int)20, (int)numNodes);
        HashSet<Object> excludedNodes = new HashSet<Object>();
        excludedNodes.add(this.dataNodes[0]);
        numNodes = cluster.countNumOfAvailableNodes("", excludedNodes);
        Assertions.assertEquals((int)19, (int)numNodes);
        Node d4r1 = cluster.getNode("/d4/r1");
        excludedNodes.add(d4r1);
        numNodes = cluster.countNumOfAvailableNodes("", excludedNodes);
        Assertions.assertEquals((int)12, (int)numNodes);
    }

    @Test
    public void testAddAndRemoveNodeWithEmptyRack() {
        DatanodeDescriptor n1 = DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d2/r3");
        DatanodeDescriptor n2 = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r3");
        DatanodeDescriptor n3 = DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r3");
        cluster.decommissionNode((Node)n1);
        Assertions.assertEquals((int)6, (int)cluster.getNumOfNonEmptyRacks());
        cluster.decommissionNode((Node)n2);
        cluster.decommissionNode((Node)n3);
        Assertions.assertEquals((int)5, (int)cluster.getNumOfNonEmptyRacks());
        cluster.recommissionNode((Node)n1);
        Assertions.assertEquals((int)6, (int)cluster.getNumOfNonEmptyRacks());
    }

    @Test
    public void testShuffle() {
        this.testShuffleInternal(0);
        this.testShuffleInternal(1);
        this.testShuffleInternal(2);
        this.testShuffleInternal(3);
    }

    private void testShuffleInternal(int activeLen) {
        int i;
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        for (i = 0; i < activeLen; ++i) {
            idxList.add(i);
        }
        cluster.setRandomSeed(-559038737L);
        Collections.shuffle(idxList, cluster.getRandom());
        for (i = activeLen; i < 3; ++i) {
            idxList.add(i);
        }
        DatanodeDescriptor[] testNodes = new DatanodeDescriptor[]{this.dataNodes[0], this.dataNodes[1], this.dataNodes[2]};
        cluster.setRandomSeed(-559038737L);
        cluster.shuffle((Node[])testNodes, activeLen);
        for (int i2 = 0; i2 < testNodes.length; ++i2) {
            Assertions.assertEquals((Object)testNodes[i2], (Object)this.dataNodes[(Integer)idxList.get(i2)]);
        }
    }
}

