/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestWebHdfsWithRestCsrfPreventionFilter {
    private static final Path FILE = new Path("/file");
    private boolean nnRestCsrf;
    private boolean dnRestCsrf;
    private boolean clientRestCsrf;
    private MiniDFSCluster cluster;
    private FileSystem fs;
    private FileSystem webhdfs;

    public void initTestWebHdfsWithRestCsrfPreventionFilter(boolean pNnRestCsrf, boolean pDnRestCsrf, boolean pClientRestCsrf) throws Exception {
        this.nnRestCsrf = pNnRestCsrf;
        this.dnRestCsrf = pDnRestCsrf;
        this.clientRestCsrf = pClientRestCsrf;
        this.before();
    }

    public static Iterable<Object[]> data() {
        return Arrays.asList({false, false, false}, {true, true, true}, {true, true, false}, {true, false, true}, {true, false, false}, {false, true, true}, {false, true, false}, {false, false, true});
    }

    public void before() throws Exception {
        Configuration nnConf = new Configuration();
        nnConf.setBoolean("dfs.webhdfs.rest-csrf.enabled", this.nnRestCsrf);
        nnConf.set("dfs.webhdfs.rest-csrf.browser-useragents-regex", ".*");
        this.cluster = new MiniDFSCluster.Builder(nnConf).numDataNodes(0).build();
        Configuration dnConf = new Configuration(nnConf);
        dnConf.setBoolean("dfs.webhdfs.rest-csrf.enabled", this.dnRestCsrf);
        dnConf.set("dfs.datanode.httpserver.filter.handlers", "org.apache.hadoop.hdfs.server.datanode.web.RestCsrfPreventionFilterHandler");
        this.cluster.startDataNodes(dnConf, 1, true, null, null, null, null, false);
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        Configuration clientConf = new Configuration();
        clientConf.setBoolean("dfs.webhdfs.rest-csrf.enabled", this.clientRestCsrf);
        InetSocketAddress addr = this.cluster.getNameNode().getHttpAddress();
        this.webhdfs = FileSystem.get((URI)URI.create("webhdfs://" + NetUtils.getHostPortString((InetSocketAddress)addr)), (Configuration)clientConf);
    }

    @AfterEach
    public void after() {
        IOUtils.closeStream((Closeable)this.webhdfs);
        IOUtils.closeStream((Closeable)this.fs);
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testCreate(boolean pNnRestCsrf, boolean pDnRestCsrf, boolean pClientRestCsrf) throws Exception {
        this.initTestWebHdfsWithRestCsrfPreventionFilter(pNnRestCsrf, pDnRestCsrf, pClientRestCsrf);
        if ((this.nnRestCsrf || this.dnRestCsrf) && !this.clientRestCsrf) {
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> Assertions.assertTrue((boolean)this.webhdfs.createNewFile(FILE)));
            Assertions.assertTrue((boolean)ex.getMessage().contains("Missing Required Header"));
        } else {
            Assertions.assertTrue((boolean)this.webhdfs.createNewFile(FILE));
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testDelete(boolean pNnRestCsrf, boolean pDnRestCsrf, boolean pClientRestCsrf) throws Exception {
        this.initTestWebHdfsWithRestCsrfPreventionFilter(pNnRestCsrf, pDnRestCsrf, pClientRestCsrf);
        DFSTestUtil.createFile(this.fs, FILE, 1024L, (short)1, 0L);
        if (this.nnRestCsrf && !this.clientRestCsrf) {
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> Assertions.assertTrue((boolean)this.webhdfs.delete(FILE, false)));
            Assertions.assertTrue((boolean)ex.getMessage().contains("Missing Required Header"));
        } else {
            Assertions.assertTrue((boolean)this.webhdfs.delete(FILE, false));
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testGetFileStatus(boolean pNnRestCsrf, boolean pDnRestCsrf, boolean pClientRestCsrf) throws Exception {
        this.initTestWebHdfsWithRestCsrfPreventionFilter(pNnRestCsrf, pDnRestCsrf, pClientRestCsrf);
        Assertions.assertNotNull((Object)this.webhdfs.getFileStatus(new Path("/")));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testTruncate(boolean pNnRestCsrf, boolean pDnRestCsrf, boolean pClientRestCsrf) throws Exception {
        this.initTestWebHdfsWithRestCsrfPreventionFilter(pNnRestCsrf, pDnRestCsrf, pClientRestCsrf);
        DFSTestUtil.createFile(this.fs, FILE, 1024L, (short)1, 0L);
        if (this.nnRestCsrf && !this.clientRestCsrf) {
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
                Assertions.assertTrue((boolean)this.webhdfs.hasPathCapability(FILE, "fs.capability.paths.truncate"), (String)"WebHdfs supports truncate");
                Assertions.assertTrue((boolean)this.webhdfs.truncate(FILE, 0L));
            });
            Assertions.assertTrue((boolean)ex.getMessage().contains("Missing Required Header"));
        } else {
            Assertions.assertTrue((boolean)this.webhdfs.hasPathCapability(FILE, "fs.capability.paths.truncate"), (String)"WebHdfs supports truncate");
            Assertions.assertTrue((boolean)this.webhdfs.truncate(FILE, 0L));
        }
    }
}

