/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.StartAfterParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestWebHdfsUrl {
    final URI uri = URI.create("webhdfs://127.0.0.1:0");
    private static final String SPECIAL_CHARACTER_FILENAME = "specialFile ?\"\\()[]_-=&+;,{}#%'`~!@$^*|<>.";
    private static final String BACKWARD_COMPATIBLE_SPECIAL_CHARACTER_FILENAME = "specialFile ?\"\\()[]_-=&,{}#'`~!@$^*|<>.+%";

    @BeforeEach
    public void resetUGI() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    @Timeout(value=60L)
    public void testEncodedPathUrl() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)this.uri, (Configuration)conf);
        String pathName = "/hdtest010%2C60020%2C1371000602151.1371058984668+";
        Path fsPath = new Path(pathName);
        URL encodedPathUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CREATE, fsPath, new Param[0]);
        Assertions.assertEquals((Object)("/webhdfs/v1" + pathName), (Object)encodedPathUrl.toURI().getPath());
    }

    @Test
    @Timeout(value=60L)
    public void testSimpleAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new UserParam(ugi.getShortUserName()).toString()}, fileStatusUrl);
    }

    @Test
    @Timeout(value=60L)
    public void testSimpleProxyAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi = UserGroupInformation.createProxyUser((String)"test-proxy-user", (UserGroupInformation)ugi);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new UserParam(ugi.getRealUser().getShortUserName()).toString(), new DoAsParam(ugi.getShortUserName()).toString()}, fileStatusUrl);
    }

    @Test
    @Timeout(value=60L)
    public void testSecureAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        String tokenString = webhdfs.getDelegationToken().encodeToUrlString();
        String userParam = new UserParam(ugi.getShortUserName()).toString();
        URL getTokenUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN, fsPath, new Param[0]);
        Assertions.assertTrue((getTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{GetOpParam.Op.GETDELEGATIONTOKEN.toQueryString()}, getTokenUrl);
        URL renewTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assertions.assertTrue((renewTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{PutOpParam.Op.RENEWDELEGATIONTOKEN.toQueryString(), new TokenArgumentParam(tokenString).toString()}, renewTokenUrl);
        URL cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assertions.assertTrue((cancelTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
        webhdfs.setDelegationToken(null);
        cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assertions.assertTrue((cancelTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
    }

    @Test
    @Timeout(value=60L)
    public void testSecureProxyAuthParamsInUrl() throws IOException {
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        ugi = UserGroupInformation.createProxyUser((String)"test-proxy-user", (UserGroupInformation)ugi);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/");
        String tokenString = webhdfs.getDelegationToken().encodeToUrlString();
        String userParam = new UserParam(ugi.getRealUser().getShortUserName()).toString();
        URL getTokenUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN, fsPath, new Param[0]);
        Assertions.assertTrue((getTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{GetOpParam.Op.GETDELEGATIONTOKEN.toQueryString(), new DoAsParam(ugi.getShortUserName()).toString()}, getTokenUrl);
        URL renewTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assertions.assertTrue((renewTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{PutOpParam.Op.RENEWDELEGATIONTOKEN.toQueryString(), new DoAsParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, renewTokenUrl);
        URL cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assertions.assertTrue((cancelTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new DoAsParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        URL fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
        webhdfs.setDelegationToken(null);
        cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assertions.assertTrue((cancelTokenUrl.toString().indexOf(userParam) == -1 ? 1 : 0) != 0, (String)"secure webhdfs SHOULD NOT use user.name parameter");
        this.checkQueryParams(new String[]{PutOpParam.Op.CANCELDELEGATIONTOKEN.toQueryString(), new DoAsParam(ugi.getShortUserName()).toString(), new TokenArgumentParam(tokenString).toString()}, cancelTokenUrl);
        fileStatusUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, fsPath, new Param[0]);
        this.checkQueryParams(new String[]{GetOpParam.Op.GETFILESTATUS.toQueryString(), new DelegationParam(tokenString).toString()}, fileStatusUrl);
    }

    @Test
    @Timeout(value=60L)
    public void testCheckAccessUrl() throws IOException {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/p1");
        URL checkAccessUrl = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.CHECKACCESS, fsPath, new Param[]{new FsActionParam(FsAction.READ_WRITE)});
        this.checkQueryParams(new String[]{GetOpParam.Op.CHECKACCESS.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), "fsaction=" + FsAction.READ_WRITE.SYMBOL}, checkAccessUrl);
    }

    @Test
    @Timeout(value=60L)
    public void testBatchedListingUrl() throws Exception {
        Configuration conf = new Configuration();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        WebHdfsFileSystem webhdfs = this.getWebHdfsFileSystem(ugi, conf);
        Path fsPath = new Path("/p1");
        StartAfterParam startAfter = new StartAfterParam("last");
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.LISTSTATUS_BATCH, fsPath, new Param[]{startAfter});
        this.checkQueryParams(new String[]{GetOpParam.Op.LISTSTATUS_BATCH.toQueryString(), new UserParam(ugi.getShortUserName()).toString(), "startafter=last"}, url);
    }

    private void checkQueryParams(String[] expected, URL url) {
        Arrays.sort(expected);
        Object[] query = url.getQuery().split("&");
        Arrays.sort(query);
        Assertions.assertEquals((Object)Arrays.toString(expected), (Object)Arrays.toString(query));
    }

    private WebHdfsFileSystem getWebHdfsFileSystem(UserGroupInformation ugi, Configuration conf) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(ugi.getUserName()), null, null);
            FSNamesystem namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
            DelegationTokenSecretManager dtSecretManager = new DelegationTokenSecretManager(86400000L, 86400000L, 86400000L, 86400000L, namesystem);
            dtSecretManager.startThreads();
            Token token = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)NetUtils.createSocketAddr((String)this.uri.getAuthority()));
            token.setKind(WebHdfsConstants.WEBHDFS_TOKEN_KIND);
            ugi.addToken(token);
        }
        return (WebHdfsFileSystem)FileSystem.get((URI)this.uri, (Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsSpecialCharacterFile() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        Configuration conf = WebHdfsTestUtil.createConf();
        Path dir = new Path("/testWebHdfsSpecialCharacterFile");
        boolean numDatanodes = true;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            long length = 1024L;
            Path file1 = new Path(dir, SPECIAL_CHARACTER_FILENAME);
            DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)1, 20120406L);
            FileStatus s1 = fs.getFileStatus(file1);
            Assertions.assertEquals((long)1024L, (long)s1.getLen(), (String)("Write failed for file " + file1));
            boolean found = false;
            RemoteIterator statusRemoteIterator = fs.listFiles(dir, false);
            while (statusRemoteIterator.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)statusRemoteIterator.next();
                if (!locatedFileStatus.isFile() || !SPECIAL_CHARACTER_FILENAME.equals(locatedFileStatus.getPath().getName())) continue;
                found = true;
            }
            Assertions.assertFalse((!found ? 1 : 0) != 0, (String)"Could not find file with special character");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsBackwardCompatibleSpecialCharacterFile() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        Configuration conf = WebHdfsTestUtil.createConf();
        Path dir = new Path("/testWebHdfsSpecialCharacterFile");
        boolean numDatanodes = true;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            long length = 1024L;
            Path file1 = new Path(dir, BACKWARD_COMPATIBLE_SPECIAL_CHARACTER_FILENAME);
            DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)1, 20120406L);
            FileStatus s1 = fs.getFileStatus(file1);
            Assertions.assertEquals((long)1024L, (long)s1.getLen(), (String)("Write failed for file " + file1));
            boolean found = false;
            RemoteIterator statusRemoteIterator = fs.listFiles(dir, false);
            while (statusRemoteIterator.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)statusRemoteIterator.next();
                if (!locatedFileStatus.isFile() || !BACKWARD_COMPATIBLE_SPECIAL_CHARACTER_FILENAME.equals(locatedFileStatus.getPath().getName())) continue;
                found = true;
            }
            Assertions.assertFalse((!found ? 1 : 0) != 0, (String)"Could not find file with special character");
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testWebHdfsUrlEncoding() throws Exception {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)FileSystem.get((URI)this.uri, (Configuration)WebHdfsTestUtil.createConf());
        String unreserved = "_-!.~'()*";
        String punct = ",:$&=";
        String path = "/testWebHdfsUrlEncoding_-!.~'()*,:$&=";
        URL url = WebHdfsTestUtil.toUrl(fs, (HttpOpParam.Op)GetOpParam.Op.LISTSTATUS, new Path(path), new Param[0]);
        WebHdfsTestUtil.LOG.info(url.getPath());
        Assertions.assertEquals((Object)("/webhdfs/v1" + path), (Object)url.getPath());
    }

    @Test
    public void testWebHdfsPathWithSemicolon() throws Exception {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(WebHdfsTestUtil.createConf()).numDataNodes(1).build();){
            cluster.waitActive();
            Path semicolon = new Path("/a;b");
            Path plus = new Path("/a+b");
            Path percent = new Path("/a%b");
            WebHdfsFileSystem webhdfs = WebHdfsTestUtil.getWebHdfsFileSystem(cluster.getConfiguration(0), "webhdfs");
            webhdfs.create(semicolon).close();
            webhdfs.create(plus).close();
            webhdfs.create(percent).close();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Assertions.assertEquals((Object)semicolon.getName(), (Object)dfs.getFileStatus(semicolon).getPath().getName());
            Assertions.assertEquals((Object)plus.getName(), (Object)dfs.getFileStatus(plus).getPath().getName());
            Assertions.assertEquals((Object)percent.getName(), (Object)dfs.getFileStatus(percent).getPath().getName());
        }
    }
}

