/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestWebHdfsTokens {
    private static final String PREFIX = "hadoop.http.authentication.";
    private static Configuration conf;
    URI uri = null;
    private static MiniKdc kdc;
    private static File baseDir;
    private static File keytabFile;
    private static String username;
    private static String principal;
    private static String keystoresDir;
    private static String sslConfDir;

    @BeforeAll
    public static void setUp() {
        conf = new Configuration();
    }

    @AfterAll
    public static void destroy() throws Exception {
        if (kdc != null) {
            kdc.stop();
            FileUtil.fullyDelete((File)baseDir);
            KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
        }
    }

    private static void initEnv() {
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"LoginUser", (String[])new String[]{"supergroup"}));
    }

    private static void initSecureConf(Configuration secureConf) throws Exception {
        baseDir = GenericTestUtils.getTestDir((String)TestWebHdfsTokens.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assertions.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)secureConf);
        UserGroupInformation.setConfiguration((Configuration)secureConf);
        KerberosName.resetDefaultRealm();
        Assertions.assertTrue((boolean)UserGroupInformation.isSecurityEnabled(), (String)"Expected secureConfiguration to enable security");
        keytabFile = new File(baseDir, username + ".keytab");
        String keytab = keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        principal = username + "/" + krbInstance + "@" + kdc.getRealm();
        String spnegoPrincipal = "HTTP/" + krbInstance + "@" + kdc.getRealm();
        kdc.createPrincipal(keytabFile, new String[]{username, username + "/" + krbInstance, "HTTP/" + krbInstance});
        secureConf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
        secureConf.set("hadoop.http.authentication.type", "kerberos");
        secureConf.set("hadoop.http.authentication.kerberos.keytab", keytab);
        secureConf.set("hadoop.http.authentication.kerberos.principal", spnegoPrincipal);
        secureConf.set("dfs.namenode.kerberos.principal", principal);
        secureConf.set("dfs.namenode.keytab.file", keytab);
        secureConf.set("dfs.datanode.kerberos.principal", principal);
        secureConf.set("dfs.datanode.keytab.file", keytab);
        secureConf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        secureConf.setBoolean("dfs.block.access.token.enable", true);
        secureConf.set("dfs.data.transfer.protection", "authentication");
        secureConf.set("dfs.http.policy", HttpConfig.Policy.HTTP_AND_HTTPS.name());
        secureConf.set("dfs.namenode.https-address", "localhost:0");
        secureConf.set("dfs.namenode.http-address", "localhost:0");
        secureConf.set("dfs.datanode.https.address", "localhost:0");
        secureConf.set("dfs.datanode.http.address", "localhost:0");
        secureConf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        secureConf.setBoolean("ignore.secure.ports.for.testing", true);
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestWebHdfsTokens.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)secureConf, (boolean)false);
        secureConf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        secureConf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
    }

    private WebHdfsFileSystem spyWebhdfsInSecureSetup() throws IOException {
        WebHdfsFileSystem fsOrig = new WebHdfsFileSystem();
        fsOrig.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)fsOrig);
        return fs;
    }

    @Test
    @Timeout(value=5L)
    public void testTokenForNonTokenOp() throws IOException {
        TestWebHdfsTokens.initEnv();
        WebHdfsFileSystem fs = this.spyWebhdfsInSecureSetup();
        Token token = (Token)Mockito.mock(Token.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token).when((Object)fs)).getDelegationToken(null);
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).setDelegationToken(token);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken(token);
    }

    @Test
    @Timeout(value=5L)
    public void testNoTokenForGetToken() throws IOException {
        TestWebHdfsTokens.initEnv();
        this.checkNoTokenForOperation((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN);
    }

    @Test
    @Timeout(value=5L)
    public void testNoTokenForRenewToken() throws IOException {
        TestWebHdfsTokens.initEnv();
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN);
    }

    @Test
    @Timeout(value=5L)
    public void testNoTokenForCancelToken() throws IOException {
        TestWebHdfsTokens.initEnv();
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN);
    }

    private void checkNoTokenForOperation(HttpOpParam.Op op) throws IOException {
        WebHdfsFileSystem fs = this.spyWebhdfsInSecureSetup();
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(null);
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        fs.toUrl(op, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
    }

    @Test
    @Timeout(value=10L)
    public void testGetOpRequireAuth() {
        for (GetOpParam.Op op : GetOpParam.Op.values()) {
            boolean expect = op == GetOpParam.Op.GETDELEGATIONTOKEN;
            Assertions.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test
    @Timeout(value=10L)
    public void testPutOpRequireAuth() {
        for (PutOpParam.Op op : PutOpParam.Op.values()) {
            boolean expect = op == PutOpParam.Op.RENEWDELEGATIONTOKEN || op == PutOpParam.Op.CANCELDELEGATIONTOKEN;
            Assertions.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test
    @Timeout(value=10L)
    public void testPostOpRequireAuth() {
        for (PostOpParam.Op op : PostOpParam.Op.values()) {
            Assertions.assertFalse((boolean)op.getRequireAuth());
        }
    }

    @Test
    @Timeout(value=10L)
    public void testDeleteOpRequireAuth() {
        for (DeleteOpParam.Op op : DeleteOpParam.Op.values()) {
            Assertions.assertFalse((boolean)op.getRequireAuth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazyTokenFetchForWebhdfs() throws Exception {
        MiniDFSCluster cluster = null;
        UserGroupInformation ugi = null;
        try {
            HdfsConfiguration clusterConf = new HdfsConfiguration(conf);
            TestWebHdfsTokens.initSecureConf((Configuration)clusterConf);
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(1).build();
            cluster.waitActive();
            ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytabFile.getAbsolutePath());
            this.uri = DFSUtil.createUri((String)"swebhdfs", (InetSocketAddress)cluster.getNameNode().getHttpsAddress());
            this.validateLazyTokenFetch(ugi, (Configuration)clusterConf);
            this.uri = DFSUtil.createUri((String)"webhdfs", (InetSocketAddress)cluster.getNameNode().getHttpAddress());
            this.validateLazyTokenFetch(ugi, (Configuration)clusterConf);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            UserGroupInformation.reset();
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTokenServiceAndKind() throws Exception {
        TestWebHdfsTokens.initEnv();
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration clusterConf = new HdfsConfiguration(conf);
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.SIMPLE, (Configuration)clusterConf);
            clusterConf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            UserGroupInformation.setConfiguration((Configuration)clusterConf);
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(0).build();
            cluster.waitActive();
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)clusterConf);
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)clusterConf, "webhdfs");
            Whitebox.setInternalState((Object)fs, (String)"canRefreshDelegationToken", (Object)true);
            URLConnectionFactory factory = new URLConnectionFactory(new ConnectionConfigurator(){

                public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                    return conn;
                }
            }){

                public URLConnection openConnection(URL url) throws IOException {
                    return super.openConnection(new URL(url + "&service=foo&kind=bar"));
                }
            };
            Whitebox.setInternalState((Object)fs, (String)"connectionFactory", (Object)factory);
            Token token1 = fs.getDelegationToken();
            Assertions.assertEquals((Object)new Text("bar"), (Object)token1.getKind());
            GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
            WebHdfsFileSystem webHdfsFileSystem = fs;
            webHdfsFileSystem.getClass();
            Token token2 = (Token)new WebHdfsFileSystem.FsPathResponseRunner<Token<DelegationTokenIdentifier>>(webHdfsFileSystem, (HttpOpParam.Op)op, null, new Param[]{new RenewerParam(null)}){
                {
                    WebHdfsFileSystem webHdfsFileSystem = x0;
                    webHdfsFileSystem.getClass();
                    super(webHdfsFileSystem, x1, x2, x3);
                }

                Token<DelegationTokenIdentifier> decodeResponse(Map<?, ?> json) throws IOException {
                    return WebHdfsTestUtil.convertJsonToDelegationToken(json);
                }
            }.run();
            Assertions.assertEquals((Object)new Text("bar"), (Object)token2.getKind());
            Assertions.assertEquals((Object)new Text("foo"), (Object)token2.getService());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void validateLazyTokenFetch(UserGroupInformation ugi, final Configuration clusterConf) throws Exception {
        String testUser = ugi.getShortUserName();
        WebHdfsFileSystem fs = (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws IOException {
                return (WebHdfsFileSystem)Mockito.spy((Object)((WebHdfsFileSystem)FileSystem.newInstance((URI)TestWebHdfsTokens.this.uri, (Configuration)clusterConf)));
            }
        });
        Assertions.assertNull((Object)fs.getRenewToken());
        Token token = fs.getDelegationToken(null);
        fs.renewDelegationToken(token);
        fs.cancelDelegationToken(token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        Assertions.assertNull((Object)fs.getRenewToken());
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        Path p = new Path("/f");
        fs.create(p, (short)1).close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken((String)Mockito.any());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.any());
        token = fs.getRenewToken();
        Assertions.assertNotNull((Object)token);
        Assertions.assertEquals((Object)testUser, (Object)this.getTokenOwner(token));
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.getFileStatus(p);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        Token token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        token = fs.getRenewToken();
        fs.cancelDelegationToken(token);
        try {
            fs.renewDelegationToken(token);
            Assertions.fail((String)"should have failed");
        }
        catch (SecretManager.InvalidToken invalidToken) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("wrong exception:" + ex));
        }
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        try {
            fs.cancelDelegationToken(token);
            Assertions.fail((String)"should have failed");
        }
        catch (SecretManager.InvalidToken ex) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("wrong exception:" + ex));
        }
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        FSDataInputStream is = fs.open(p);
        is.read();
        is.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)3))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.any());
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertNotSame((Object)token, (Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertEquals((Object)testUser, (Object)this.getTokenOwner(token2));
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.cancelDelegationToken(fs.getRenewToken());
        is = fs.open(p);
        is.read();
        is.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)3))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.any());
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertNotSame((Object)token, (Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertEquals((Object)testUser, (Object)this.getTokenOwner(token2));
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).cancelDelegationToken((Token)Mockito.eq((Object)token2));
        token = fs.getDelegationToken(null);
        ugi.addToken(token);
        fs = (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws IOException {
                return (WebHdfsFileSystem)Mockito.spy((Object)((WebHdfsFileSystem)FileSystem.newInstance((URI)TestWebHdfsTokens.this.uri, (Configuration)clusterConf)));
            }
        });
        Assertions.assertNull((Object)fs.getRenewToken());
        fs.getFileStatus(new Path("/"));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.eq((Object)token));
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.getFileStatus(new Path("/"));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.cancelDelegationToken(token);
        for (int i = 0; i < 2; ++i) {
            try {
                fs.getFileStatus(new Path("/"));
                Assertions.fail((String)"didn't fail");
            }
            catch (SecretManager.InvalidToken invalidToken) {
            }
            catch (Exception ex) {
                Assertions.fail((String)("wrong exception:" + ex));
            }
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
            token2 = fs.getRenewToken();
            Assertions.assertNotNull((Object)token2);
            Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
            Assertions.assertSame((Object)token, (Object)token2);
            Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        }
        token = fs.getDelegationToken(null);
        ugi.addToken(token);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.getFileStatus(new Path("/"));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.eq((Object)token));
        token2 = fs.getRenewToken();
        Assertions.assertNotNull((Object)token2);
        Assertions.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assertions.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).cancelDelegationToken((Token)Mockito.any(Token.class));
    }

    private String getTokenOwner(Token<?> token) throws IOException {
        Token clone = new Token(token);
        clone.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
        return clone.decodeIdentifier().getUser().getUserName();
    }

    static {
        kdc = null;
        username = "webhdfs-tokens-test";
    }
}

