/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.JsonUtilClient;
import org.apache.hadoop.util.JsonSerialization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonUtilClient {
    @Test
    public void testToStringArray() {
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList("aaa", "bbb", "ccc"));
        String[] strArr = JsonUtilClient.toStringArray(strList);
        Assertions.assertEquals((int)3, (int)strArr.length, (String)"Expected 3 items in the array");
        Assertions.assertEquals((Object)"aaa", (Object)strArr[0]);
        Assertions.assertEquals((Object)"bbb", (Object)strArr[1]);
        Assertions.assertEquals((Object)"ccc", (Object)strArr[2]);
    }

    @Test
    public void testToBlockLocationArray() throws Exception {
        BlockLocation blockLocation = new BlockLocation(new String[]{"127.0.0.1:62870"}, new String[]{"127.0.0.1"}, null, new String[]{"/default-rack/127.0.0.1:62870"}, null, new StorageType[]{StorageType.DISK}, 0L, 1L, false);
        Map blockLocationsMap = JsonUtil.toJsonMap((BlockLocation[])new BlockLocation[]{blockLocation});
        String json = JsonUtil.toJsonString((String)"BlockLocations", (Object)blockLocationsMap);
        Assertions.assertNotNull((Object)json);
        Map jsonMap = (Map)JsonSerialization.mapReader().readValue(json);
        BlockLocation[] deserializedBlockLocations = JsonUtilClient.toBlockLocationArray((Map)jsonMap);
        Assertions.assertEquals((int)1, (int)deserializedBlockLocations.length);
        Assertions.assertEquals((Object)blockLocation.toString(), (Object)deserializedBlockLocations[0].toString());
    }
}

