/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.JsonUtilClient;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonUtil {
    private static final ObjectReader READER = new ObjectMapper().readerFor(Map.class);

    static FileStatus toFileStatus(HdfsFileStatus f, String parent) {
        return new FileStatus(f.getLen(), f.isDirectory(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(DFSUtilClient.bytes2String((byte[])f.getSymlinkInBytes())) : null, new Path(f.getFullName(parent)));
    }

    @Test
    public void testHdfsFileStatusWithEcPolicy() throws IOException {
        long now = Time.now();
        String parent = "/dir";
        ErasureCodingPolicy dummyEcPolicy = new ErasureCodingPolicy("ecPolicy1", new ECSchema("EcSchema", 1, 1), 2048, 1);
        HdfsFileStatus status = new HdfsFileStatus.Builder().length(1001L).replication(3).blocksize(0x4000000L).mtime(now).atime(now + 10L).perm(new FsPermission(420)).owner("user").group("group").symlink(DFSUtil.string2Bytes((String)"bar")).path(DFSUtil.string2Bytes((String)"foo")).fileId(0L).ecPolicy(dummyEcPolicy).flags(EnumSet.allOf(HdfsFileStatus.Flags.class)).build();
        FileStatus fstatus = TestJsonUtil.toFileStatus(status, "/dir");
        System.out.println("status  = " + status);
        System.out.println("fstatus = " + fstatus);
        String json = JsonUtil.toJsonString((HdfsFileStatus)status, (boolean)true);
        System.out.println("json    = " + json.replace(",", ",\n  "));
        HdfsFileStatus s2 = JsonUtilClient.toFileStatus((Map)((Map)READER.readValue(json)), (boolean)true);
        FileStatus fs2 = TestJsonUtil.toFileStatus(s2, "/dir");
        System.out.println("s2      = " + s2);
        System.out.println("fs2     = " + fs2);
        Assertions.assertEquals((Object)status.getErasureCodingPolicy(), (Object)s2.getErasureCodingPolicy());
        Assertions.assertEquals((Object)fstatus, (Object)fs2);
    }

    @Test
    public void testHdfsFileStatus() throws Exception {
        HdfsFileStatus hdfsFileStatus = new HdfsFileStatus.Builder().replication(1).blocksize(1024L).perm(new FsPermission(777)).owner("owner").group("group").symlink(new byte[0]).path(new byte[0]).fileId(1010L).isdir(true).build();
        Assertions.assertFalse((boolean)hdfsFileStatus.isSymlink());
        LambdaTestUtils.intercept(IOException.class, (String)("Path " + hdfsFileStatus.getPath() + " is not a symbolic link"), () -> hdfsFileStatus.getSymlink());
        String expectString = "HdfsLocatedFileStatus" + "{" + ("path=" + null) + "; isDirectory=true" + "; modification_time=0" + "; access_time=0" + "; owner=owner" + "; group=group" + "; permission=r----x--t" + "; isSymlink=false" + "; hasAcl=false" + "; isEncrypted=false" + "; isErasureCoded=false" + "}";
        Assertions.assertEquals((Object)expectString, (Object)hdfsFileStatus.toString());
    }

    @Test
    public void testHdfsFileStatusWithoutEcPolicy() throws IOException {
        long now = Time.now();
        String parent = "/dir";
        ErasureCodingPolicy dummyEcPolicy = new ErasureCodingPolicy("ecPolicy1", new ECSchema("EcSchema", 1, 1), 2048, 1);
        HdfsFileStatus status = new HdfsFileStatus.Builder().length(1001L).replication(3).blocksize(0x4000000L).mtime(now).atime(now + 10L).perm(new FsPermission(420)).owner("user").group("group").symlink(DFSUtil.string2Bytes((String)"bar")).path(DFSUtil.string2Bytes((String)"foo")).fileId(0L).build();
        Assertions.assertTrue((status.getErasureCodingPolicy() == null ? 1 : 0) != 0);
        FileStatus fstatus = TestJsonUtil.toFileStatus(status, "/dir");
        System.out.println("status  = " + status);
        System.out.println("fstatus = " + fstatus);
        String json = JsonUtil.toJsonString((HdfsFileStatus)status, (boolean)true);
        System.out.println("json    = " + json.replace(",", ",\n  "));
        HdfsFileStatus s2 = JsonUtilClient.toFileStatus((Map)((Map)READER.readValue(json)), (boolean)true);
        FileStatus fs2 = TestJsonUtil.toFileStatus(s2, "/dir");
        System.out.println("s2      = " + s2);
        System.out.println("fs2     = " + fs2);
        Assertions.assertEquals((Object)fstatus, (Object)fs2);
    }

    @Test
    public void testToDatanodeInfoWithoutSecurePort() throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("ipAddr", "127.0.0.1");
        response.put("hostName", "localhost");
        response.put("storageID", "fake-id");
        response.put("xferPort", 1337L);
        response.put("infoPort", 1338L);
        response.put("ipcPort", 1339L);
        response.put("capacity", 1024L);
        response.put("dfsUsed", 512L);
        response.put("remaining", 512L);
        response.put("blockPoolUsed", 512L);
        response.put("lastUpdate", 0L);
        response.put("xceiverCount", 4096L);
        response.put("networkLocation", "foo.bar.baz");
        response.put("adminState", "NORMAL");
        response.put("cacheCapacity", 123L);
        response.put("cacheUsed", 321L);
        JsonUtilClient.toDatanodeInfo(response);
    }

    @Test
    public void testToDatanodeInfoWithName() throws Exception {
        String[] badNames;
        HashMap<String, Object> response = new HashMap<String, Object>();
        String name = "127.0.0.1:1004";
        response.put("name", name);
        response.put("hostName", "localhost");
        response.put("storageID", "fake-id");
        response.put("infoPort", 1338L);
        response.put("ipcPort", 1339L);
        response.put("capacity", 1024L);
        response.put("dfsUsed", 512L);
        response.put("remaining", 512L);
        response.put("blockPoolUsed", 512L);
        response.put("lastUpdate", 0L);
        response.put("xceiverCount", 4096L);
        response.put("networkLocation", "foo.bar.baz");
        response.put("adminState", "NORMAL");
        response.put("cacheCapacity", 123L);
        response.put("cacheUsed", 321L);
        DatanodeInfo di = JsonUtilClient.toDatanodeInfo(response);
        Assertions.assertEquals((Object)name, (Object)di.getXferAddr());
        Map r = JsonUtil.toJsonMap((DatanodeInfo)di);
        Assertions.assertEquals((Object)name, r.get("name"));
        Assertions.assertEquals((Object)"127.0.0.1", r.get("ipAddr"));
        Assertions.assertEquals((int)1004, (int)((Integer)r.get("xferPort")));
        for (String badName : badNames = new String[]{"127.0.0.1", "127.0.0.1:", ":", "127.0.0.1:sweet", ":123"}) {
            response.put("name", badName);
            this.checkDecodeFailure(response);
        }
        response.remove("name");
        this.checkDecodeFailure(response);
        response.put("ipAddr", "127.0.0.1");
        this.checkDecodeFailure(response);
    }

    @Test
    public void testToAclStatus() throws IOException {
        String jsonString = "{\"AclStatus\":{\"entries\":[\"user::rwx\",\"user:user1:rw-\",\"group::rw-\",\"other::r-x\"],\"group\":\"supergroup\",\"owner\":\"testuser\",\"stickyBit\":false}}";
        Map json = (Map)READER.readValue(jsonString);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE)});
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner("testuser");
        aclStatusBuilder.group("supergroup");
        aclStatusBuilder.addEntries((Iterable)aclSpec);
        aclStatusBuilder.stickyBit(false);
        Assertions.assertEquals((Object)aclStatusBuilder.build(), (Object)JsonUtilClient.toAclStatus((Map)json), (String)"Should be equal");
    }

    @Test
    public void testToJsonFromAclStatus() {
        String jsonString = "{\"AclStatus\":{\"entries\":[\"user:user1:rwx\",\"group::rw-\"],\"group\":\"supergroup\",\"owner\":\"testuser\",\"stickyBit\":false}}";
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner("testuser");
        aclStatusBuilder.group("supergroup");
        aclStatusBuilder.stickyBit(false);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)});
        aclStatusBuilder.addEntries((Iterable)aclSpec);
        Assertions.assertEquals((Object)jsonString, (Object)JsonUtil.toJsonString((AclStatus)aclStatusBuilder.build()));
    }

    @Test
    public void testToJsonFromContentSummary() {
        String jsonString = "{\"ContentSummary\":{\"directoryCount\":33333,\"ecPolicy\":\"RS-6-3-1024k\",\"fileCount\":22222,\"length\":11111,\"quota\":44444,\"snapshotDirectoryCount\":1,\"snapshotFileCount\":2,\"snapshotLength\":10,\"snapshotSpaceConsumed\":30,\"spaceConsumed\":55555,\"spaceQuota\":66666,\"typeQuota\":{}}}";
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66666L;
        String ecPolicy = "RS-6-3-1024k";
        long snapshotLength = 10L;
        long snapshotFileCount = 2L;
        long snapshotDirectoryCount = 1L;
        long snapshotSpaceConsumed = 30L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).erasureCodingPolicy(ecPolicy).snapshotLength(snapshotLength).snapshotFileCount(snapshotFileCount).snapshotDirectoryCount(snapshotDirectoryCount).snapshotSpaceConsumed(snapshotSpaceConsumed).build();
        Assertions.assertEquals((Object)jsonString, (Object)JsonUtil.toJsonString((ContentSummary)contentSummary));
    }

    @Test
    public void testToJsonFromXAttrs() throws IOException {
        String jsonString = "{\"XAttrs\":[{\"name\":\"user.a1\",\"value\":\"0x313233\"},{\"name\":\"user.a2\",\"value\":\"0x313131\"}]}";
        XAttr xAttr1 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a1").setValue(XAttrCodec.decodeValue((String)"0x313233")).build();
        XAttr xAttr2 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a2").setValue(XAttrCodec.decodeValue((String)"0x313131")).build();
        ArrayList xAttrs = Lists.newArrayList();
        xAttrs.add(xAttr1);
        xAttrs.add(xAttr2);
        Assertions.assertEquals((Object)jsonString, (Object)JsonUtil.toJsonString((List)xAttrs, (XAttrCodec)XAttrCodec.HEX));
    }

    @Test
    public void testToXAttrMap() throws IOException {
        String jsonString = "{\"XAttrs\":[{\"name\":\"user.a1\",\"value\":\"0x313233\"},{\"name\":\"user.a2\",\"value\":\"0x313131\"}]}";
        Map json = (Map)READER.readValue(jsonString);
        XAttr xAttr1 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a1").setValue(XAttrCodec.decodeValue((String)"0x313233")).build();
        XAttr xAttr2 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a2").setValue(XAttrCodec.decodeValue((String)"0x313131")).build();
        ArrayList xAttrs = Lists.newArrayList();
        xAttrs.add(xAttr1);
        xAttrs.add(xAttr2);
        Map xAttrMap = XAttrHelper.buildXAttrMap((List)xAttrs);
        Map parsedXAttrMap = JsonUtilClient.toXAttrs((Map)json);
        Assertions.assertEquals((int)xAttrMap.size(), (int)parsedXAttrMap.size());
        for (Map.Entry entry : xAttrMap.entrySet()) {
            Assertions.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])((byte[])parsedXAttrMap.get(entry.getKey())));
        }
    }

    @Test
    public void testGetXAttrFromJson() throws IOException {
        String jsonString = "{\"XAttrs\":[{\"name\":\"user.a1\",\"value\":\"0x313233\"},{\"name\":\"user.a2\",\"value\":\"0x313131\"}]}";
        Map json = (Map)READER.readValue(jsonString);
        byte[] value = JsonUtilClient.getXAttr((Map)json, (String)"user.a2");
        Assertions.assertArrayEquals((byte[])XAttrCodec.decodeValue((String)"0x313131"), (byte[])value);
    }

    @Test
    public void testSnapshotDiffReportListingEmptyReport() throws IOException {
        SnapshotDiffReportListing report = new SnapshotDiffReportListing();
        String jsonString = JsonUtil.toJsonString((SnapshotDiffReportListing)report);
        Map json = (Map)READER.readValue(jsonString);
        SnapshotDiffReportListing parsed = JsonUtilClient.toSnapshotDiffReportListing((Map)json);
        this.assertSnapshotListingEquals(report, parsed);
    }

    @Test
    public void testSnapshotDiffReportListing() throws IOException {
        ChunkedArrayList mlist = new ChunkedArrayList();
        ChunkedArrayList clist = new ChunkedArrayList();
        ChunkedArrayList dlist = new ChunkedArrayList();
        clist.add(new SnapshotDiffReportListing.DiffReportListingEntry(1L, 2L, DFSUtilClient.string2Bytes((String)"dir1/file2"), false, null));
        clist.add(new SnapshotDiffReportListing.DiffReportListingEntry(1L, 3L, DFSUtilClient.string2Bytes((String)"dir1/file3"), false, null));
        dlist.add(new SnapshotDiffReportListing.DiffReportListingEntry(1L, 4L, DFSUtilClient.string2Bytes((String)"dir1/file4"), false, null));
        dlist.add(new SnapshotDiffReportListing.DiffReportListingEntry(1L, 5L, DFSUtilClient.string2Bytes((String)"dir1/file5"), true, DFSUtilClient.string2Bytes((String)"dir1/file6")));
        SnapshotDiffReportListing report = new SnapshotDiffReportListing(DFSUtilClient.string2Bytes((String)"dir1/file2"), (List)mlist, (List)clist, (List)dlist, 3, true);
        String jsonString = JsonUtil.toJsonString((SnapshotDiffReportListing)report);
        Map json = (Map)READER.readValue(jsonString);
        SnapshotDiffReportListing parsed = JsonUtilClient.toSnapshotDiffReportListing((Map)json);
        this.assertSnapshotListingEquals(report, parsed);
    }

    private void assertSnapshotListingEquals(SnapshotDiffReportListing expected, SnapshotDiffReportListing actual) {
        Assertions.assertEquals((int)expected.getLastIndex(), (int)actual.getLastIndex());
        Assertions.assertEquals((Object)expected.getIsFromEarlier(), (Object)actual.getIsFromEarlier());
        this.assertEntryListEquals(expected.getModifyList(), actual.getModifyList());
        this.assertEntryListEquals(expected.getCreateList(), actual.getCreateList());
        this.assertEntryListEquals(expected.getDeleteList(), actual.getDeleteList());
        Assertions.assertArrayEquals((byte[])expected.getLastPath(), (byte[])actual.getLastPath());
    }

    private void assertEntryListEquals(List<SnapshotDiffReportListing.DiffReportListingEntry> expected, List<SnapshotDiffReportListing.DiffReportListingEntry> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            SnapshotDiffReportListing.DiffReportListingEntry a = expected.get(i);
            SnapshotDiffReportListing.DiffReportListingEntry b = actual.get(i);
            Assertions.assertEquals((long)a.getFileId(), (long)b.getFileId());
            Assertions.assertEquals((long)a.getDirId(), (long)b.getDirId());
            Assertions.assertEquals((Object)a.isReference(), (Object)b.isReference());
            if (a.getSourcePath() != null) {
                Assertions.assertArrayEquals((byte[])DFSUtilClient.byteArray2bytes((byte[][])a.getSourcePath()), (byte[])DFSUtilClient.byteArray2bytes((byte[][])b.getSourcePath()));
            } else {
                Assertions.assertArrayEquals((Object[])a.getSourcePath(), (Object[])b.getSourcePath());
            }
            if (a.getTargetPath() != null) {
                Assertions.assertArrayEquals((byte[])DFSUtilClient.byteArray2bytes((byte[][])a.getTargetPath()), (byte[])DFSUtilClient.byteArray2bytes((byte[][])b.getTargetPath()));
                continue;
            }
            Assertions.assertArrayEquals((Object[])a.getTargetPath(), (Object[])b.getTargetPath());
        }
    }

    private void checkDecodeFailure(Map<String, Object> map) {
        try {
            JsonUtilClient.toDatanodeInfo(map);
            Assertions.fail((String)"Exception not thrown against bad input.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

