/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.File;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestHttpsFileSystem {
    private static final String BASEDIR = GenericTestUtils.getTempPath((String)TestHttpsFileSystem.class.getSimpleName());
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static String keystoresDir;
    private static String sslConfDir;
    private static String nnAddr;

    @BeforeAll
    public static void setUp() throws Exception {
        conf = new Configuration();
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestHttpsFileSystem.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        FSDataOutputStream os = cluster.getFileSystem().create(new Path("/test"));
        os.write(23);
        os.close();
        InetSocketAddress addr = cluster.getNameNode().getHttpsAddress();
        nnAddr = NetUtils.getHostPortString((InetSocketAddress)addr);
        conf.set("dfs.namenode.https-address", nnAddr);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Test
    public void testSWebHdfsFileSystem() throws Exception {
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "swebhdfs");
        Path f = new Path("/testswebhdfs");
        FSDataOutputStream os = fs.create(f);
        os.write(23);
        os.close();
        Assertions.assertTrue((boolean)fs.exists(f));
        FSDataInputStream is = fs.open(f);
        Assertions.assertEquals((int)23, (int)is.read());
        is.close();
        fs.close();
    }
}

