/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.apache.hadoop.hdfs.web.AuthFilterInitializer;
import org.apache.hadoop.http.FilterContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAuthFilter {
    private static final String PREFIX = "hadoop.http.authentication.";

    @Test
    public void testGetConfiguration() {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.authentication.type", "kerberos");
        conf.set("hadoop.http.authentication.kerberos.keytab", "thekeytab");
        conf.set("hadoop.http.authentication.kerberos.principal", "xyz/thehost@REALM");
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        ((FilterContainer)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) {
                Object[] args = invocationOnMock.getArguments();
                Assertions.assertEquals((Object)"AuthFilter", (Object)args[0]);
                Assertions.assertEquals((Object)AuthFilter.class.getName(), (Object)args[1]);
                Map conf = (Map)args[2];
                Assertions.assertEquals((Object)"/", conf.get("cookie.path"));
                Assertions.assertEquals((Object)"kerberos", conf.get("type"));
                Assertions.assertNull(conf.get("cookie.domain"));
                Assertions.assertEquals((Object)"xyz/thehost@REALM", conf.get("kerberos.principal"));
                Assertions.assertEquals((Object)"thekeytab", conf.get("kerberos.keytab"));
                Assertions.assertEquals((Object)"true", conf.get("simple.anonymous.allowed"));
                return null;
            }
        }).when((Object)container)).addFilter((String)Mockito.any(), (String)Mockito.any(), (Map)Mockito.any());
        new AuthFilterInitializer().initFilter(container, conf);
    }
}

