/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLightWeightLinkedSet {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestLightWeightLinkedSet");
    private final ArrayList<Integer> list = new ArrayList();
    private final int NUM = 100;
    private LightWeightLinkedSet<Integer> set;
    private Random rand;

    @BeforeEach
    public void setUp() {
        float maxF = 0.75f;
        float minF = 0.2f;
        int initCapacity = 16;
        this.rand = new Random(Time.now());
        this.list.clear();
        for (int i = 0; i < 100; ++i) {
            this.list.add(this.rand.nextInt());
        }
        this.set = new LightWeightLinkedSet(initCapacity, maxF, minF);
    }

    @Test
    public void testEmptyBasic() {
        LOG.info("Test empty basic");
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        Assertions.assertNull((Object)this.set.pollFirst());
        Assertions.assertEquals((int)0, (int)this.set.pollAll().size());
        Assertions.assertEquals((int)0, (int)this.set.pollN(10).size());
        LOG.info("Test empty - DONE");
    }

    @Test
    public void testOneElementBasic() {
        LOG.info("Test one element basic");
        this.set.add((Object)this.list.get(0));
        Assertions.assertEquals((int)1, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.isEmpty());
        Iterator iter = this.set.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Integer)this.list.get(0), (Integer)((Integer)iter.next()));
        Assertions.assertFalse((boolean)iter.hasNext());
        LOG.info("Test one element basic - DONE");
    }

    @Test
    public void testMultiBasic() {
        LOG.info("Test multi element basic");
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i));
        }
        Assertions.assertEquals((int)this.list.size(), (int)this.set.size());
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.contains((Object)i));
        }
        for (Integer i : this.list) {
            Assertions.assertFalse((boolean)this.set.add((Object)i));
        }
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.contains((Object)i));
        }
        Iterator iter = this.set.iterator();
        int num = 0;
        while (iter.hasNext()) {
            Assertions.assertEquals((Integer)this.list.get(num++), (Integer)((Integer)iter.next()));
        }
        Assertions.assertEquals((int)this.list.size(), (int)num);
        LOG.info("Test multi element basic - DONE");
    }

    @Test
    public void testRemoveOne() {
        LOG.info("Test remove one");
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assertions.assertEquals((int)1, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.remove((Object)this.list.get(0)));
        Assertions.assertEquals((int)0, (int)this.set.size());
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertNull((Object)this.set.pollFirst());
        Assertions.assertEquals((int)0, (int)this.set.pollAll().size());
        Assertions.assertEquals((int)0, (int)this.set.pollN(10).size());
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assertions.assertEquals((int)1, (int)this.set.size());
        iter = this.set.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        LOG.info("Test remove one - DONE");
    }

    @Test
    public void testRemoveMulti() {
        int i;
        LOG.info("Test remove multi");
        for (Integer i2 : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 50; ++i) {
            Assertions.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 50; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        for (i = 50; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        int num = 50;
        while (iter.hasNext()) {
            Assertions.assertEquals((Integer)this.list.get(num++), (Integer)((Integer)iter.next()));
        }
        Assertions.assertEquals((int)num, (int)100);
        LOG.info("Test remove multi - DONE");
    }

    @Test
    public void testRemoveAll() {
        int i;
        LOG.info("Test remove all");
        for (Integer i2 : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 100; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        LOG.info("Test remove all - DONE");
    }

    @Test
    public void testPollOneElement() {
        LOG.info("Test poll one element");
        this.set.add((Object)this.list.get(0));
        Assertions.assertEquals((Integer)this.list.get(0), (Integer)((Integer)this.set.pollFirst()));
        Assertions.assertNull((Object)this.set.pollFirst());
        LOG.info("Test poll one element - DONE");
    }

    @Test
    public void testPollMulti() {
        int i;
        int i2;
        LOG.info("Test poll multi");
        for (Integer i3 : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i3));
        }
        for (i2 = 0; i2 < 50; ++i2) {
            Assertions.assertEquals((Integer)this.list.get(i2), (Integer)((Integer)this.set.pollFirst()));
        }
        Assertions.assertEquals((int)50, (int)this.set.size());
        for (i2 = 0; i2 < 50; ++i2) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i2)));
        }
        for (i2 = 50; i2 < 100; ++i2) {
            Assertions.assertTrue((boolean)this.set.contains((Object)this.list.get(i2)));
        }
        Iterator iter = this.set.iterator();
        int num = 50;
        while (iter.hasNext()) {
            Assertions.assertEquals((Integer)this.list.get(num++), (Integer)((Integer)iter.next()));
        }
        Assertions.assertEquals((int)num, (int)100);
        for (i = 0; i < 50; ++i) {
            Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(i)));
        }
        Assertions.assertEquals((int)100, (int)this.set.size());
        for (i = 50; i < 100; ++i) {
            Assertions.assertEquals((Integer)this.list.get(i), (Integer)((Integer)this.set.pollFirst()));
        }
        for (i = 0; i < 50; ++i) {
            Assertions.assertEquals((Integer)this.list.get(i), (Integer)((Integer)this.set.pollFirst()));
        }
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        LOG.info("Test poll multi - DONE");
    }

    @Test
    public void testPollAll() {
        LOG.info("Test poll all");
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i));
        }
        while (this.set.pollFirst() != null) {
        }
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        for (int i = 0; i < 100; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        LOG.info("Test poll all - DONE");
    }

    @Test
    public void testPollNOne() {
        LOG.info("Test pollN one");
        this.set.add((Object)this.list.get(0));
        List l = this.set.pollN(10);
        Assertions.assertEquals((int)1, (int)l.size());
        Assertions.assertEquals((Integer)this.list.get(0), (Integer)((Integer)l.get(0)));
        LOG.info("Test pollN one - DONE");
    }

    @Test
    public void testPollNMulti() {
        int i;
        LOG.info("Test pollN multi");
        this.set.addAll(this.list);
        List l = this.set.pollN(10);
        Assertions.assertEquals((int)10, (int)l.size());
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((Integer)this.list.get(i), (Integer)((Integer)l.get(i)));
        }
        l = this.set.pollN(1000);
        Assertions.assertEquals((int)90, (int)l.size());
        for (i = 10; i < 100; ++i) {
            Assertions.assertEquals((Integer)this.list.get(i), (Integer)((Integer)l.get(i - 10)));
        }
        Assertions.assertTrue((boolean)this.set.isEmpty());
        Assertions.assertEquals((int)0, (int)this.set.size());
        LOG.info("Test pollN multi - DONE");
    }

    @Test
    public void testClear() {
        LOG.info("Test clear");
        this.set.addAll(this.list);
        Assertions.assertEquals((int)100, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.isEmpty());
        Iterator bkmrkIt = this.set.getBookmark();
        for (int i = 0; i < this.set.size() / 2 + 1; ++i) {
            bkmrkIt.next();
        }
        Assertions.assertTrue((boolean)bkmrkIt.hasNext());
        this.set.clear();
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        bkmrkIt = this.set.getBookmark();
        Assertions.assertFalse((boolean)bkmrkIt.hasNext());
        Assertions.assertEquals((int)0, (int)this.set.pollAll().size());
        Assertions.assertEquals((int)0, (int)this.set.pollN(10).size());
        Assertions.assertNull((Object)this.set.pollFirst());
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        LOG.info("Test clear - DONE");
    }

    @Test
    public void testOther() {
        LOG.info("Test other");
        Assertions.assertTrue((boolean)this.set.addAll(this.list));
        Integer[] array = (Integer[])this.set.toArray((Object[])new Integer[0]);
        Assertions.assertEquals((int)100, (int)array.length);
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertTrue((boolean)this.list.contains(array[i]));
        }
        Assertions.assertEquals((int)100, (int)this.set.size());
        Object[] array2 = this.set.toArray();
        Assertions.assertEquals((int)100, (int)array2.length);
        for (int i = 0; i < array2.length; ++i) {
            Assertions.assertTrue((boolean)this.list.contains(array2[i]));
        }
        LOG.info("Test capacity - DONE");
    }

    @Test
    @Timeout(value=60L)
    public void testGetBookmarkReturnsBookmarkIterator() {
        LOG.info("Test getBookmark returns proper iterator");
        Assertions.assertTrue((boolean)this.set.addAll(this.list));
        Iterator bookmark = this.set.getBookmark();
        Assertions.assertEquals((Integer)((Integer)bookmark.next()), (Integer)this.list.get(0));
        int numAdvance = this.list.size() / 2;
        for (int i = 1; i < numAdvance; ++i) {
            bookmark.next();
        }
        Iterator bookmark2 = this.set.getBookmark();
        Assertions.assertEquals((Integer)((Integer)bookmark2.next()), (Integer)this.list.get(numAdvance));
    }

    @Test
    @Timeout(value=60L)
    public void testBookmarkAdvancesOnRemoveOfSameElement() {
        LOG.info("Test that the bookmark advances if we remove its element.");
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(1)));
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(2)));
        Iterator it = this.set.getBookmark();
        Assertions.assertEquals((Integer)((Integer)it.next()), (Integer)this.list.get(0));
        this.set.remove((Object)this.list.get(1));
        it = this.set.getBookmark();
        Assertions.assertEquals((Integer)((Integer)it.next()), (Integer)this.list.get(2));
    }

    @Test
    @Timeout(value=60L)
    public void testBookmarkSetToHeadOnAddToEmpty() {
        LOG.info("Test bookmark is set after adding to previously empty set.");
        Iterator it = this.set.getBookmark();
        Assertions.assertFalse((boolean)it.hasNext());
        this.set.add((Object)this.list.get(0));
        this.set.add((Object)this.list.get(1));
        it = this.set.getBookmark();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Integer)((Integer)it.next()), (Integer)this.list.get(0));
        Assertions.assertEquals((Integer)((Integer)it.next()), (Integer)this.list.get(1));
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    @Timeout(value=60L)
    public void testResetBookmarkPlacesBookmarkAtHead() {
        this.set.addAll(this.list);
        Iterator it = this.set.getBookmark();
        int numAdvance = this.set.size() / 2;
        for (int i = 0; i < numAdvance; ++i) {
            it.next();
        }
        Assertions.assertEquals((Integer)((Integer)it.next()), (Integer)this.list.get(numAdvance));
        this.set.resetBookmark();
        it = this.set.getBookmark();
        Assertions.assertEquals((Integer)((Integer)it.next()), (Integer)this.list.get(0));
    }
}

