/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.util.CombinedHostsFileReader;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestCombinedHostsFileReader {
    static final String HOSTSTESTDIR = GenericTestUtils.getTestDir().getAbsolutePath();
    private final File newFile = new File(HOSTSTESTDIR, "dfs.hosts.new.json");
    static final String TESTCACHEDATADIR = System.getProperty("test.cache.data", "build/test/cache");
    private final File jsonFile = new File(TESTCACHEDATADIR, "dfs.hosts.json");
    private final File legacyFile = new File(TESTCACHEDATADIR, "legacy.dfs.hosts.json");
    @Mock
    private Callable<DatanodeAdminProperties[]> callable;

    @BeforeEach
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.newFile.delete();
    }

    @Test
    public void testLoadLegacyJsonFile() throws Exception {
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFile((String)this.legacyFile.getAbsolutePath());
        Assertions.assertEquals((int)7, (int)all.length);
    }

    @Test
    public void testLoadExistingJsonFile() throws Exception {
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFile((String)this.jsonFile.getAbsolutePath());
        Assertions.assertEquals((int)7, (int)all.length);
    }

    @Test
    public void testEmptyCombinedHostsFileReader() throws Exception {
        FileWriter hosts = new FileWriter(this.newFile);
        hosts.write("");
        hosts.close();
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFile((String)this.newFile.getAbsolutePath());
        Assertions.assertEquals((int)0, (int)all.length);
    }

    @Test
    public void testReadFileWithTimeoutSuccess() throws Exception {
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFileWithTimeout((String)this.jsonFile.getAbsolutePath(), (int)1000);
        Assertions.assertEquals((int)7, (int)all.length);
    }

    @Test
    public void testReadFileWithTimeoutTimeoutException() throws Exception {
        Mockito.when((Object)this.callable.call()).thenAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(2000L);
                return null;
            }
        });
        Assertions.assertThrows(IOException.class, () -> CombinedHostsFileReader.readFileWithTimeout((String)this.jsonFile.getAbsolutePath(), (int)1));
    }

    @Order(value=1)
    @Test
    public void testReadFileWithTimeoutInterruptedException() throws Exception {
        Mockito.when((Object)this.callable.call()).thenAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                throw new InterruptedException();
            }
        });
        Assertions.assertThrows(IOException.class, () -> CombinedHostsFileReader.readFileWithTimeout((String)this.jsonFile.getAbsolutePath(), (int)1));
    }
}

