/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAtomicFileOutputStream {
    private static final String TEST_STRING = "hello world";
    private static final String TEST_STRING_2 = "goodbye world";
    private static final File TEST_DIR = PathUtils.getTestDir(TestAtomicFileOutputStream.class);
    private static final File DST_FILE = new File(TEST_DIR, "test.txt");

    @BeforeEach
    public void cleanupTestDir() throws IOException {
        Assertions.assertTrue((TEST_DIR.exists() || TEST_DIR.mkdirs() ? 1 : 0) != 0);
        FileUtil.fullyDeleteContents((File)TEST_DIR);
    }

    @Test
    public void testWriteNewFile() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(DST_FILE);
        Assertions.assertFalse((boolean)DST_FILE.exists());
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        Assertions.assertFalse((boolean)DST_FILE.exists());
        fos.close();
        Assertions.assertTrue((boolean)DST_FILE.exists());
        String readBackData = DFSTestUtil.readFile(DST_FILE);
        Assertions.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testOverwriteFile() throws IOException {
        Assertions.assertTrue((boolean)DST_FILE.createNewFile(), (String)"Creating empty dst file");
        AtomicFileOutputStream fos = new AtomicFileOutputStream(DST_FILE);
        Assertions.assertTrue((boolean)DST_FILE.exists(), (String)"Empty file still exists");
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        Assertions.assertEquals((Object)"", (Object)DFSTestUtil.readFile(DST_FILE));
        fos.close();
        String readBackData = DFSTestUtil.readFile(DST_FILE);
        Assertions.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testFailToFlush() throws IOException {
        FileOutputStream fos = new FileOutputStream(DST_FILE);
        fos.write(TEST_STRING_2.getBytes());
        fos.close();
        OutputStream failingStream = this.createFailingStream();
        failingStream.write(TEST_STRING.getBytes());
        try {
            failingStream.close();
            Assertions.fail((String)"Close didn't throw exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)TEST_STRING_2, (Object)DFSTestUtil.readFile(DST_FILE));
        Assertions.assertEquals((Object)DST_FILE.getName(), (Object)Joiner.on((String)",").join((Object[])TEST_DIR.list()), (String)"Temporary file should have been cleaned up");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailToRename() throws IOException {
        PlatformAssumptions.assumeWindows();
        AtomicFileOutputStream fos = null;
        try {
            fos = new AtomicFileOutputStream(DST_FILE);
            fos.write(TEST_STRING.getBytes());
            FileUtil.setWritable((File)TEST_DIR, (boolean)false);
            AtomicFileOutputStream toClose = fos;
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> TestAtomicFileOutputStream.lambda$testFailToRename$0((OutputStream)toClose));
            Assertions.assertTrue((boolean)ex.getMessage().contains("failure in native rename"));
            fos = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fos});
            FileUtil.setWritable((File)TEST_DIR, (boolean)true);
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fos});
        FileUtil.setWritable((File)TEST_DIR, (boolean)true);
    }

    private OutputStream createFailingStream() throws FileNotFoundException {
        return new AtomicFileOutputStream(DST_FILE){

            public void flush() throws IOException {
                throw new IOException("injected failure");
            }
        };
    }

    private static /* synthetic */ void lambda$testFailToRename$0(OutputStream toClose) throws Throwable {
        toClose.close();
    }
}

