/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewerPB;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOfflineImageViewerForErasureCodingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TestOfflineImageViewerForErasureCodingPolicy.class);
    private static File originalFsimage = null;
    private static File tempDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeAll
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.namenode.acls.enabled", true);
            conf.setBoolean("dfs.storage.policy.enabled", true);
            File[] nnDirs = MiniDFSCluster.getNameNodeDirectory(MiniDFSCluster.getBaseDirectory(), 0, 0);
            tempDir = nnDirs[0];
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(10).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.enableErasureCodingPolicy("RS-6-3-1024k");
            hdfs.enableErasureCodingPolicy("RS-3-2-1024k");
            Path dir = new Path("/dir_wo_ec_rs63");
            hdfs.mkdirs(dir);
            hdfs.setErasureCodingPolicy(dir, "RS-6-3-1024k");
            dir = new Path("/dir_wo_ec_rs63/sub_dir_1");
            hdfs.mkdirs(dir);
            dir = new Path("/dir_wo_ec_rs63/sub_dir_2");
            hdfs.mkdirs(dir);
            Path file = new Path("/dir_wo_ec_rs63/file_wo_ec_1");
            try (FSDataOutputStream o = hdfs.create(file);){
                o.write(123);
            }
            file = new Path("/dir_wo_ec_rs63/file_wo_ec_2");
            o = hdfs.create(file);
            var7_7 = null;
            try {
                o.write(123);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (o != null) {
                    if (var7_7 != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        o.close();
                    }
                }
            }
            dir = new Path("/dir_wo_ec_rs32");
            hdfs.mkdirs(dir);
            hdfs.setErasureCodingPolicy(dir, "RS-3-2-1024k");
            dir = new Path("/dir_wo_ec_rs32/sub_dir_1");
            hdfs.mkdirs(dir);
            file = new Path("/dir_wo_ec_rs32/file_wo_ec");
            o = hdfs.create(file);
            var7_7 = null;
            try {
                o.write(123);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (o != null) {
                    if (var7_7 != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        o.close();
                    }
                }
            }
            dir = new Path("/dir_wo_rep");
            hdfs.mkdirs(dir);
            dir = new Path("/dir_wo_rep/sub_dir_1");
            hdfs.mkdirs(dir);
            file = new Path("/dir_wo_rep/file_rep");
            o = hdfs.create(file);
            var7_7 = null;
            try {
                o.write(123);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (o != null) {
                    if (var7_7 != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        o.close();
                    }
                }
            }
            hdfs.setSafeMode(SafeModeAction.ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug("original FS image file is " + originalFsimage);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterAll
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    @Test
    public void testPBDelimitedWriterForErasureCodingPolicy() throws Exception {
        String expected = DFSTestUtil.readResoucePlainFile("testErasureCodingPolicy.csv");
        String result = this.readECPolicyFromFsimageFile();
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    private String readECPolicyFromFsimageFile() throws Exception {
        StringBuilder builder = new StringBuilder();
        String delemiter = "\t";
        File delimitedOutput = new File(tempDir, "delimitedOutput");
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "Delimited", "-i", originalFsimage.getAbsolutePath(), "-o", delimitedOutput.getAbsolutePath(), "-ec"}) != 0) {
            throw new IOException("oiv returned failure creating delimited output with ec.");
        }
        try (FileInputStream input = new FileInputStream(delimitedOutput);
             BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            boolean header = true;
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split(delemiter);
                if (!header) {
                    String path = fields[0];
                    String ecPolicy = fields[12];
                    builder.append(path).append(",").append(ecPolicy).append("\n");
                }
                header = false;
            }
        }
        return builder.toString();
    }
}

