/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.FakeRenewer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDelegationTokenFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(TestDelegationTokenFetcher.class);
    private Configuration conf = new Configuration();
    private static final String tokenFile = "token";

    @Test
    public void testTokenFetchFail(@TempDir java.nio.file.Path folder) throws Exception {
        Assertions.assertThrows(IOException.class, () -> {
            WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
            ((WebHdfsFileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)fs)).getDelegationToken((String)ArgumentMatchers.any());
            Path p = new Path(folder.toAbsolutePath().toString(), tokenFile);
            DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
        });
    }

    @Test
    public void expectedTokenIsRetrievedFromHttp(@TempDir java.nio.file.Path folder) throws Exception {
        Token testToken = new Token("id".getBytes(), "pwd".getBytes(), FakeRenewer.KIND, new Text("127.0.0.1:1234"));
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)testToken).when((Object)fs)).getDelegationToken((String)ArgumentMatchers.any());
        Path p = new Path(folder.toAbsolutePath().toString(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
        Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
        Iterator itr = creds.getAllTokens().iterator();
        Assertions.assertTrue((boolean)itr.hasNext(), (String)"token not exist error");
        Token fetchedToken = (Token)itr.next();
        Assertions.assertArrayEquals((byte[])testToken.getIdentifier(), (byte[])fetchedToken.getIdentifier(), (String)"token wrong identifier error");
        Assertions.assertArrayEquals((byte[])testToken.getPassword(), (byte[])fetchedToken.getPassword(), (String)"token wrong password error");
        DelegationTokenFetcher.renewTokens((Configuration)this.conf, (Path)p);
        Assertions.assertEquals((Object)testToken, FakeRenewer.getLastRenewed());
        DelegationTokenFetcher.cancelTokens((Configuration)this.conf, (Path)p);
        Assertions.assertEquals((Object)testToken, FakeRenewer.getLastCanceled());
    }

    @Test
    public void testReturnedTokenIsNull(@TempDir java.nio.file.Path folder) throws Exception {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(ArgumentMatchers.anyString());
        Path p = new Path(folder.toAbsolutePath().toString(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
        Assertions.assertFalse((boolean)p.getFileSystem(this.conf).exists(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationTokenWithoutRenewerViaRPC(@TempDir java.nio.file.Path folder) throws Exception {
        this.conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.conf);
            Path p = new Path(folder.toAbsolutePath().toString(), tokenFile);
            p = localFileSystem.makeQualified(p);
            DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
            Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
            Iterator itr = creds.getAllTokens().iterator();
            Assertions.assertTrue((boolean)itr.hasNext(), (String)"token not exist error");
            Token token = (Token)itr.next();
            Assertions.assertNotNull((Object)token, (String)"Token should be there without renewer");
            String expectedNonVerbose = "Token (HDFS_DELEGATION_TOKEN token 1 for " + System.getProperty("user.name") + " with renewer ) for";
            String resNonVerbose = DelegationTokenFetcher.printTokensToString((Configuration)this.conf, (Path)p, (boolean)false);
            Assertions.assertTrue((boolean)resNonVerbose.startsWith(expectedNonVerbose), (String)("The non verbose output is expected to start with \"" + expectedNonVerbose + "\""));
            LOG.info(resNonVerbose);
            LOG.info(DelegationTokenFetcher.printTokensToString((Configuration)this.conf, (Path)p, (boolean)true));
            try {
                DelegationTokenFetcher.renewTokens((Configuration)this.conf, (Path)p);
                Assertions.fail((String)"Should have failed to renew");
            }
            catch (AccessControlException e) {
                GenericTestUtils.assertExceptionContains((String)("tried to renew a token (" + token.decodeIdentifier() + ") without a renewer"), (Throwable)e);
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

