/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.TestDFSHAAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestDFSHAAdminMiniCluster {
    private static final Logger LOG;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private DFSHAAdmin tool;
    private final ByteArrayOutputStream errOutBytes = new ByteArrayOutputStream();
    private String errOutput;
    private int nn1Port;

    @BeforeEach
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.ha.nn.not-become-active-in-safemode", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        this.tool = new DFSHAAdmin();
        this.tool.setConf(this.conf);
        this.tool.setErrOut(new PrintStream(this.errOutBytes));
        this.cluster.waitActive();
        this.nn1Port = this.cluster.getNameNodePort(0);
    }

    @AfterEach
    public void shutdown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testGetServiceState() throws Exception {
        Assertions.assertEquals((int)0, (int)this.runTool("-getServiceState", "nn1"));
        Assertions.assertEquals((int)0, (int)this.runTool("-getServiceState", "nn2"));
        this.cluster.transitionToActive(0);
        Assertions.assertEquals((int)0, (int)this.runTool("-getServiceState", "nn1"));
        NameNodeAdapter.enterSafeMode(this.cluster.getNameNode(0), false);
        Assertions.assertEquals((int)0, (int)this.runTool("-getServiceState", "nn1"));
    }

    @Test
    public void testStateTransition() throws Exception {
        NameNode nnode1 = this.cluster.getNameNode(0);
        Assertions.assertTrue((boolean)nnode1.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToActive", "nn1"));
        Assertions.assertFalse((boolean)nnode1.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToStandby", "nn1"));
        Assertions.assertTrue((boolean)nnode1.isStandbyState());
        NameNode nnode2 = this.cluster.getNameNode(1);
        Assertions.assertTrue((boolean)nnode2.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToActive", "nn2"));
        Assertions.assertFalse((boolean)nnode2.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToStandby", "nn2"));
        Assertions.assertTrue((boolean)nnode2.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToObserver", "nn2"));
        Assertions.assertFalse((boolean)nnode2.isStandbyState());
        Assertions.assertTrue((boolean)nnode2.isObserverState());
    }

    @Test
    public void testObserverTransition() throws Exception {
        NameNode nnode1 = this.cluster.getNameNode(0);
        Assertions.assertTrue((boolean)nnode1.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToObserver", "nn1"));
        Assertions.assertFalse((boolean)nnode1.isStandbyState());
        Assertions.assertTrue((boolean)nnode1.isObserverState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToObserver", "nn1"));
        Assertions.assertTrue((boolean)nnode1.isObserverState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToStandby", "nn1"));
        Assertions.assertTrue((boolean)nnode1.isStandbyState());
        Assertions.assertFalse((boolean)nnode1.isObserverState());
    }

    @Test
    public void testObserverIllegalTransition() throws Exception {
        NameNode nnode1 = this.cluster.getNameNode(0);
        Assertions.assertTrue((boolean)nnode1.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToActive", "nn1"));
        Assertions.assertFalse((boolean)nnode1.isStandbyState());
        Assertions.assertTrue((boolean)nnode1.isActiveState());
        Assertions.assertEquals((int)-1, (int)this.runTool("-transitionToObserver", "nn1"));
        Assertions.assertTrue((boolean)nnode1.isActiveState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToStandby", "nn1"));
        Assertions.assertTrue((boolean)nnode1.isStandbyState());
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToObserver", "nn1"));
        Assertions.assertTrue((boolean)nnode1.isObserverState());
        Assertions.assertEquals((int)-1, (int)this.runTool("-transitionToActive", "nn1"));
        Assertions.assertFalse((boolean)nnode1.isActiveState());
    }

    @Test
    public void testObserverTransitionInSafeMode() throws Exception {
        NameNodeAdapter.enterSafeMode(this.cluster.getNameNode(0), false);
        DFSHAAdmin admin = new DFSHAAdmin();
        admin.setConf(this.conf);
        System.setIn(new ByteArrayInputStream("yes\n".getBytes()));
        int result = admin.run(new String[]{"-transitionToObserver", "-forcemanual", "nn1"});
        Assertions.assertEquals((int)-1, (int)result, (String)("State transition returned: " + result));
        NameNodeAdapter.leaveSafeMode(this.cluster.getNameNode(0));
        System.setIn(new ByteArrayInputStream("yes\n".getBytes()));
        int result1 = admin.run(new String[]{"-transitionToObserver", "-forcemanual", "nn1"});
        Assertions.assertEquals((int)0, (int)result1, (String)("State transition returned: " + result1));
        Assertions.assertFalse((boolean)this.cluster.getNameNode(0).isInSafeMode());
    }

    @Test
    public void testTryFailoverToSafeMode() throws Exception {
        this.conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf(this.conf);
        NameNodeAdapter.enterSafeMode(this.cluster.getNameNode(0), false);
        Assertions.assertEquals((int)-1, (int)this.runTool("-failover", "nn2", "nn1"));
        Assertions.assertTrue((boolean)this.errOutput.contains("is not ready to become active: The NameNode is in safemode"), (String)("Bad output: " + this.errOutput));
    }

    @Test
    public void testFencer() throws Exception {
        Assertions.assertEquals((int)-1, (int)this.runTool("-failover", "nn1", "nn2"));
        File tmpFile = File.createTempFile("testFencer", ".txt");
        tmpFile.deleteOnExit();
        if (Shell.WINDOWS) {
            this.conf.set("dfs.ha.fencing.methods", "shell(echo %source_nameserviceid%.%source_namenodeid% %source_port% %dfs_ha_namenode_id% > " + tmpFile.getAbsolutePath() + ")");
        } else {
            this.conf.set("dfs.ha.fencing.methods", "shell(echo -n $source_nameserviceid.$source_namenodeid $source_port $dfs_ha_namenode_id > " + tmpFile.getAbsolutePath() + ")");
        }
        this.tool.setConf(this.conf);
        Assertions.assertEquals((int)0, (int)this.runTool("-transitionToActive", "nn1"));
        Assertions.assertEquals((int)0, (int)this.runTool("-failover", "nn1", "nn2"));
        Assertions.assertEquals((int)0, (int)this.runTool("-ns", "minidfs-ns", "-failover", "nn2", "nn1"));
        Assertions.assertEquals((Object)"", (Object)Files.asCharSource((File)tmpFile, (Charset)StandardCharsets.UTF_8).read());
        Assertions.assertEquals((int)0, (int)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        String fenceCommandOutput = Files.asCharSource((File)tmpFile, (Charset)StandardCharsets.UTF_8).read().replaceAll(" *[\r\n]+", "");
        Assertions.assertEquals((Object)("minidfs-ns.nn1 " + this.nn1Port + " nn1"), (Object)fenceCommandOutput);
        tmpFile.delete();
        Assertions.assertEquals((int)0, (int)this.runTool("-failover", "nn2", "nn1", "--forceactive"));
        Assertions.assertFalse((boolean)tmpFile.exists());
        this.conf.unset("dfs.ha.fencing.methods");
        this.tool.setConf(this.conf);
        Assertions.assertEquals((int)-1, (int)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        Assertions.assertFalse((boolean)tmpFile.exists());
        this.conf.set("dfs.ha.fencing.methods", "foobar!");
        this.tool.setConf(this.conf);
        Assertions.assertEquals((int)-1, (int)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        Assertions.assertFalse((boolean)tmpFile.exists());
        this.conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf(this.conf);
        Assertions.assertEquals((int)0, (int)this.runTool("-failover", "--forcefence", "nn1", "nn2"));
    }

    @Test
    public void testCheckHealth() throws Exception {
        Assertions.assertEquals((int)0, (int)this.runTool("-checkHealth", "nn1"));
        Assertions.assertEquals((int)0, (int)this.runTool("-checkHealth", "nn2"));
    }

    @Test
    public void testTransitionToActiveWhenOtherNamenodeisActive() throws Exception {
        NameNode nn1 = this.cluster.getNameNode(0);
        NameNode nn2 = this.cluster.getNameNode(1);
        if (nn1.getState() != null && !nn1.getState().equals(HAServiceProtocol.HAServiceState.STANDBY.name())) {
            this.cluster.transitionToStandby(0);
        }
        if (nn2.getState() != null && !nn2.getState().equals(HAServiceProtocol.HAServiceState.STANDBY.name())) {
            this.cluster.transitionToStandby(1);
        }
        Assertions.assertTrue((boolean)nn1.isStandbyState());
        Assertions.assertTrue((boolean)nn2.isStandbyState());
        this.runTool("-transitionToActive", "nn1");
        this.runTool("-transitionToActive", "nn2");
        Assertions.assertFalse((nn1.isActiveState() && nn2.isActiveState() ? 1 : 0) != 0, (String)"Both namenodes cannot be active");
        this.cluster.shutdownNameNode(0);
        if (nn2.getState() != null && !nn2.getState().equals(HAServiceProtocol.HAServiceState.STANDBY.name())) {
            this.cluster.transitionToStandby(1);
        }
        Assertions.assertTrue((boolean)nn2.isStandbyState());
        Assertions.assertFalse((boolean)this.cluster.isNameNodeUp(0));
        this.runTool("-transitionToActive", "nn2", "--forceactive");
        Assertions.assertTrue((boolean)nn2.isActiveState(), (String)"Namenode nn2 should be active");
    }

    private int runTool(String ... args) throws Exception {
        this.errOutBytes.reset();
        LOG.info("Running: DFSHAAdmin " + Joiner.on((String)" ").join((Object[])args));
        int ret = this.tool.run(args);
        this.errOutput = new String(this.errOutBytes.toByteArray(), StandardCharsets.UTF_8);
        LOG.info("Output:\n" + this.errOutput);
        return ret;
    }

    static {
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(HAAdmin.class), (Level)Level.TRACE);
        LOG = LoggerFactory.getLogger(TestDFSHAAdminMiniCluster.class);
    }
}

