/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.TextStringBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.TestRefreshUserMappings;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestDFSAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSAdmin.class);
    private Configuration conf = null;
    private MiniDFSCluster cluster;
    private DFSAdmin admin;
    private DataNode datanode;
    private NameNode namenode;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;
    private String tempResource = null;
    private static final int NUM_DATANODES = 2;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("ipc.client.connect.max.retries", 3);
        this.conf.setInt("dfs.blocksize", 512);
        this.conf.set("hdfs.minidfs.basedir", GenericTestUtils.getRandomizedTempPath());
        this.conf.setInt("fs.trash.interval", 60);
        this.conf.setBoolean("dfs.namenode.snapshot.trashroot.enabled", true);
        this.restartCluster();
        this.admin = new DFSAdmin(this.conf);
    }

    private void redirectStream() {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private void resetStream() {
        this.out.reset();
        this.err.reset();
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        this.resetStream();
        if (this.tempResource != null) {
            File f = new File(this.tempResource);
            FileUtils.deleteQuietly((File)f);
            this.tempResource = null;
        }
    }

    private void restartCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
        this.datanode = this.cluster.getDataNodes().get(0);
        this.namenode = this.cluster.getNameNode();
    }

    private void getReconfigurableProperties(String nodeType, String address, List<String> outs, List<String> errs) throws IOException, InterruptedException {
        this.reconfigurationOutErrFormatter("getReconfigurableProperties", nodeType, address, outs, errs);
    }

    private void getReconfigurationStatus(String nodeType, String address, List<String> outs, List<String> errs) throws IOException, InterruptedException {
        this.reconfigurationOutErrFormatter("getReconfigurationStatus", nodeType, address, outs, errs);
    }

    private void reconfigurationOutErrFormatter(String methodName, String nodeType, String address, List<String> outs, List<String> errs) throws IOException, InterruptedException {
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream outStream = new PrintStream(bufOut);
        ByteArrayOutputStream bufErr = new ByteArrayOutputStream();
        PrintStream errStream = new PrintStream(bufErr);
        if (methodName.equals("getReconfigurableProperties")) {
            this.admin.getReconfigurableProperties(nodeType, address, outStream, errStream);
        } else if (methodName.equals("getReconfigurationStatus")) {
            this.admin.getReconfigurationStatusUtil(nodeType, address, outStream, errStream);
        } else if (methodName.equals("startReconfiguration")) {
            this.admin.startReconfigurationUtil(nodeType, address, outStream, errStream);
        }
        TestDFSAdmin.scanIntoList(bufOut, outs);
        TestDFSAdmin.scanIntoList(bufErr, errs);
    }

    private static void scanIntoList(ByteArrayOutputStream baos, List<String> list) {
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            list.add(scanner.nextLine());
        }
        scanner.close();
    }

    @Test
    @Timeout(value=30L)
    public void testGetDatanodeInfo() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
            this.resetStream();
            DataNode dn = this.cluster.getDataNodes().get(i);
            String addr = String.format("%s:%d", dn.getXferAddress().getHostString(), dn.getIpcPort());
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-getDatanodeInfo", addr});
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ret);
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)outs.size(), (String)"One line per DataNode like: Uptime: XXX, Software version: x.y.z, Config version: core-x.y.z,hdfs-x");
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(0))).contains(new CharSequence[]{"Uptime:"})).contains(new CharSequence[]{"Software version"})).contains(new CharSequence[]{"Config version"});
        }
    }

    @Test
    @Timeout(value=30L)
    public void testTriggerBlockReport() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        DataNode dn = this.cluster.getDataNodes().get(0);
        NameNode nn = this.cluster.getNameNode();
        String dnAddr = String.format("%s:%d", dn.getXferAddress().getHostString(), dn.getIpcPort());
        String nnAddr = nn.getHostAndPort();
        this.resetStream();
        ArrayList outs = Lists.newArrayList();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-triggerBlockReport", dnAddr, "-incremental", "-namenode", nnAddr});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ret);
        TestDFSAdmin.scanIntoList(this.out, outs);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)outs.size());
        ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(0))).contains(new CharSequence[]{"Triggering an incremental block report on "})).contains(new CharSequence[]{" to namenode "});
    }

    @Test
    @Timeout(value=30L)
    public void testGetVolumeReport() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
            this.resetStream();
            DataNode dn = this.cluster.getDataNodes().get(i);
            String addr = String.format("%s:%d", dn.getXferAddress().getHostString(), dn.getIpcPort());
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-getVolumeReport", addr});
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ret);
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            org.junit.jupiter.api.Assertions.assertEquals(outs.get(0), (Object)"Active Volumes : 2");
        }
    }

    @Test
    @Timeout(value=60L)
    public void testDFSAdminUnreachableDatanode() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        for (String command : new String[]{"-getDatanodeInfo", "-evictWriters", "-getBalancerBandwidth"}) {
            String dnDataAddr = this.datanode.getXferAddress().getHostString() + ":" + this.datanode.getXferPort();
            this.resetStream();
            ArrayList outs = Lists.newArrayList();
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{command, dnDataAddr});
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)ret);
            TestDFSAdmin.scanIntoList(this.out, outs);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)outs.isEmpty(), (String)("Unexpected " + command + " stdout: " + this.out));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.err.toString().contains("Exception"), (String)("Unexpected " + command + " stderr: " + this.err));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testDataNodeGetReconfigurableProperties() throws IOException, InterruptedException {
        int port = this.datanode.getIpcPort();
        String address = "localhost:" + port;
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.getReconfigurableProperties("datanode", address, outs, errs);
        org.junit.jupiter.api.Assertions.assertEquals((int)26, (int)outs.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.datanode.data.dir", outs.get(1));
    }

    private void testDataNodeGetReconfigurationStatus(boolean expectedSuccuss) throws IOException, InterruptedException, TimeoutException {
        ReconfigurationUtil ru = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
        this.datanode.setReconfigurationUtil(ru);
        ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
        File newDir = new File(this.cluster.getDataDirectory(), "data_new");
        if (expectedSuccuss) {
            newDir.mkdirs();
        } else {
            newDir.createNewFile();
        }
        changes.add(new ReconfigurationUtil.PropertyChange("dfs.datanode.data.dir", newDir.toString(), this.datanode.getConf().get("dfs.datanode.data.dir")));
        changes.add(new ReconfigurationUtil.PropertyChange("randomKey", "new123", "old456"));
        Mockito.when((Object)ru.parseChangedProperties((Configuration)ArgumentMatchers.any(Configuration.class), (Configuration)ArgumentMatchers.any(Configuration.class))).thenReturn(changes);
        int port = this.datanode.getIpcPort();
        String address = "localhost:" + port;
        Assertions.assertThat((int)this.admin.startReconfiguration("datanode", address)).isEqualTo(0);
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.awaitReconfigurationFinished("datanode", address, outs, errs);
        if (expectedSuccuss) {
            Assertions.assertThat((int)outs.size()).isEqualTo(4);
        } else {
            Assertions.assertThat((int)outs.size()).isEqualTo(6);
        }
        List locations = DataNode.getStorageLocations((Configuration)this.datanode.getConf());
        if (expectedSuccuss) {
            Assertions.assertThat((int)locations.size()).isEqualTo(1);
            Assertions.assertThat((File)new File(((StorageLocation)locations.get(0)).getUri())).isEqualTo((Object)newDir);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)new File(newDir, "current").isDirectory());
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)locations.isEmpty());
        }
        int offset = 1;
        if (expectedSuccuss) {
            Assertions.assertThat((String)((String)outs.get(offset))).contains(new CharSequence[]{"SUCCESS: Changed property dfs.datanode.data.dir"});
        } else {
            Assertions.assertThat((String)((String)outs.get(offset))).contains(new CharSequence[]{"FAILED: Change property dfs.datanode.data.dir"});
        }
        File dnDir0 = this.cluster.getInstanceStorageDir(0, 0);
        File dnDir1 = this.cluster.getInstanceStorageDir(0, 1);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(offset + 1))).contains(new CharSequence[]{"From:"})).contains(new CharSequence[]{dnDir0.getName()})).contains(new CharSequence[]{dnDir1.getName()});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(offset + 2))).doesNotContain(new CharSequence[]{dnDir0.getName()})).doesNotContain(new CharSequence[]{dnDir1.getName()});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(offset + 2))).contains(new CharSequence[]{"To"})).contains(new CharSequence[]{"data_new"});
    }

    @Test
    @Timeout(value=30L)
    public void testDataNodeGetReconfigurationStatus() throws IOException, InterruptedException, TimeoutException {
        this.testDataNodeGetReconfigurationStatus(true);
        this.restartCluster();
        this.testDataNodeGetReconfigurationStatus(false);
    }

    @Test
    @Timeout(value=30L)
    public void testNameNodeGetReconfigurableProperties() throws IOException, InterruptedException {
        String address = this.namenode.getHostAndPort();
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.getReconfigurableProperties("namenode", address, outs, errs);
        org.junit.jupiter.api.Assertions.assertEquals((int)29, (int)outs.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((String)outs.get(0)).contains("Reconfigurable properties:"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.block.invalidate.limit", outs.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.block.placement.ec.classname", outs.get(2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.block.replicator.classname", outs.get(3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.datanode.max.nodes.to.report", outs.get(4));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.datanode.peer.stats.enabled", outs.get(5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.heartbeat.interval", outs.get(6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.image.parallel.load", outs.get(7));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.avoid.read.slow.datanode", outs.get(8));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.block-placement-policy.exclude-slow-nodes.enabled", outs.get(9));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.block-placement.min-blocks-for.write", outs.get(10));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", outs.get(11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.decommission.backoff.monitor.pending.limit", outs.get(12));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.heartbeat.recheck-interval", outs.get(13));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dfs.namenode.lock.detailed-metrics.enabled", outs.get(14));
        org.junit.jupiter.api.Assertions.assertEquals((int)errs.size(), (int)0);
    }

    void awaitReconfigurationFinished(final String nodeType, final String address, final List<String> outs, final List<String> errs) throws TimeoutException, IOException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                outs.clear();
                errs.clear();
                try {
                    TestDFSAdmin.this.getReconfigurationStatus(nodeType, address, outs, errs);
                }
                catch (IOException | InterruptedException e) {
                    LOG.error(String.format("call getReconfigurationStatus on %s[%s] failed.", nodeType, address), (Throwable)e);
                }
                return !outs.isEmpty() && ((String)outs.get(0)).contains("finished");
            }
        }, (long)100L, (long)10000L);
    }

    @Test
    @Timeout(value=30L)
    public void testPrintTopology() throws Exception {
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        File baseDir = new File(PathUtils.getTestDir(this.getClass()), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        int numDn = 4;
        String[] racks = new String[]{"/d1/r1", "/d1/r2", "/d2/r1", "/d2/r2"};
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(4).racks(racks).build();){
            miniCluster.waitActive();
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)miniCluster.getDataNodes().size());
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            this.resetStream();
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-printTopology"});
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ret);
            org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)outs.size(), (String)"There should be three lines per Datanode: the 1st line is rack info, 2nd node info, 3rd empty line. The total should be as a result of 3 * numDn.");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(0))).contains(new CharSequence[]{"Rack:"})).contains(new CharSequence[]{"/d1/r1"});
            ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(3))).contains(new CharSequence[]{"Rack:"})).contains(new CharSequence[]{"/d1/r2"});
            ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(6))).contains(new CharSequence[]{"Rack:"})).contains(new CharSequence[]{"/d2/r1"});
            ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(9))).contains(new CharSequence[]{"Rack:"})).contains(new CharSequence[]{"/d2/r2"});
        }
    }

    @Test
    @Timeout(value=30L)
    public void testPrintTopologyWithStatus() throws Exception {
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        File baseDir = new File(PathUtils.getTestDir(this.getClass()), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        int numDn = 4;
        String[] racks = new String[]{"/d1/r1", "/d1/r2", "/d2/r1", "/d2/r2"};
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(4).racks(racks).build();){
            miniCluster.waitActive();
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)miniCluster.getDataNodes().size());
            DatanodeManager dm = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager();
            DatanodeDescriptor maintenanceNode = dm.getDatanode(miniCluster.getDataNodes().get(1).getDatanodeId());
            maintenanceNode.setInMaintenance();
            DatanodeDescriptor demissionNode = dm.getDatanode(miniCluster.getDataNodes().get(2).getDatanodeId());
            demissionNode.setDecommissioned();
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            this.resetStream();
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-printTopology"});
            ArrayList outs = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outs);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ret);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((String)outs.get(1)).contains(DatanodeInfo.AdminStates.NORMAL.toString()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((String)outs.get(4)).contains(DatanodeInfo.AdminStates.IN_MAINTENANCE.toString()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((String)outs.get(7)).contains(DatanodeInfo.AdminStates.DECOMMISSIONED.toString()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((String)outs.get(10)).contains(DatanodeInfo.AdminStates.NORMAL.toString()));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testNameNodeGetReconfigurationStatus() throws IOException, InterruptedException, TimeoutException {
        ReconfigurationUtil ru = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
        this.namenode.setReconfigurationUtil(ru);
        String address = this.namenode.getHostAndPort();
        ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
        changes.add(new ReconfigurationUtil.PropertyChange("dfs.heartbeat.interval", String.valueOf(6), this.namenode.getConf().get("dfs.heartbeat.interval")));
        changes.add(new ReconfigurationUtil.PropertyChange("randomKey", "new123", "old456"));
        Mockito.when((Object)ru.parseChangedProperties((Configuration)ArgumentMatchers.any(Configuration.class), (Configuration)ArgumentMatchers.any(Configuration.class))).thenReturn(changes);
        Assertions.assertThat((int)this.admin.startReconfiguration("namenode", address)).isEqualTo(0);
        ArrayList outs = Lists.newArrayList();
        ArrayList errs = Lists.newArrayList();
        this.awaitReconfigurationFinished("namenode", address, outs, errs);
        org.junit.jupiter.api.Assertions.assertEquals((long)6L, (long)this.namenode.getConf().getLong("dfs.heartbeat.interval", 3L), (String)"dfs.heartbeat.interval has wrong value");
        org.junit.jupiter.api.Assertions.assertEquals((long)6L, (long)this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatInterval(), (String)"dfs.heartbeat.interval has wrong value");
        int offset = 1;
        Assertions.assertThat((String)((String)outs.get(offset))).contains(new CharSequence[]{"SUCCESS: Changed property dfs.heartbeat.interval"});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(offset + 1))).contains(new CharSequence[]{"From:"})).contains(new CharSequence[]{"3"});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)outs.get(offset + 2))).contains(new CharSequence[]{"To:"})).contains(new CharSequence[]{"6"});
    }

    private static String scanIntoString(ByteArrayOutputStream baos) {
        TextStringBuilder sb = new TextStringBuilder();
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            sb.appendln(scanner.nextLine());
        }
        scanner.close();
        return sb.toString();
    }

    private void waitForCorruptBlock(final MiniDFSCluster miniCluster, final DFSClient client, final Path file) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LocatedBlocks blocks = null;
                try {
                    miniCluster.triggerBlockReports();
                    blocks = client.getNamenode().getBlockLocations(file.toString(), 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    return false;
                }
                return blocks != null && blocks.get(0).isCorrupt();
            }
        }, (long)1000L, (long)60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=180L)
    public void testReportCommand() throws Exception {
        this.tearDown();
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)4);
        dfsConf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        dfsConf.setLong("dfs.heartbeat.interval", 1L);
        Path baseDir = new Path(PathUtils.getTestDir(this.getClass()).getAbsolutePath(), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.toString());
        int numDn = ecPolicy.getNumDataUnits() + ecPolicy.getNumParityUnits();
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(numDn).build();){
            miniCluster.waitActive();
            org.junit.jupiter.api.Assertions.assertEquals((int)numDn, (int)miniCluster.getDataNodes().size());
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            DFSClient client = miniCluster.getFileSystem().getClient();
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn, 0, 0, client, 0L, 0L);
            boolean replFactor = true;
            long fileLength = 512L;
            DistributedFileSystem fs = miniCluster.getFileSystem();
            Path file = new Path(baseDir, "/corrupted");
            fs.enableErasureCodingPolicy(ecPolicy.getName());
            DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)1);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file);
            LocatedBlocks lbs = miniCluster.getFileSystem().getClient().getNamenode().getBlockLocations(file.toString(), 0L, 512L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(lbs.get(0) instanceof LocatedBlock), (String)("Unexpected block type: " + lbs.get(0)));
            LocatedBlock locatedBlock = lbs.get(0);
            DatanodeInfoWithStorage locatedDataNode = locatedBlock.getLocations()[0];
            LOG.info("Replica block located on: " + locatedDataNode);
            Path ecDir = new Path(baseDir, "ec");
            fs.mkdirs(ecDir);
            fs.getClient().setErasureCodingPolicy(ecDir.toString(), ecPolicy.getName());
            Path ecFile = new Path(ecDir, "ec-file");
            int stripesPerBlock = 2;
            int cellSize = ecPolicy.getCellSize();
            int blockSize = stripesPerBlock * cellSize;
            int blockGroupSize = ecPolicy.getNumDataUnits() * blockSize;
            int totalBlockGroups = 1;
            DFSTestUtil.createStripedFile(miniCluster, ecFile, ecDir, totalBlockGroups, stripesPerBlock, false, ecPolicy);
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn, 0, 0, client, 0L, 0L);
            ArrayList<DataNode> datanodes = miniCluster.getDataNodes();
            DataNode dataNodeToShutdown = null;
            for (DataNode dn : datanodes) {
                if (dn.getDatanodeId().getDatanodeUuid().equals(locatedDataNode.getDatanodeUuid())) continue;
                dataNodeToShutdown = dn;
                break;
            }
            org.junit.jupiter.api.Assertions.assertTrue((dataNodeToShutdown != null ? 1 : 0) != 0, (String)"Unable to choose a DataNode to shutdown!");
            LOG.info("Shutting down: " + dataNodeToShutdown);
            dataNodeToShutdown.shutdown();
            miniCluster.setDataNodeDead(dataNodeToShutdown.getDatanodeId());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn - 1, 0, 0, client, 0L, 1L);
            int blockFilesCorrupted = miniCluster.corruptBlockOnDataNodes(block);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockFilesCorrupted, (String)("Fail to corrupt all replicas for block " + block));
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
                org.junit.jupiter.api.Assertions.fail((String)"Should have failed to read the file with corrupted blocks.");
            }
            catch (ChecksumException dn) {
                // empty catch block
            }
            fs.setReplication(file, (short)2);
            BlockManagerTestUtil.updateState(miniCluster.getNameNode().getNamesystem().getBlockManager());
            this.waitForCorruptBlock(miniCluster, client, file);
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn - 1, 1, 0, client, 0L, 1L);
            lbs = miniCluster.getFileSystem().getClient().getNamenode().getBlockLocations(ecFile.toString(), 0L, (long)blockGroupSize);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(lbs.get(0) instanceof LocatedStripedBlock), (String)("Unexpected block type: " + lbs.get(0)));
            LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
            miniCluster.getNamesystem().writeLock(RwLockMode.BM);
            try {
                BlockManager bm = miniCluster.getNamesystem().getBlockManager();
                bm.findAndMarkBlockAsCorrupt(bg.getBlock(), (DatanodeInfo)bg.getLocations()[0], "STORAGE_ID", "TEST");
                BlockManagerTestUtil.updateState(bm);
            }
            finally {
                miniCluster.getNamesystem().writeUnlock(RwLockMode.BM, "testReportCommand");
            }
            this.waitForCorruptBlock(miniCluster, client, file);
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-report"}));
            this.verifyNodesAndCorruptBlocks(numDn, numDn - 1, 1, 1, client, 0L, 0L);
            this.resetStream();
            String[] reportWithArg = new String[DFSAdmin.DFS_REPORT_ARGS.length + 1];
            reportWithArg[0] = "-report";
            System.arraycopy(DFSAdmin.DFS_REPORT_ARGS, 0, reportWithArg, 1, DFSAdmin.DFS_REPORT_ARGS.length);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])reportWithArg));
        }
    }

    @Test
    @Timeout(value=300L)
    public void testListOpenFiles() throws Exception {
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        dfsConf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        dfsConf.setLong("dfs.heartbeat.interval", 1L);
        dfsConf.setLong("dfs.namenode.list.openfiles.num.responses", 5L);
        Path baseDir = new Path(PathUtils.getTestDir(this.getClass()).getAbsolutePath(), GenericTestUtils.getMethodName());
        dfsConf.set("hdfs.minidfs.basedir", baseDir.toString());
        int numDataNodes = 3;
        int numClosedFiles = 25;
        int numOpenFiles = 15;
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(3).build();){
            boolean replFactor = true;
            long fileLength = 512L;
            DistributedFileSystem fs = miniCluster.getFileSystem();
            Path parentDir = new Path("/tmp/files/");
            fs.mkdirs(parentDir);
            HashSet<Path> closedFileSet = new HashSet<Path>();
            for (int i = 0; i < 25; ++i) {
                Path file = new Path(parentDir, "closed-file-" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
                closedFileSet.add(file);
            }
            HashMap<Path, FSDataOutputStream> openFilesMap = new HashMap<Path, FSDataOutputStream>();
            for (int i = 0; i < 15; ++i) {
                Path file = new Path(parentDir, "open-file-" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
                FSDataOutputStream outputStream = fs.append(file);
                openFilesMap.put(file, outputStream);
            }
            DFSAdmin dfsAdmin = new DFSAdmin((Configuration)dfsConf);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
            this.verifyOpenFilesListing(closedFileSet, openFilesMap);
            for (int count = 0; count < 15; ++count) {
                closedFileSet.addAll(DFSTestUtil.closeOpenFiles(openFilesMap, 1));
                this.resetStream();
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
                this.verifyOpenFilesListing(closedFileSet, openFilesMap);
            }
            openFilesMap.clear();
            HashMap<Path, FSDataOutputStream> openFiles1 = new HashMap<Path, FSDataOutputStream>();
            HashMap<Path, FSDataOutputStream> openFiles2 = new HashMap<Path, FSDataOutputStream>();
            for (int i = 0; i < 15; ++i) {
                Path file = i % 2 == 0 ? new Path(new Path("/tmp/files/a"), "open-file-" + i) : new Path(new Path("/tmp/files/b"), "open-file-" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 512L, (short)1, 12345L);
                FSDataOutputStream outputStream = fs.append(file);
                if (i % 2 == 0) {
                    openFiles1.put(file, outputStream);
                } else {
                    openFiles2.put(file, outputStream);
                }
                openFilesMap.put(file, outputStream);
            }
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
            this.verifyOpenFilesListing(null, openFilesMap);
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path", "/tmp/files/a"}));
            this.verifyOpenFilesListing(null, openFiles1);
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path"}));
            String outStr = TestDFSAdmin.scanIntoString(this.err);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)outStr.contains("listOpenFiles: option -path requires 1 argument"));
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path", ""}));
            this.verifyOpenFilesListing(null, openFilesMap);
            this.resetStream();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-path", "/invalid_path"}));
            outStr = TestDFSAdmin.scanIntoString(this.out);
            for (Path openFilePath : openFilesMap.keySet()) {
                Assertions.assertThat((String)outStr).doesNotContain(new CharSequence[]{openFilePath.toString()});
            }
            DFSTestUtil.closeOpenFiles(openFilesMap, openFilesMap.size());
        }
    }

    private void verifyOpenFilesListing(HashSet<Path> closedFileSet, HashMap<Path, FSDataOutputStream> openFilesMap) {
        String outStr = TestDFSAdmin.scanIntoString(this.out);
        LOG.info("dfsadmin -listOpenFiles output: \n" + this.out);
        if (closedFileSet != null) {
            for (Path closedFilePath : closedFileSet) {
                Assertions.assertThat((String)outStr).doesNotContain(new CharSequence[]{closedFilePath.toString() + System.lineSeparator()});
            }
        }
        for (Path openFilePath : openFilesMap.keySet()) {
            Assertions.assertThat((String)outStr).contains(new CharSequence[]{openFilePath.toString() + System.lineSeparator()});
        }
    }

    private void verifyNodesAndCorruptBlocks(int numDn, int numLiveDn, int numCorruptBlocks, int numCorruptECBlockGroups, DFSClient client, Long highestPriorityLowRedundancyReplicatedBlocks, Long highestPriorityLowRedundancyECBlocks) throws IOException {
        String outStr = TestDFSAdmin.scanIntoString(this.out);
        String expectedLiveNodesStr = String.format("Live datanodes (%d)", numLiveDn);
        String expectedCorruptedBlocksStr = String.format("Blocks with corrupt replicas: %d", numCorruptBlocks);
        String expectedCorruptedECBlockGroupsStr = String.format("Block groups with corrupt internal blocks: %d", numCorruptECBlockGroups);
        String highestPriorityLowRedundancyReplicatedBlocksStr = String.format("\tLow redundancy blocks with highest priority to recover: %d", highestPriorityLowRedundancyReplicatedBlocks);
        String highestPriorityLowRedundancyECBlocksStr = String.format("\tLow redundancy blocks with highest priority to recover: %d", highestPriorityLowRedundancyReplicatedBlocks);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)outStr).contains(new CharSequence[]{expectedLiveNodesStr})).contains(new CharSequence[]{expectedCorruptedBlocksStr})).contains(new CharSequence[]{expectedCorruptedECBlockGroupsStr})).contains(new CharSequence[]{highestPriorityLowRedundancyReplicatedBlocksStr})).contains(new CharSequence[]{highestPriorityLowRedundancyECBlocksStr});
        org.junit.jupiter.api.Assertions.assertEquals((int)numDn, (int)client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL).length);
        org.junit.jupiter.api.Assertions.assertEquals((int)numLiveDn, (int)client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.LIVE).length);
        org.junit.jupiter.api.Assertions.assertEquals((int)(numDn - numLiveDn), (int)client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.DEAD).length);
        org.junit.jupiter.api.Assertions.assertEquals((long)(numCorruptBlocks + numCorruptECBlockGroups), (long)client.getCorruptBlocksCount());
        org.junit.jupiter.api.Assertions.assertEquals((long)numCorruptBlocks, (long)client.getNamenode().getReplicatedBlockStats().getCorruptBlocks());
        org.junit.jupiter.api.Assertions.assertEquals((Long)highestPriorityLowRedundancyReplicatedBlocks, (Long)client.getNamenode().getReplicatedBlockStats().getHighestPriorityLowRedundancyBlocks());
        org.junit.jupiter.api.Assertions.assertEquals((long)numCorruptECBlockGroups, (long)client.getNamenode().getECBlockGroupStats().getCorruptBlockGroups());
        org.junit.jupiter.api.Assertions.assertEquals((Long)highestPriorityLowRedundancyECBlocks, (Long)client.getNamenode().getECBlockGroupStats().getHighestPriorityLowRedundancyBlocks());
    }

    @Test
    public void testAllowSnapshotWhenTrashExists() throws Exception {
        Path dirPath = new Path("/ssdir3");
        Path trashRoot = new Path(dirPath, ".Trash");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        dfs.mkdirs(trashRoot);
        dfs.setPermission(trashRoot, HdfsAdmin.TRASH_PERMISSION);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-allowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-disallowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dfs.exists(trashRoot));
        dfs.mkdirs(trashRoot);
        dfs.setPermission(trashRoot, new FsPermission(493));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-allowSnapshot", dirPath.toString()}));
        dfs.setPermission(trashRoot, HdfsAdmin.TRASH_PERMISSION);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-allowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-disallowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dfs.exists(trashRoot));
        dfs.create(trashRoot).close();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-allowSnapshot", dirPath.toString()}));
        dfs.delete(trashRoot, false);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-allowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-disallowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dfs.exists(trashRoot));
        dfs.delete(dirPath, true);
    }

    @Test
    public void testAllowDisallowSnapshot() throws Exception {
        Path dirPath = new Path("/ssdir1");
        Path trashRoot = new Path(dirPath, ".Trash");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        dfs.mkdirs(dirPath);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-allowSnapshot", dirPath.toString()}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dfs.exists(trashRoot));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HdfsAdmin.TRASH_PERMISSION, (Object)dfs.getFileStatus(trashRoot).getPermission());
        Path file1 = new Path(dirPath, "file1");
        try (FSDataOutputStream s = dfs.create(file1);){
            s.write(0);
        }
        FsShell fsShell = new FsShell(dfs.getConf());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)fsShell, (String[])new String[]{"-rm", file1.toString()}));
        String username = UserGroupInformation.getLoginUser().getShortUserName();
        Path trashRootUserSubdir = new Path(trashRoot, username);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dfs.exists(trashRootUserSubdir));
        FsPermission trashUserdirPermission = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE, false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)trashUserdirPermission, (Object)dfs.getFileStatus(trashRootUserSubdir).getPermission());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-disallowSnapshot", dirPath.toString()}));
        dfs.delete(trashRootUserSubdir, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-disallowSnapshot", dirPath.toString()}));
        dfs.delete(dirPath, true);
    }

    @Test
    public void testSetBalancerBandwidth() throws Exception {
        this.redirectStream();
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "10000"}));
        String outStr = TestDFSAdmin.scanIntoString(this.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outStr.contains("Balancer bandwidth is set to 10000"), (String)"Did not set bandwidth!");
        this.resetStream();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "10m"}));
        outStr = TestDFSAdmin.scanIntoString(this.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outStr.contains("Balancer bandwidth is set to 10485760"), (String)"Did not set bandwidth!");
        this.resetStream();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "10k"}));
        outStr = TestDFSAdmin.scanIntoString(this.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outStr.contains("Balancer bandwidth is set to 10240"), (String)"Did not set bandwidth!");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "-10000"}));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setBalancerBandwidth", "-10m"}));
    }

    @Test
    @Timeout(value=300L)
    public void testCheckNumOfBlocksInReportCommand() throws Exception {
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Path path = new Path("/tmp.txt");
        DatanodeInfo[] dn = dfs.getDataNodeStats();
        org.junit.jupiter.api.Assertions.assertEquals((int)dn.length, (int)2);
        int actualBlockCount = 0;
        for (DatanodeInfo d : dn) {
            actualBlockCount += d.getNumBlocks();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)actualBlockCount);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 0L);
        int expectedBlockCount = 2;
        Thread.sleep(3000L);
        dn = dfs.getDataNodeStats();
        org.junit.jupiter.api.Assertions.assertEquals((int)dn.length, (int)2);
        actualBlockCount = 0;
        for (DatanodeInfo d : dn) {
            actualBlockCount += d.getNumBlocks();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedBlockCount, (int)actualBlockCount);
    }

    @Test
    public void testRefreshProxyUser() throws Exception {
        final Path dirPath = new Path("/testdir1");
        final Path subDirPath = new Path("/testdir1/subdir1");
        UserGroupInformation loginUserUgi = UserGroupInformation.getLoginUser();
        final String proxyUser = "fakeuser";
        String realUser = loginUserUgi.getShortUserName();
        final UserGroupInformation proxyUgi = UserGroupInformation.createProxyUserForTesting((String)proxyUser, (UserGroupInformation)loginUserUgi, (String[])loginUserUgi.getGroupNames());
        loginUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                TestDFSAdmin.this.cluster.getFileSystem().mkdirs(dirPath);
                TestDFSAdmin.this.cluster.getFileSystem().setOwner(dirPath, proxyUser, proxyUgi.getPrimaryGroupName());
                return 0;
            }
        });
        try {
            proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    TestDFSAdmin.this.cluster.getFileSystem().mkdirs(subDirPath);
                    return 0;
                }
            });
        }
        catch (RemoteException re) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(re.unwrapRemoteException() instanceof AccessControlException));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)re.unwrapRemoteException().getMessage().equals("User: " + realUser + " is not allowed to impersonate " + proxyUser));
        }
        String userKeyGroups = DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(realUser);
        String userKeyHosts = DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(realUser);
        String rsrc = "testGroupMappingRefresh_rsrc.xml";
        this.tempResource = TestRefreshUserMappings.addNewConfigResource(rsrc, userKeyGroups, "*", userKeyHosts, "*");
        String[] args = new String[]{"-refreshSuperUserGroupsConfiguration"};
        this.admin.run(args);
        proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                TestDFSAdmin.this.cluster.getFileSystem().mkdirs(dirPath);
                return 0;
            }
        });
    }

    @Test
    @Order(value=1)
    public void testAllDatanodesReconfig() throws IOException, InterruptedException, TimeoutException {
        ReconfigurationUtil reconfigurationUtil = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
        this.cluster.getDataNodes().get(0).setReconfigurationUtil(reconfigurationUtil);
        this.cluster.getDataNodes().get(1).setReconfigurationUtil(reconfigurationUtil);
        ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
        changes.add(new ReconfigurationUtil.PropertyChange("dfs.datanode.peer.stats.enabled", "true", this.datanode.getConf().get("dfs.datanode.peer.stats.enabled")));
        Mockito.when((Object)reconfigurationUtil.parseChangedProperties((Configuration)ArgumentMatchers.any(Configuration.class), (Configuration)ArgumentMatchers.any(Configuration.class))).thenReturn(changes);
        int result = this.admin.startReconfiguration("datanode", "livenodes");
        Assertions.assertThat((int)result).isEqualTo(0);
        ArrayList<String> outsForStartReconf = new ArrayList<String>();
        ArrayList<String> errsForStartReconf = new ArrayList<String>();
        this.reconfigurationOutErrFormatter("startReconfiguration", "datanode", "livenodes", outsForStartReconf, errsForStartReconf);
        String started = "Started reconfiguration task on node";
        String starting = "Starting of reconfiguration task successful on 2 nodes, failed on 0 nodes.";
        Assertions.assertThat(outsForStartReconf).hasSize(3);
        Assertions.assertThat(errsForStartReconf).hasSize(0);
        Assertions.assertThat((String)((String)outsForStartReconf.get(0))).startsWith((CharSequence)started);
        Assertions.assertThat((String)((String)outsForStartReconf.get(1))).startsWith((CharSequence)started);
        Assertions.assertThat((String)((String)outsForStartReconf.get(2))).startsWith((CharSequence)starting);
        Thread.sleep(1000L);
        ArrayList<String> outs = new ArrayList<String>();
        ArrayList<String> errs = new ArrayList<String>();
        this.awaitReconfigurationFinished("datanode", "livenodes", outs, errs);
        Assertions.assertThat(outs).hasSize(9);
        Assertions.assertThat(errs).hasSize(0);
        LOG.info("dfsadmin -status -livenodes output:");
        outs.forEach(s -> LOG.info("{}", s));
        Assertions.assertThat((String)((String)outs.get(0))).startsWith((CharSequence)"Reconfiguring status for node");
        String success = "SUCCESS: Changed property dfs.datanode.peer.stats.enabled";
        String from = "\tFrom: \"false\"";
        String to = "\tTo: \"true\"";
        String retrieval = "Retrieval of reconfiguration status successful on 2 nodes, failed on 0 nodes.";
        Assertions.assertThat(outs.subList(1, 5)).containsSubsequence((Object[])new String[]{success, from, to});
        Assertions.assertThat(outs.subList(5, 9)).containsSubsequence((Object[])new String[]{success, from, to, retrieval});
    }

    @Test
    public void testDecommissionDataNodesReconfig() throws IOException, InterruptedException, TimeoutException {
        this.redirectStream();
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(3).build();){
            ReconfigurationUtil reconfigurationUtil = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
            miniCluster.getDataNodes().forEach(node -> node.setReconfigurationUtil(reconfigurationUtil));
            ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
            changes.add(new ReconfigurationUtil.PropertyChange("dfs.datanode.data.transfer.bandwidthPerSec", "1000", this.datanode.getConf().get("dfs.datanode.data.transfer.bandwidthPerSec")));
            Mockito.when((Object)reconfigurationUtil.parseChangedProperties((Configuration)ArgumentMatchers.any(Configuration.class), (Configuration)ArgumentMatchers.any(Configuration.class))).thenReturn(changes);
            DFSAdmin dfsAdmin = (DFSAdmin)Mockito.spy((Object)new DFSAdmin((Configuration)dfsConf));
            DistributedFileSystem dfs = (DistributedFileSystem)Mockito.spy((Object)miniCluster.getFileSystem());
            DatanodeInfo decommissioningNode1 = dfs.getDataNodeStats()[0];
            DatanodeInfo decommissioningNode2 = dfs.getDataNodeStats()[1];
            DatanodeInfo[] dataNodeStats = new DatanodeInfo[]{decommissioningNode1, decommissioningNode2};
            Mockito.when((Object)dfsAdmin.getDFS()).thenReturn((Object)dfs);
            Mockito.when((Object)dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.DECOMMISSIONING)).thenReturn((Object)dataNodeStats);
            int ret = dfsAdmin.startReconfiguration("datanode", "decomnodes");
            ArrayList outsForStartReconf = Lists.newArrayList();
            ArrayList errsForStartReconf = Lists.newArrayList();
            TestDFSAdmin.scanIntoList(this.out, outsForStartReconf);
            TestDFSAdmin.scanIntoList(this.err, errsForStartReconf);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ret);
            String started = "Started reconfiguration task on node";
            String starting = "Starting of reconfiguration task successful on 2 nodes, failed on 0 nodes.";
            Assertions.assertThat((List)outsForStartReconf).hasSize(3);
            Assertions.assertThat((List)errsForStartReconf).hasSize(0);
            Assertions.assertThat((String)((String)outsForStartReconf.get(0))).startsWith((CharSequence)started);
            Assertions.assertThat((String)((String)outsForStartReconf.get(1))).startsWith((CharSequence)started);
            Assertions.assertThat((String)((String)outsForStartReconf.get(2))).startsWith((CharSequence)starting);
            Thread.sleep(1000L);
            this.resetStream();
            ArrayList outsForFinishReconf = Lists.newArrayList();
            ArrayList errsForFinishReconf = Lists.newArrayList();
            this.waitForReconfigurationDecommissionNode("datanode", "decomnodes", dfsAdmin, outsForFinishReconf, errsForFinishReconf);
            String success = "SUCCESS: Changed property dfs.datanode.data.transfer.bandwidthPerSec";
            String from = "\tFrom: \"0\"";
            String to = "\tTo: \"1000\"";
            String retrieval = "Retrieval of reconfiguration status successful on 2 nodes, failed on 0 nodes.";
            Assertions.assertThat(outsForFinishReconf.subList(1, 5)).containsSubsequence((Object[])new String[]{success, from, to});
            Assertions.assertThat(outsForFinishReconf.subList(5, 9)).containsSubsequence((Object[])new String[]{success, from, to, retrieval});
            String node1Addr = decommissioningNode1.getIpAddr() + ":" + decommissioningNode1.getIpcPort();
            String node2Addr = decommissioningNode2.getIpAddr() + ":" + decommissioningNode2.getIpcPort();
            int finishedReconfCount = 0;
            for (String outMessage : outsForFinishReconf) {
                finishedReconfCount = outMessage.contains(node1Addr) ? finishedReconfCount + 1 : finishedReconfCount + 0;
                finishedReconfCount = outMessage.contains(node2Addr) ? finishedReconfCount + 1 : finishedReconfCount + 0;
            }
            org.junit.jupiter.api.Assertions.assertTrue((finishedReconfCount == 2 ? 1 : 0) != 0);
        }
    }

    private void waitForReconfigurationDecommissionNode(final String nodeType, final String address, final DFSAdmin dfsAdmin, final List<String> outs, final List<String> errs) throws TimeoutException, InterruptedException {
        final PrintStream outStream = new PrintStream(this.out);
        final PrintStream errStream = new PrintStream(this.err);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                Object blocks = null;
                try {
                    dfsAdmin.getReconfigurationStatusUtil("datanode", "decomnodes", outStream, errStream);
                }
                catch (IOException | InterruptedException e) {
                    LOG.error(String.format("call getReconfigurationStatus on %s[%s] failed.", nodeType, address), (Throwable)e);
                }
                TestDFSAdmin.scanIntoList(TestDFSAdmin.this.out, outs);
                TestDFSAdmin.scanIntoList(TestDFSAdmin.this.err, errs);
                return !outs.isEmpty() && ((String)outs.get(0)).contains("finished");
            }
        }, (long)100L, (long)10000L);
    }
}

