/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.web.resources;

import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestWebHdfsCreatePermissions {
    static final Logger LOG = LoggerFactory.getLogger(TestWebHdfsCreatePermissions.class);
    private MiniDFSCluster cluster;

    public TestWebHdfsCreatePermissions() {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
    }

    @BeforeEach
    public void initializeMiniDFSCluster() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        this.cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPermissions(int expectedResponse, String expectedPermission, String path, String ... params) throws Exception {
        String user = System.getProperty("user.name");
        StringBuilder uri = new StringBuilder(this.cluster.getHttpUri(0));
        uri.append("/webhdfs/v1").append(path).append("?user.name=").append(user).append("&");
        for (String param : params) {
            uri.append(param).append("&");
        }
        LOG.info(uri.toString());
        try {
            URL url = new URL(uri.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)expectedResponse, (int)conn.getResponseCode());
            NamenodeProtocols namenode = this.cluster.getNameNode().getRpcServer();
            FsPermission resultingPermission = namenode.getFileInfo(path).getPermission();
            Assertions.assertEquals((Object)expectedPermission, (Object)resultingPermission.toString());
        }
        finally {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testCreateDirNoPermissions() throws Exception {
        this.testPermissions(200, "rwxr-xr-x", "/path", "op=MKDIRS");
    }

    @Test
    public void testCreateDir777Permissions() throws Exception {
        this.testPermissions(200, "rwxrwxrwx", "/test777", "op=MKDIRS&permission=777");
    }

    @Test
    public void testCreateFileNoPermissions() throws Exception {
        this.testPermissions(201, "rw-r--r--", "/test-file", "op=CREATE");
    }

    @Test
    public void testCreateFile666Permissions() throws Exception {
        this.testPermissions(201, "rw-rw-rw-", "/test-file", "op=CREATE&permission=666");
    }
}

