/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.window;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRollingWindowManager {
    Configuration conf;
    RollingWindowManager manager;
    String[] users;
    static final int MIN_2_MS = 60000;
    final int WINDOW_LEN_MS = 60000;
    final int BUCKET_CNT = 10;
    final int N_TOP_USERS = 10;
    final int BUCKET_LEN = 6000;

    @BeforeEach
    public void init() {
        this.conf = new Configuration();
        this.conf.setInt("dfs.namenode.top.window.num.buckets", 10);
        this.conf.setInt("dfs.namenode.top.num.users", 10);
        this.manager = new RollingWindowManager(this.conf, 60000);
        this.users = new String[20];
        for (int i = 0; i < this.users.length; ++i) {
            this.users[i] = "user" + i;
        }
    }

    @Test
    public void testTops() throws Exception {
        int i;
        long time = 69000L;
        for (i = 0; i < this.users.length; ++i) {
            this.manager.recordMetric(time, "open", this.users[i], (long)((i + 1) * 2));
        }
        ++time;
        for (i = 0; i < this.users.length; ++i) {
            this.manager.recordMetric(time, "close", this.users[i], (long)(i + 1));
        }
        RollingWindowManager.TopWindow tops = this.manager.snapshot(++time);
        Assertions.assertEquals((int)3, (int)tops.getOps().size(), (String)"Unexpected number of ops");
        Assertions.assertEquals((Object)"*", (Object)((RollingWindowManager.Op)tops.getOps().get(0)).getOpType());
        for (RollingWindowManager.Op op : tops.getOps()) {
            List topUsers = op.getTopUsers();
            Assertions.assertEquals((int)10, (int)topUsers.size(), (String)"Unexpected number of users");
            if (!op.getOpType().equals("open")) continue;
            for (int i2 = 0; i2 < topUsers.size(); ++i2) {
                RollingWindowManager.User user = (RollingWindowManager.User)topUsers.get(i2);
                Assertions.assertEquals((long)((this.users.length - i2) * 2), (long)user.getCount(), (String)("Unexpected count for user " + user.getUser()));
            }
            Assertions.assertEquals((long)((2 + this.users.length * 2) * (this.users.length / 2)), (long)op.getTotalCount(), (String)"Unexpected total count for op");
        }
        tops = this.manager.snapshot(time += 59998L);
        Assertions.assertEquals((int)2, (int)tops.getOps().size(), (String)"Unexpected number of ops");
        Assertions.assertEquals((Object)"*", (Object)((RollingWindowManager.Op)tops.getOps().get(0)).getOpType());
        RollingWindowManager.Op op = (RollingWindowManager.Op)tops.getOps().get(1);
        Assertions.assertEquals((Object)"close", (Object)op.getOpType(), (String)"Should only see close ops");
        List topUsers = op.getTopUsers();
        for (int i3 = 0; i3 < topUsers.size(); ++i3) {
            RollingWindowManager.User user = (RollingWindowManager.User)topUsers.get(i3);
            Assertions.assertEquals((long)(this.users.length - i3), (long)user.getCount(), (String)("Unexpected count for user " + user.getUser()));
        }
        Assertions.assertEquals((long)((1 + this.users.length) * (this.users.length / 2)), (long)op.getTotalCount(), (String)"Unexpected total count for op");
    }

    @Test
    public void windowReset() throws Exception {
        Configuration config = new Configuration();
        config.setInt("dfs.namenode.top.window.num.buckets", 1);
        config.setInt("dfs.namenode.top.num.users", 10);
        int period = 2;
        RollingWindowManager rollingWindowManager = new RollingWindowManager(config, period);
        rollingWindowManager.recordMetric(0L, "op1", this.users[0], 3L);
        this.checkValues(rollingWindowManager, 0L, "op1", 3L, 3L);
        this.checkValues(rollingWindowManager, period - 1, "op1", 3L, 3L);
        this.checkValues(rollingWindowManager, period, "op1", 0L, 0L);
    }

    @Test
    public void testTotal() throws Exception {
        Configuration config = new Configuration();
        config.setInt("dfs.namenode.top.window.num.buckets", 1);
        config.setInt("dfs.namenode.top.num.users", 10);
        int period = 10;
        RollingWindowManager rollingWindowManager = new RollingWindowManager(config, period);
        long t = 0L;
        rollingWindowManager.recordMetric(t, "op1", this.users[0], 3L);
        this.checkValues(rollingWindowManager, t, "op1", 3L, 3L);
        t = (long)((double)period * 0.5);
        rollingWindowManager.recordMetric(t, "op2", this.users[0], 4L);
        this.checkValues(rollingWindowManager, t, "op1", 3L, 7L);
        this.checkValues(rollingWindowManager, t, "op2", 4L, 7L);
        t = period - 1;
        this.checkValues(rollingWindowManager, t, "op1", 3L, 7L);
        this.checkValues(rollingWindowManager, t, "op2", 4L, 7L);
        t = period;
        rollingWindowManager.recordMetric(10L, "op1", this.users[0], 10L);
        this.checkValues(rollingWindowManager, t, "op1", 10L, 14L);
        this.checkValues(rollingWindowManager, t, "op2", 4L, 14L);
        t = (long)((double)period * 1.25);
        rollingWindowManager.recordMetric(t, "op2", this.users[0], 7L);
        this.checkValues(rollingWindowManager, t, "op1", 10L, 21L);
        this.checkValues(rollingWindowManager, t, "op2", 11L, 21L);
        t = (long)((double)period * 1.5);
        rollingWindowManager.recordMetric(t, "op2", this.users[0], 13L);
        this.checkValues(rollingWindowManager, t, "op1", 10L, 23L);
        this.checkValues(rollingWindowManager, t, "op2", 13L, 23L);
    }

    @Test
    public void testWithFuzzing() throws Exception {
        Configuration config = new Configuration();
        config.setInt("dfs.namenode.top.window.num.buckets", 1);
        config.setInt("dfs.namenode.top.num.users", 10);
        int period = this.users.length / 2;
        RollingWindowManager rollingWindowManager = new RollingWindowManager(config, period);
        String[] ops = new String[]{"op1", "op2", "op3", "op4"};
        Random rand = new Random();
        for (int i = 0; i < 10000; ++i) {
            rollingWindowManager.recordMetric((long)i, ops[rand.nextInt(ops.length)], this.users[rand.nextInt(this.users.length)], (long)rand.nextInt(100));
            RollingWindowManager.TopWindow window = rollingWindowManager.snapshot((long)i);
            this.checkTotal(window);
        }
    }

    @Test
    public void testOpTotal() throws Exception {
        int numTopUsers = 2;
        Configuration config = new Configuration();
        config.setInt("dfs.namenode.top.window.num.buckets", 1);
        config.setInt("dfs.namenode.top.num.users", numTopUsers);
        int period = this.users.length / 2;
        RollingWindowManager rollingWindowManager = new RollingWindowManager(config, period);
        int numOps = 3;
        rollingWindowManager.recordMetric(0L, "op1", "user1", 10L);
        rollingWindowManager.recordMetric(0L, "op1", "user2", 20L);
        rollingWindowManager.recordMetric(0L, "op1", "user3", 30L);
        rollingWindowManager.recordMetric(0L, "op2", "user1", 1L);
        rollingWindowManager.recordMetric(0L, "op2", "user4", 40L);
        rollingWindowManager.recordMetric(0L, "op2", "user5", 50L);
        rollingWindowManager.recordMetric(0L, "op3", "user6", 1L);
        rollingWindowManager.recordMetric(0L, "op3", "user7", 11L);
        rollingWindowManager.recordMetric(0L, "op3", "user8", 1L);
        RollingWindowManager.TopWindow window = rollingWindowManager.snapshot(0L);
        Assertions.assertEquals((int)(numOps + 1), (int)window.getOps().size());
        RollingWindowManager.Op allOp = (RollingWindowManager.Op)window.getOps().get(0);
        Assertions.assertEquals((Object)"*", (Object)allOp.getOpType());
        List topUsers = allOp.getTopUsers();
        Assertions.assertEquals((int)(numTopUsers * numOps), (int)topUsers.size());
        for (int i = 1; i < numOps; ++i) {
            Assertions.assertTrue((boolean)topUsers.containsAll(((RollingWindowManager.Op)window.getOps().get(i)).getTopUsers()));
        }
    }

    private void checkValues(RollingWindowManager rwManager, long time, String opType, long value, long expectedTotal) throws Exception {
        RollingWindowManager.TopWindow window = rwManager.snapshot(time);
        for (RollingWindowManager.Op windowOp : window.getOps()) {
            if (!opType.equals(windowOp.getOpType())) continue;
            Assertions.assertEquals((long)value, (long)windowOp.getTotalCount());
            break;
        }
        Assertions.assertEquals((long)expectedTotal, (long)this.checkTotal(window));
    }

    private long checkTotal(RollingWindowManager.TopWindow window) throws Exception {
        long allOpTotal = 0L;
        long computedOpTotal = 0L;
        HashMap<String, RollingWindowManager.User> userOpTally = new HashMap<String, RollingWindowManager.User>();
        for (String user : this.users) {
            userOpTally.put(user, new RollingWindowManager.User(user, 0L));
        }
        for (RollingWindowManager.Op windowOp : window.getOps()) {
            int multiplier;
            if ("*".equals(windowOp.getOpType())) {
                multiplier = -1;
                allOpTotal += windowOp.getTotalCount();
            } else {
                multiplier = 1;
                computedOpTotal += windowOp.getTotalCount();
            }
            for (RollingWindowManager.User user : windowOp.getAllUsers()) {
                ((RollingWindowManager.User)userOpTally.get(user.getUser())).add((long)((int)((long)multiplier * user.getCount())));
            }
        }
        Assertions.assertEquals((long)allOpTotal, (long)computedOpTotal);
        for (String user : userOpTally.keySet()) {
            Assertions.assertEquals((long)0L, (long)((RollingWindowManager.User)userOpTally.get(user)).getCount());
        }
        return computedOpTotal;
    }
}

