/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.window;

import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindow;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRollingWindow {
    final int WINDOW_LEN = 60000;
    final int BUCKET_CNT = 10;
    final int BUCKET_LEN = 6000;

    @Test
    public void testBasics() {
        RollingWindow window = new RollingWindow(60000, 10);
        long time = 1L;
        Assertions.assertEquals((long)0L, (long)window.getSum(time), (String)"The initial sum of rolling window must be 0");
        time = 69000L;
        Assertions.assertEquals((long)0L, (long)window.getSum(time), (String)"The initial sum of rolling window must be 0");
        window.incAt(time, 5L);
        Assertions.assertEquals((long)5L, (long)window.getSum(time), (String)"The sum of rolling window does not reflect the recent update");
        window.incAt(time += 6000L, 6L);
        Assertions.assertEquals((long)11L, (long)window.getSum(time), (String)"The sum of rolling window does not reflect the recent update");
        Assertions.assertEquals((long)6L, (long)window.getSum(time += 54000L), (String)"The sum of rolling window does not reflect rolling effect");
        Assertions.assertEquals((long)0L, (long)window.getSum(time += 6000L), (String)"The sum of rolling window does not reflect rolling effect");
    }

    @Test
    public void testReorderedAccess() {
        RollingWindow window = new RollingWindow(60000, 10);
        long time = 129000L;
        window.incAt(time, 5L);
        Assertions.assertEquals((long)5L, (long)window.getSum(++time), (String)"The sum of rolling window does not reflect the recent update");
        long reorderedTime = time - 12000L;
        window.incAt(reorderedTime, 6L);
        Assertions.assertEquals((long)11L, (long)window.getSum(time), (String)"The sum of rolling window does not reflect the reordered update");
        time = reorderedTime + 60000L;
        Assertions.assertEquals((long)5L, (long)window.getSum(time), (String)"The sum of rolling window does not reflect rolling effect");
    }
}

