/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestStartupProgress {
    private StartupProgress startupProgress;

    @BeforeEach
    public void setUp() {
        this.startupProgress = new StartupProgress();
    }

    @Test
    @Timeout(value=10L)
    public void testCounter() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 200L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 5000L);
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((long)100L, (long)view.getCount(Phase.LOADING_FSIMAGE, loadingFsImageInodes));
        Assertions.assertEquals((long)200L, (long)view.getCount(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys));
        Assertions.assertEquals((long)5000L, (long)view.getCount(Phase.LOADING_EDITS, loadingEditsFile));
        Assertions.assertEquals((long)0L, (long)view.getCount(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)));
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 1000L);
        this.startupProgress.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        Assertions.assertEquals((long)5000L, (long)view.getCount(Phase.LOADING_EDITS, loadingEditsFile));
        view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((long)6000L, (long)view.getCount(Phase.LOADING_EDITS, loadingEditsFile));
    }

    @Test
    @Timeout(value=10L)
    public void testElapsedTime() throws Exception {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Thread.sleep(50L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        Thread.sleep(50L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 10000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 5000L);
        Thread.sleep(50L);
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertTrue((view.getElapsedTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.LOADING_FSIMAGE) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.LOADING_EDITS) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.LOADING_EDITS, loadingEditsFile) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.SAVING_CHECKPOINT) == 0L ? 1 : 0) != 0);
        Assertions.assertTrue((view.getElapsedTime(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)) == 0L ? 1 : 0) != 0);
        long totalTime = view.getElapsedTime();
        long loadingFsImageTime = view.getElapsedTime(Phase.LOADING_FSIMAGE);
        long loadingFsImageInodesTime = view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        long loadingFsImageDelegationKeysTime = view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        long loadingEditsTime = view.getElapsedTime(Phase.LOADING_EDITS);
        long loadingEditsFileTime = view.getElapsedTime(Phase.LOADING_EDITS, loadingEditsFile);
        Thread.sleep(50L);
        Assertions.assertTrue((totalTime < view.getElapsedTime() ? 1 : 0) != 0);
        Assertions.assertEquals((long)loadingFsImageTime, (long)view.getElapsedTime(Phase.LOADING_FSIMAGE));
        Assertions.assertEquals((long)loadingFsImageInodesTime, (long)view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes));
        Assertions.assertTrue((loadingEditsTime < view.getElapsedTime(Phase.LOADING_EDITS) ? 1 : 0) != 0);
        Assertions.assertTrue((loadingEditsFileTime < view.getElapsedTime(Phase.LOADING_EDITS, loadingEditsFile) ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=10L)
    public void testFrozenAfterStartupCompletes() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.setFile(Phase.LOADING_FSIMAGE, "file1");
        this.startupProgress.setSize(Phase.LOADING_FSIMAGE, 1000L);
        Step step = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, step, 10000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, step, 100L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        StartupProgressView beforePhaseUpdate = this.startupProgress.createView();
        Step fsimageStep2 = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, fsimageStep2);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, fsimageStep2, 1000000L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, fsimageStep2);
        for (Phase phase : EnumSet.allOf(Phase.class)) {
            if (this.startupProgress.getStatus(phase) == Status.COMPLETE) continue;
            this.startupProgress.beginPhase(phase);
            this.startupProgress.endPhase(phase);
        }
        StartupProgressView before = this.startupProgress.createView();
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.setFile(Phase.LOADING_FSIMAGE, "file2");
        this.startupProgress.setSize(Phase.LOADING_FSIMAGE, 2000L);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, step, 20000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, step, 100L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step newStep = new Step("file1");
        this.startupProgress.beginStep(Phase.LOADING_EDITS, newStep);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, newStep, 100L);
        this.startupProgress.endStep(Phase.LOADING_EDITS, newStep);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        StartupProgressView after = this.startupProgress.createView();
        this.assertViewEquals(before, after, Phase.LOADING_FSIMAGE, step, fsimageStep2);
        Assertions.assertEquals((long)before.getElapsedTime(), (long)after.getElapsedTime());
        this.assertViewEquals(beforePhaseUpdate, after, Phase.LOADING_FSIMAGE, step, fsimageStep2);
        Assertions.assertFalse((boolean)after.getSteps(Phase.LOADING_EDITS).iterator().hasNext());
    }

    private void assertViewEquals(StartupProgressView view1, StartupProgressView view2, Phase phaseToVerify, Step ... stepsToVerify) {
        Assertions.assertEquals((long)view1.getCount(phaseToVerify), (long)view2.getCount(phaseToVerify));
        Assertions.assertEquals((long)view1.getElapsedTime(phaseToVerify), (long)view2.getElapsedTime(phaseToVerify));
        Assertions.assertEquals((Object)view1.getFile(phaseToVerify), (Object)view2.getFile(phaseToVerify));
        Assertions.assertEquals((long)view1.getSize(phaseToVerify), (long)view2.getSize(phaseToVerify));
        Assertions.assertEquals((long)view1.getTotal(phaseToVerify), (long)view2.getTotal(phaseToVerify));
        for (Step step : stepsToVerify) {
            Assertions.assertEquals((long)view1.getCount(phaseToVerify, step), (long)view2.getCount(phaseToVerify, step));
            Assertions.assertEquals((long)view1.getElapsedTime(phaseToVerify, step), (long)view2.getElapsedTime(phaseToVerify, step));
            Assertions.assertEquals((long)view1.getTotal(phaseToVerify, step), (long)view2.getTotal(phaseToVerify, step));
        }
    }

    @Test
    @Timeout(value=10L)
    public void testInitialState() {
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((long)0L, (long)view.getElapsedTime());
        Assertions.assertEquals((float)0.0f, (float)view.getPercentComplete(), (float)0.001f);
        ArrayList<Phase> phases = new ArrayList<Phase>();
        for (Phase phase : view.getPhases()) {
            phases.add(phase);
            Assertions.assertEquals((long)0L, (long)view.getElapsedTime(phase));
            Assertions.assertNull((Object)view.getFile(phase));
            Assertions.assertEquals((float)0.0f, (float)view.getPercentComplete(phase), (float)0.001f);
            Assertions.assertEquals((long)Long.MIN_VALUE, (long)view.getSize(phase));
            Assertions.assertEquals((Object)Status.PENDING, (Object)view.getStatus(phase));
            Assertions.assertEquals((long)0L, (long)view.getTotal(phase));
            for (Step step : view.getSteps(phase)) {
                Assertions.fail((String)String.format("unexpected step %s in phase %s at initial state", step, phase));
            }
        }
        Assertions.assertArrayEquals((Object[])EnumSet.allOf(Phase.class).toArray(), (Object[])phases.toArray());
    }

    @Test
    @Timeout(value=10L)
    public void testPercentComplete() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes, 1000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 800L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 200L);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 10000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 5000L);
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((float)0.167f, (float)view.getPercentComplete(), (float)0.001f);
        Assertions.assertEquals((float)0.167f, (float)view.getPercentComplete(Phase.LOADING_FSIMAGE), (float)0.001f);
        Assertions.assertEquals((float)0.1f, (float)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageInodes), (float)0.001f);
        Assertions.assertEquals((float)0.25f, (float)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys), (float)0.001f);
        Assertions.assertEquals((float)0.5f, (float)view.getPercentComplete(Phase.LOADING_EDITS), (float)0.001f);
        Assertions.assertEquals((float)0.5f, (float)view.getPercentComplete(Phase.LOADING_EDITS, loadingEditsFile), (float)0.001f);
        Assertions.assertEquals((float)0.0f, (float)view.getPercentComplete(Phase.SAVING_CHECKPOINT), (float)0.001f);
        Assertions.assertEquals((float)0.0f, (float)view.getPercentComplete(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)), (float)0.001f);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((float)0.5f, (float)view.getPercentComplete(), (float)0.001f);
        Assertions.assertEquals((float)1.0f, (float)view.getPercentComplete(Phase.LOADING_FSIMAGE), (float)0.001f);
        Assertions.assertEquals((float)1.0f, (float)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageInodes), (float)0.001f);
        Assertions.assertEquals((float)1.0f, (float)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys), (float)0.001f);
        Assertions.assertEquals((float)1.0f, (float)view.getPercentComplete(Phase.LOADING_EDITS), (float)0.001f);
        Assertions.assertEquals((float)1.0f, (float)view.getPercentComplete(Phase.LOADING_EDITS, loadingEditsFile), (float)0.001f);
        Assertions.assertEquals((float)0.0f, (float)view.getPercentComplete(Phase.SAVING_CHECKPOINT), (float)0.001f);
        Assertions.assertEquals((float)0.0f, (float)view.getPercentComplete(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)), (float)0.001f);
    }

    @Test
    @Timeout(value=10L)
    public void testStatus() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)Status.COMPLETE, (Object)view.getStatus(Phase.LOADING_FSIMAGE));
        Assertions.assertEquals((Object)Status.RUNNING, (Object)view.getStatus(Phase.LOADING_EDITS));
        Assertions.assertEquals((Object)Status.PENDING, (Object)view.getStatus(Phase.SAVING_CHECKPOINT));
    }

    @Test
    @Timeout(value=10L)
    public void testStepSequence() {
        Object[] expectedSteps = new Step[]{new Step(StepType.INODES, "file1"), new Step(StepType.DELEGATION_KEYS, "file1"), new Step(StepType.INODES, "file2"), new Step(StepType.DELEGATION_KEYS, "file2"), new Step(StepType.INODES, "file3"), new Step(StepType.DELEGATION_KEYS, "file3")};
        ArrayList<Step> shuffledSteps = new ArrayList<Step>(Arrays.asList(expectedSteps));
        Collections.shuffle(shuffledSteps);
        this.startupProgress.beginPhase(Phase.SAVING_CHECKPOINT);
        for (Step step : shuffledSteps) {
            this.startupProgress.beginStep(Phase.SAVING_CHECKPOINT, step);
        }
        ArrayList<Step> actualSteps = new ArrayList<Step>(expectedSteps.length);
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        for (Step step : view.getSteps(Phase.SAVING_CHECKPOINT)) {
            actualSteps.add(step);
        }
        Assertions.assertArrayEquals((Object[])expectedSteps, (Object[])actualSteps.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testThreadSafety() throws Exception {
        int numThreads = 100;
        Phase[] phases = new Phase[]{Phase.LOADING_FSIMAGE, Phase.LOADING_FSIMAGE, Phase.LOADING_EDITS, Phase.LOADING_EDITS};
        Step[] steps = new Step[]{new Step(StepType.INODES), new Step(StepType.DELEGATION_KEYS), new Step(StepType.INODES), new Step(StepType.DELEGATION_KEYS)};
        String[] files = new String[]{"file1", "file1", "file2", "file2"};
        long[] sizes = new long[]{1000L, 1000L, 2000L, 2000L};
        long[] totals = new long[]{10000L, 20000L, 30000L, 40000L};
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        try {
            for (int i = 0; i < numThreads; ++i) {
                final Phase phase = phases[i % phases.length];
                final Step step = steps[i % steps.length];
                final String file = files[i % files.length];
                final long size = sizes[i % sizes.length];
                final long total = totals[i % totals.length];
                exec.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        TestStartupProgress.this.startupProgress.beginPhase(phase);
                        TestStartupProgress.this.startupProgress.setFile(phase, file);
                        TestStartupProgress.this.startupProgress.setSize(phase, size);
                        TestStartupProgress.this.startupProgress.setTotal(phase, step, total);
                        StartupProgressTestHelper.incrementCounter(TestStartupProgress.this.startupProgress, phase, step, 100L);
                        TestStartupProgress.this.startupProgress.endStep(phase, step);
                        return null;
                    }
                });
            }
        }
        finally {
            exec.shutdown();
            Assertions.assertTrue((boolean)exec.awaitTermination(10000L, TimeUnit.MILLISECONDS));
        }
        for (Phase phase : phases) {
            this.startupProgress.endPhase(phase);
        }
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((Object)"file1", (Object)view.getFile(Phase.LOADING_FSIMAGE));
        Assertions.assertEquals((long)1000L, (long)view.getSize(Phase.LOADING_FSIMAGE));
        Assertions.assertEquals((long)10000L, (long)view.getTotal(Phase.LOADING_FSIMAGE, new Step(StepType.INODES)));
        Assertions.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_FSIMAGE, new Step(StepType.INODES)));
        Assertions.assertEquals((long)20000L, (long)view.getTotal(Phase.LOADING_FSIMAGE, new Step(StepType.DELEGATION_KEYS)));
        Assertions.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_FSIMAGE, new Step(StepType.DELEGATION_KEYS)));
        Assertions.assertEquals((Object)"file2", (Object)view.getFile(Phase.LOADING_EDITS));
        Assertions.assertEquals((long)2000L, (long)view.getSize(Phase.LOADING_EDITS));
        Assertions.assertEquals((long)30000L, (long)view.getTotal(Phase.LOADING_EDITS, new Step(StepType.INODES)));
        Assertions.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_EDITS, new Step(StepType.INODES)));
        Assertions.assertEquals((long)40000L, (long)view.getTotal(Phase.LOADING_EDITS, new Step(StepType.DELEGATION_KEYS)));
        Assertions.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_EDITS, new Step(StepType.DELEGATION_KEYS)));
    }

    @Test
    @Timeout(value=10L)
    public void testTotal() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes, 1000L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 800L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 10000L);
        this.startupProgress.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        StartupProgressView view = this.startupProgress.createView();
        Assertions.assertNotNull((Object)view);
        Assertions.assertEquals((long)1000L, (long)view.getTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes));
        Assertions.assertEquals((long)800L, (long)view.getTotal(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys));
        Assertions.assertEquals((long)10000L, (long)view.getTotal(Phase.LOADING_EDITS, loadingEditsFile));
        Step step2 = new Step("file_2", 7000L);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, step2, 2000L);
        view = this.startupProgress.createView();
        Assertions.assertEquals((long)view.getTotal(Phase.LOADING_EDITS, step2), (long)0L);
        StartupProgress.Counter counter = this.startupProgress.getCounter(Phase.LOADING_EDITS, step2);
        counter.increment();
        Assertions.assertEquals((long)view.getCount(Phase.LOADING_EDITS, step2), (long)0L);
    }
}

