/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.Closeable;
import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestXAttrWithSnapshot {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static DistributedFileSystem hdfs;
    private static int pathCount;
    private static Path path;
    private static Path snapshotPath;
    private static Path snapshotPath2;
    private static Path snapshotPath3;
    private static String snapshotName;
    private static String snapshotName2;
    private static String snapshotName3;
    private final int SUCCESS = 0;
    private static final String name1 = "user.a1";
    private static final byte[] value1;
    private static final byte[] newValue1;
    private static final String name2 = "user.a2";
    private static final byte[] value2;

    @BeforeAll
    public static void init() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        TestXAttrWithSnapshot.initCluster(true);
    }

    @AfterAll
    public static void shutdown() throws Exception {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{hdfs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() {
        path = new Path("/p" + ++pathCount);
        snapshotName = "snapshot" + pathCount;
        snapshotName2 = snapshotName + "-2";
        snapshotName3 = snapshotName + "-3";
        snapshotPath = new Path(path, new Path(".snapshot", snapshotName));
        snapshotPath2 = new Path(path, new Path(".snapshot", snapshotName2));
        snapshotPath3 = new Path(path, new Path(".snapshot", snapshotName3));
    }

    @Test
    @Timeout(value=120L)
    public void testModifyReadsCurrentState() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        Map xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)xattrs.size(), (int)0);
        hdfs.setXAttr(path, name1, value2, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.setXAttr(path, name2, value1, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)xattrs.size(), (int)0);
        hdfs.removeXAttr(path, name1);
        hdfs.removeXAttr(path, name2);
        xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)0);
    }

    @Test
    public void testXattrWithSnapshotAndNNRestart() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.allowSnapshot(path);
        hdfs.createSnapshot(path, snapshotName);
        SnapshotDiffReport report = hdfs.getSnapshotDiffReport(path, snapshotName, "");
        System.out.println(report);
        Assertions.assertEquals((int)0, (int)report.getDiffList().size());
        report = hdfs.getSnapshotDiffReport(path, snapshotName, "");
        System.out.println(report);
        Assertions.assertEquals((int)0, (int)report.getDiffList().size());
        hdfs.setSafeMode(SafeModeAction.ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNode(true);
        report = hdfs.getSnapshotDiffReport(path, snapshotName, "");
        System.out.println(report);
        Assertions.assertEquals((int)0, (int)report.getDiffList().size());
    }

    @Test
    @Timeout(value=120L)
    public void testRemoveReadsCurrentState() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        Map xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)xattrs.size(), (int)0);
        hdfs.removeXAttr(path, name2);
        xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        hdfs.removeXAttr(path, name1);
        xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)0);
    }

    @Test
    public void testXAttrForSnapshotRootAfterChange() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Map xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.setXAttr(path, name1, newValue1);
        TestXAttrWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(false);
        TestXAttrWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(true);
        TestXAttrWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
    }

    private static void doSnapshotRootChangeAssertions(Path path, Path snapshotPath) throws Exception {
        Map xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    @Test
    public void testXAttrForSnapshotRootAfterRemove() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Map xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.removeXAttr(path, name1);
        hdfs.removeXAttr(path, name2);
        TestXAttrWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(false);
        TestXAttrWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(true);
        TestXAttrWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
    }

    private static void doSnapshotRootRemovalAssertions(Path path, Path snapshotPath) throws Exception {
        Map xattrs = hdfs.getXAttrs(path);
        Assertions.assertEquals((int)0, (int)xattrs.size());
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)2, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    @Test
    public void testSuccessiveSnapshotXAttrChanges() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Map xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)1, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        hdfs.setXAttr(path, name1, newValue1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName2);
        xattrs = hdfs.getXAttrs(snapshotPath2);
        Assertions.assertEquals((int)2, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.setXAttr(path, name1, value1);
        hdfs.removeXAttr(path, name2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName3);
        xattrs = hdfs.getXAttrs(snapshotPath3);
        Assertions.assertEquals((int)1, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)1, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        xattrs = hdfs.getXAttrs(snapshotPath2);
        Assertions.assertEquals((int)2, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.deleteSnapshot(path, snapshotName2);
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assertions.assertEquals((int)1, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        xattrs = hdfs.getXAttrs(snapshotPath3);
        Assertions.assertEquals((int)1, (int)xattrs.size());
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        hdfs.deleteSnapshot(path, snapshotName);
        hdfs.deleteSnapshot(path, snapshotName3);
    }

    @Test
    public void testSetXAttrSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> hdfs.setXAttr(snapshotPath, name1, value1));
    }

    @Test
    public void testRemoveXAttrSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> hdfs.removeXAttr(snapshotPath, name1));
    }

    @Test
    @Timeout(value=120L)
    public void testCopySnapshotShouldPreserveXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Path snapshotCopy = new Path(path.toString() + "-copy");
        String[] argv = new String[]{"-cp", "-px", snapshotPath.toUri().toString(), snapshotCopy.toUri().toString()};
        int ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
        Assertions.assertEquals((int)0, (int)ret, (String)"cp -px is not working on a snapshot");
        Map xattrs = hdfs.getXAttrs(snapshotCopy);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    private static void initCluster(boolean format) throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    private static void restart(boolean checkpoint) throws Exception {
        NameNode nameNode = cluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        TestXAttrWithSnapshot.shutdown();
        TestXAttrWithSnapshot.initCluster(false);
    }

    static {
        pathCount = 0;
        value1 = new byte[]{49, 50, 51};
        newValue1 = new byte[]{49, 49, 49};
        value2 = new byte[]{55, 56, 57};
    }
}

