/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSnapshotNameWithInvalidCharacters {
    private static final long SEED = 0L;
    private static final short REPLICATION = 1;
    private static final int BLOCKSIZE = 1024;
    private static final Configuration conf = new Configuration();
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem hdfs;
    private final Path dir1 = new Path("/");
    private final String file1Name = "file1";
    private final String snapshot1 = "a:b:c";
    private final String snapshot2 = "a/b/c";

    @BeforeEach
    public void setUp() throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    @Timeout(value=600L)
    public void TestSnapshotWithInvalidName() throws Exception {
        Path file1 = new Path(this.dir1, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 0L);
        hdfs.allowSnapshot(this.dir1);
        try {
            hdfs.createSnapshot(this.dir1, "a:b:c");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=60L)
    public void TestSnapshotWithInvalidName1() throws Exception {
        Path file1 = new Path(this.dir1, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 0L);
        hdfs.allowSnapshot(this.dir1);
        try {
            hdfs.createSnapshot(this.dir1, "a/b/c");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

