/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSnapshotListing {
    static final long seed = 0L;
    static final short REPLICATION = 3;
    static final long BLOCKSIZE = 1024L;
    private final Path dir = new Path("/test.snapshot/dir");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(this.dir);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=15L)
    public void testListSnapshots() throws Exception {
        int i;
        int sNum;
        Path snapshotsPath = new Path(this.dir, ".snapshot");
        FileStatus[] stats = null;
        stats = this.hdfs.listStatus(new Path("/.snapshot"));
        Assertions.assertEquals((int)0, (int)stats.length);
        try {
            stats = this.hdfs.listStatus(snapshotsPath);
            Assertions.fail((String)"expect SnapshotException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + this.dir.toString()), (Throwable)e);
        }
        this.hdfs.allowSnapshot(this.dir);
        stats = this.hdfs.listStatus(snapshotsPath);
        Assertions.assertEquals((int)0, (int)stats.length);
        int snapshotNum = 5;
        for (sNum = 0; sNum < 5; ++sNum) {
            this.hdfs.createSnapshot(this.dir, "s_" + sNum);
            stats = this.hdfs.listStatus(snapshotsPath);
            Assertions.assertEquals((int)(sNum + 1), (int)stats.length);
            for (i = 0; i <= sNum; ++i) {
                Assertions.assertEquals((Object)("s_" + i), (Object)stats[i].getPath().getName());
            }
        }
        for (sNum = 4; sNum > 0; --sNum) {
            this.hdfs.deleteSnapshot(this.dir, "s_" + sNum);
            stats = this.hdfs.listStatus(snapshotsPath);
            Assertions.assertEquals((int)sNum, (int)stats.length);
            for (i = 0; i < sNum; ++i) {
                Assertions.assertEquals((Object)("s_" + i), (Object)stats[i].getPath().getName());
            }
        }
        this.hdfs.deleteSnapshot(this.dir, "s_0");
        stats = this.hdfs.listStatus(snapshotsPath);
        Assertions.assertEquals((int)0, (int)stats.length);
    }
}

