/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSnapshotBlocksMap {
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private static final int BLOCKSIZE = 1024;
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected FSNamesystem fsn;
    FSDirectory fsdir;
    BlockManager blockmanager;
    protected DistributedFileSystem hdfs;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.blockmanager = this.fsn.getBlockManager();
        this.hdfs = this.cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    static INodeFile assertBlockCollection(String path, int numBlocks, FSDirectory dir, BlockManager blkManager) throws Exception {
        INodeFile file = INodeFile.valueOf((INode)dir.getINode(path), (String)path);
        Assertions.assertEquals((int)numBlocks, (int)file.getBlocks().length);
        for (BlockInfo b : file.getBlocks()) {
            TestSnapshotBlocksMap.assertBlockCollection(blkManager, file, b);
        }
        return file;
    }

    static void assertBlockCollection(BlockManager blkManager, INodeFile file, BlockInfo b) {
        Assertions.assertSame((Object)b, (Object)blkManager.getStoredBlock((Block)b));
        Assertions.assertEquals((long)file.getId(), (long)b.getBlockCollectionId());
    }

    @Test
    @Timeout(value=60L)
    public void testDeletionWithSnapshots() throws Exception {
        Path file0 = new Path(this.sub1, "file0");
        Path file1 = new Path(this.sub1, "file1");
        Path sub2 = new Path(this.sub1, "sub2");
        Path file2 = new Path(sub2, "file2");
        Path file3 = new Path(this.sub1, "file3");
        Path file4 = new Path(this.sub1, "file4");
        Path file5 = new Path(this.sub1, "file5");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file0, 4096L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 2048L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file2, 3072L, (short)3, 0L);
        INodeFile f2 = TestSnapshotBlocksMap.assertBlockCollection(file2.toString(), 3, this.fsdir, this.blockmanager);
        BlockInfo[] blocks = f2.getBlocks();
        this.hdfs.delete(sub2, true);
        for (BlockInfo b : blocks) {
            Assertions.assertEquals((long)-1L, (long)b.getBlockCollectionId());
        }
        String[] snapshots = new String[]{"s0", "s1", "s2"};
        DFSTestUtil.createFile((FileSystem)this.hdfs, file3, 5120L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, snapshots[0]);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file4, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, snapshots[1]);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file5, 7168L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, snapshots[2]);
        INodeFile f1 = TestSnapshotBlocksMap.assertBlockCollection(file1.toString(), 2, this.fsdir, this.blockmanager);
        Assertions.assertSame(INodeFile.class, f1.getClass());
        this.hdfs.setReplication(file1, (short)2);
        f1 = TestSnapshotBlocksMap.assertBlockCollection(file1.toString(), 2, this.fsdir, this.blockmanager);
        Assertions.assertTrue((boolean)f1.isWithSnapshot());
        Assertions.assertFalse((boolean)f1.isUnderConstruction());
        INodeFile f0 = TestSnapshotBlocksMap.assertBlockCollection(file0.toString(), 4, this.fsdir, this.blockmanager);
        BlockInfo[] blocks0 = f0.getBlocks();
        Path snapshotFile0 = SnapshotTestHelper.getSnapshotPath(this.sub1, "s0", file0.getName());
        TestSnapshotBlocksMap.assertBlockCollection(snapshotFile0.toString(), 4, this.fsdir, this.blockmanager);
        this.hdfs.delete(file0, true);
        for (BlockInfo b : blocks0) {
            Assertions.assertNotEquals((long)-1L, (long)b.getBlockCollectionId());
        }
        TestSnapshotBlocksMap.assertBlockCollection(snapshotFile0.toString(), 4, this.fsdir, this.blockmanager);
        String s1f0 = SnapshotTestHelper.getSnapshotPath(this.sub1, "s1", file0.getName()).toString();
        TestSnapshotBlocksMap.assertBlockCollection(s1f0, 4, this.fsdir, this.blockmanager);
        this.hdfs.deleteSnapshot(this.sub1, "s1");
        for (BlockInfo b : blocks0) {
            Assertions.assertNotEquals((long)-1L, (long)b.getBlockCollectionId());
        }
        TestSnapshotBlocksMap.assertBlockCollection(snapshotFile0.toString(), 4, this.fsdir, this.blockmanager);
        try {
            INodeFile.valueOf((INode)this.fsdir.getINode(s1f0), (String)s1f0);
            Assertions.fail((String)"Expect FileNotFoundException when identifying the INode in a deleted Snapshot");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("File does not exist: " + s1f0), (Throwable)e);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testReadSnapshotFileWithCheckpoint() throws Exception {
        Path foo = new Path("/foo");
        this.hdfs.mkdirs(foo);
        this.hdfs.allowSnapshot(foo);
        Path bar = new Path("/foo/bar");
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 100L, (short)2, 100024L);
        this.hdfs.createSnapshot(foo, "s1");
        Assertions.assertTrue((boolean)this.hdfs.delete(bar, true));
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeAdapter.enterSafeMode(nameNode, false);
        NameNodeAdapter.saveNamespace(nameNode);
        NameNodeAdapter.leaveSafeMode(nameNode);
        this.cluster.restartNameNode(true);
        String snapshotPath = Snapshot.getSnapshotPath((String)foo.toString(), (String)"s1/bar");
        DFSTestUtil.readFile((FileSystem)this.hdfs, new Path(snapshotPath));
    }

    @Test
    @Timeout(value=30L)
    public void testReadRenamedSnapshotFileWithCheckpoint() throws Exception {
        Path foo = new Path("/foo");
        Path foo2 = new Path("/foo2");
        this.hdfs.mkdirs(foo);
        this.hdfs.mkdirs(foo2);
        this.hdfs.allowSnapshot(foo);
        this.hdfs.allowSnapshot(foo2);
        Path bar = new Path(foo, "bar");
        Path bar2 = new Path(foo2, "bar");
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 100L, (short)2, 100024L);
        this.hdfs.createSnapshot(foo, "s1");
        Assertions.assertTrue((boolean)this.hdfs.rename(bar, bar2));
        this.hdfs.createSnapshot(foo2, "s2");
        Assertions.assertTrue((boolean)this.hdfs.delete(bar2, true));
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeAdapter.enterSafeMode(nameNode, false);
        NameNodeAdapter.saveNamespace(nameNode);
        NameNodeAdapter.leaveSafeMode(nameNode);
        this.cluster.restartNameNode(true);
        String barSnapshotPath = Snapshot.getSnapshotPath((String)foo.toString(), (String)"s1/bar");
        DFSTestUtil.readFile((FileSystem)this.hdfs, new Path(barSnapshotPath));
        String bar2SnapshotPath = Snapshot.getSnapshotPath((String)foo2.toString(), (String)"s2/bar");
        DFSTestUtil.readFile((FileSystem)this.hdfs, new Path(bar2SnapshotPath));
    }

    @Test
    public void testDeletionWithZeroSizeBlock() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, foo, "s0");
        this.hdfs.append(bar);
        INodeFile barNode = this.fsdir.getINode4Write(bar.toString()).asFile();
        BlockInfo[] blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
        ExtendedBlock previous = new ExtendedBlock(this.fsn.getBlockPoolId(), (Block)blks[0]);
        this.cluster.getNameNodeRpc().addBlock(bar.toString(), this.hdfs.getClient().getClientName(), previous, null, barNode.getId(), null, null);
        SnapshotTestHelper.createSnapshot(this.hdfs, foo, "s1");
        barNode = this.fsdir.getINode4Write(bar.toString()).asFile();
        blks = barNode.getBlocks();
        Assertions.assertEquals((int)2, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
        Assertions.assertEquals((long)0L, (long)blks[1].getNumBytes());
        this.hdfs.delete(bar, true);
        Path sbar = SnapshotTestHelper.getSnapshotPath(foo, "s1", bar.getName());
        barNode = this.fsdir.getINode(sbar.toString()).asFile();
        blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
    }

    @Test
    public void testDeletionWithZeroSizeBlock2() throws Exception {
        Path foo = new Path("/foo");
        Path subDir = new Path(foo, "sub");
        Path bar = new Path(subDir, "bar");
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 1024L, (short)3, 0L);
        this.hdfs.append(bar);
        INodeFile barNode = this.fsdir.getINode4Write(bar.toString()).asFile();
        BlockInfo[] blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        ExtendedBlock previous = new ExtendedBlock(this.fsn.getBlockPoolId(), (Block)blks[0]);
        this.cluster.getNameNodeRpc().addBlock(bar.toString(), this.hdfs.getClient().getClientName(), previous, null, barNode.getId(), null, null);
        SnapshotTestHelper.createSnapshot(this.hdfs, foo, "s1");
        barNode = this.fsdir.getINode4Write(bar.toString()).asFile();
        blks = barNode.getBlocks();
        Assertions.assertEquals((int)2, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
        Assertions.assertEquals((long)0L, (long)blks[1].getNumBytes());
        this.hdfs.delete(subDir, true);
        Path sbar = SnapshotTestHelper.getSnapshotPath(foo, "s1", "sub/bar");
        barNode = this.fsdir.getINode(sbar.toString()).asFile();
        blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
    }

    @Test
    public void testDeletionWithZeroSizeBlock3() throws Exception {
        Path foo = new Path("/foo");
        Path subDir = new Path(foo, "sub");
        Path bar = new Path(subDir, "bar");
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 1024L, (short)3, 0L);
        this.hdfs.append(bar);
        INodeFile barNode = this.fsdir.getINode4Write(bar.toString()).asFile();
        BlockInfo[] blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        ExtendedBlock previous = new ExtendedBlock(this.fsn.getBlockPoolId(), (Block)blks[0]);
        this.cluster.getNameNodeRpc().addBlock(bar.toString(), this.hdfs.getClient().getClientName(), previous, null, barNode.getId(), null, null);
        SnapshotTestHelper.createSnapshot(this.hdfs, foo, "s1");
        Path bar2 = new Path(subDir, "bar2");
        this.hdfs.rename(bar, bar2);
        INodeFile bar2Node = this.fsdir.getINode4Write(bar2.toString()).asFile();
        blks = bar2Node.getBlocks();
        Assertions.assertEquals((int)2, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
        Assertions.assertEquals((long)0L, (long)blks[1].getNumBytes());
        this.hdfs.delete(subDir, true);
        Path sbar = SnapshotTestHelper.getSnapshotPath(foo, "s1", "sub/bar");
        barNode = this.fsdir.getINode(sbar.toString()).asFile();
        blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        Assertions.assertEquals((long)1024L, (long)blks[0].getNumBytes());
    }

    @Test
    public void testDeletionOfLaterBlocksWithZeroSizeFirstBlock() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        byte[] testData = "foo bar baz".getBytes();
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 0L, (short)3, 0L);
        Assertions.assertEquals((int)0, (int)this.fsdir.getINode4Write(bar.toString()).asFile().getBlocks().length);
        SnapshotTestHelper.createSnapshot(this.hdfs, foo, "s0");
        FSDataOutputStream out = this.hdfs.append(bar);
        out.write(testData);
        out.close();
        INodeFile barNode = this.fsdir.getINode4Write(bar.toString()).asFile();
        BlockInfo[] blks = barNode.getBlocks();
        Assertions.assertEquals((int)1, (int)blks.length);
        Assertions.assertEquals((long)testData.length, (long)blks[0].getNumBytes());
        this.hdfs.delete(bar, true);
        this.cluster.getNameNode().getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        this.cluster.getNameNode().getRpcServer().saveNamespace(0L, 0L);
    }
}

