/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.server.namenode.snapshot.TestSnapshotDiffReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSnapRootDescendantDiff {
    private final Path dir;
    private final Path sub1;
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected DistributedFileSystem hdfs;
    private final Map<Path, Integer> snapshotNumberMap;

    public TestSnapRootDescendantDiff() {
        SnapshotTestHelper.disableLogs();
        this.dir = new Path("/" + this.getClass().getSimpleName());
        this.sub1 = new Path(this.dir, "sub1");
        this.snapshotNumberMap = new HashMap<Path, Integer>();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.namenode.snapshot.capture.openfiles", true);
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setBoolean("dfs.namenode.snapshot.skip.capture.accesstime-only-change", true);
        this.conf.setBoolean("dfs.namenode.snapshotdiff.allow.snap-root-descendant", false);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private Path getSnapRootDir() {
        return this.sub1;
    }

    private String genSnapshotName(Path snapshotDir) {
        int sNum = -1;
        if (this.snapshotNumberMap.containsKey(snapshotDir)) {
            sNum = this.snapshotNumberMap.get(snapshotDir);
        }
        this.snapshotNumberMap.put(snapshotDir, ++sNum);
        return "s" + sNum;
    }

    void modifyAndCreateSnapshot(Path modifyDir, Path[] snapshotDirs) throws Exception {
        TestSnapshotDiffReport.modifyAndCreateSnapshot(modifyDir, snapshotDirs, this.hdfs, this::genSnapshotName);
    }

    @Test
    public void testNonSnapRootDiffReport() throws Exception {
        Path subsub1 = new Path(this.getSnapRootDir(), "subsub1");
        Path subsubsub1 = new Path(subsub1, "subsubsub1");
        this.hdfs.mkdirs(subsubsub1);
        this.modifyAndCreateSnapshot(this.getSnapRootDir(), new Path[]{this.getSnapRootDir()});
        this.modifyAndCreateSnapshot(subsubsub1, new Path[]{this.getSnapRootDir()});
        try {
            this.hdfs.getSnapshotDiffReport(subsub1, "s1", "s2");
            Assertions.fail((String)("Expect exception when getting snapshot diff report: " + subsub1 + " is not a snapshottable directory."));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + subsub1), (Throwable)e);
        }
    }
}

