/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSetQuotaWithSnapshot {
    protected static final long seed = 0L;
    protected static final short REPLICATION = 3;
    protected static final long BLOCKSIZE = 1024L;
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected FSNamesystem fsn;
    protected FSDirectory fsdir;
    protected DistributedFileSystem hdfs;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.hdfs = this.cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSetQuota() throws Exception {
        Path dir = new Path("/TestSnapshot");
        this.hdfs.mkdirs(dir);
        SnapshotTestHelper.createSnapshot(this.hdfs, dir, "s1");
        Path sub = new Path(dir, "sub");
        this.hdfs.mkdirs(sub);
        Path fileInSub = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInSub, 1024L, (short)3, 0L);
        INodeDirectory subNode = INodeDirectory.valueOf((INode)this.fsdir.getINode(sub.toString()), (Object)sub);
        Assertions.assertFalse((boolean)subNode.isWithSnapshot());
        this.hdfs.setQuota(sub, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        subNode = INodeDirectory.valueOf((INode)this.fsdir.getINode(sub.toString()), (Object)sub);
        Assertions.assertTrue((boolean)subNode.isQuotaSet());
        Assertions.assertFalse((boolean)subNode.isWithSnapshot());
    }

    @Test
    public void testClearQuota() throws Exception {
        Path dir = new Path("/TestSnapshot");
        this.hdfs.mkdirs(dir);
        this.hdfs.allowSnapshot(dir);
        this.hdfs.setQuota(dir, Long.MAX_VALUE, Long.MAX_VALUE);
        INodeDirectory dirNode = this.fsdir.getINode4Write(dir.toString()).asDirectory();
        Assertions.assertTrue((boolean)dirNode.isSnapshottable());
        Assertions.assertEquals((int)0, (int)dirNode.getDiffs().asList().size());
        this.hdfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        dirNode = this.fsdir.getINode4Write(dir.toString()).asDirectory();
        Assertions.assertTrue((boolean)dirNode.isSnapshottable());
        Assertions.assertEquals((int)0, (int)dirNode.getDiffs().asList().size());
        this.hdfs.setQuota(dir, -1L, -1L);
        dirNode = this.fsdir.getINode4Write(dir.toString()).asDirectory();
        Assertions.assertTrue((boolean)dirNode.isSnapshottable());
        Assertions.assertEquals((int)0, (int)dirNode.getDiffs().asList().size());
        SnapshotTestHelper.createSnapshot(this.hdfs, dir, "s1");
        this.hdfs.setQuota(dir, -1L, -1L);
        dirNode = this.fsdir.getINode4Write(dir.toString()).asDirectory();
        Assertions.assertTrue((boolean)dirNode.isSnapshottable());
        Assertions.assertEquals((int)1, (int)dirNode.getDiffs().asList().size());
        SnapshottableDirectoryStatus[] status = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)status.length);
        Assertions.assertEquals((Object)dir, (Object)status[0].getFullPath());
        Path subDir = new Path(dir, "sub");
        this.hdfs.mkdirs(subDir);
        this.hdfs.createSnapshot(dir, "s2");
        Path file = new Path(subDir, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
        this.hdfs.setQuota(dir, -1L, -1L);
        INode subNode = this.fsdir.getINode4Write(subDir.toString());
        Assertions.assertTrue((boolean)subNode.asDirectory().isWithSnapshot());
        DiffList diffList = subNode.asDirectory().getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        Snapshot s2 = dirNode.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Assertions.assertEquals((int)s2.getId(), (int)diff.getSnapshotId());
        List createdList = diff.getChildrenDiff().getCreatedUnmodifiable();
        Assertions.assertEquals((int)1, (int)createdList.size());
        Assertions.assertSame((Object)this.fsdir.getINode4Write(file.toString()), createdList.get(0));
    }
}

