/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestListSnapshot {
    static final short REPLICATION = 3;
    private final Path dir1 = new Path("/TestSnapshot1");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.namenode.snapshot.deletion.ordered", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(this.dir1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testListSnapshot() throws Exception {
        this.fsn.getSnapshotManager().setAllowNestedSnapshots(true);
        SnapshotStatus[] snapshotStatuses = null;
        SnapshottableDirectoryStatus[] dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertNull((Object)dirs);
        LambdaTestUtils.intercept(SnapshotException.class, (String)"Directory is not a snapshottable directory", () -> this.hdfs.getSnapshotListing(this.dir1));
        Path root = new Path("/");
        this.hdfs.allowSnapshot(root);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)"", (Object)dirs[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)root, (Object)dirs[0].getFullPath());
        snapshotStatuses = this.hdfs.getSnapshotListing(root);
        Assertions.assertTrue((snapshotStatuses.length == 0 ? 1 : 0) != 0);
        this.hdfs.disallowSnapshot(root);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertNull((Object)dirs);
        snapshotStatuses = this.hdfs.getSnapshotListing(root);
        Assertions.assertTrue((snapshotStatuses.length == 0 ? 1 : 0) != 0);
        this.hdfs.allowSnapshot(this.dir1);
        this.hdfs.createSnapshot(this.dir1, "s0");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assertions.assertEquals((int)1, (int)snapshotStatuses.length);
        Assertions.assertEquals((Object)"s0", (Object)snapshotStatuses[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s0"), (Object)snapshotStatuses[0].getFullPath());
        Assertions.assertEquals((int)0, (int)snapshotStatuses[0].getSnapshotID());
        this.hdfs.createSnapshot(this.dir1, "s1");
        this.hdfs.createSnapshot(this.dir1, "s2");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assertions.assertEquals((int)3, (int)snapshotStatuses.length);
        Assertions.assertEquals((Object)"s0", (Object)snapshotStatuses[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s0"), (Object)snapshotStatuses[0].getFullPath());
        Assertions.assertEquals((Object)"s1", (Object)snapshotStatuses[1].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s1"), (Object)snapshotStatuses[1].getFullPath());
        Assertions.assertEquals((Object)"s2", (Object)snapshotStatuses[2].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s2"), (Object)snapshotStatuses[2].getFullPath());
        this.hdfs.deleteSnapshot(this.dir1, "s2");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assertions.assertEquals((int)3, (int)snapshotStatuses.length);
        Assertions.assertTrue((boolean)snapshotStatuses[2].isDeleted());
        Assertions.assertFalse((boolean)snapshotStatuses[1].isDeleted());
        Assertions.assertFalse((boolean)snapshotStatuses[0].isDeleted());
        this.hdfs.deleteSnapshot(this.dir1, "s0");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assertions.assertEquals((int)2, (int)snapshotStatuses.length);
    }
}

