/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsShellMoveToTrashWithSnapshots {
    private static final Logger LOG;
    private static final String TMP = ".tmp";
    private static final String WAREHOUSE_DIR = "/warehouse/sub/";
    private static final String TO_BE_REMOVED = "TMP/";
    private static SnapshotTestHelper.MyCluster cluster;

    @BeforeEach
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("fs.trash.interval", 100);
        cluster = new SnapshotTestHelper.MyCluster(conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    MyFile createTmp(String filePath) throws Exception {
        MyFile f = new MyFile(filePath);
        cluster.createFile(f.tmp);
        return f;
    }

    DeleteSnapshotOp moveFromTmp2Dst(MyFile file, Path dstDir) throws Exception {
        String snapshot = file.moveFromTmp2Dst(dstDir);
        return new DeleteSnapshotOp(snapshot);
    }

    List<MyFile> runTestMoveToTrashWithShell(Path dbDir, Path tmpDir, int numFiles) throws Exception {
        return this.runTestMoveToTrashWithShell(dbDir, tmpDir, numFiles, 4, null);
    }

    List<MyFile> runTestMoveToTrashWithShell(Path dbDir, Path tmpDir, int numFiles, int depth, Integer randomSleepMaxMs) throws Exception {
        int i;
        LOG.info("dbDir={}", (Object)dbDir);
        LOG.info("tmpDir={}", (Object)tmpDir);
        LOG.info("numFiles={}, depth={}, randomSleepMaxMs={}", new Object[]{numFiles, depth, randomSleepMaxMs});
        cluster.setPrintTree(numFiles < 10);
        ArrayList<Op> ops = new ArrayList<Op>();
        TestFsShellMoveToTrashWithSnapshots.createSnapshot(ops);
        Path sub1 = cluster.mkdirs(new Path(dbDir, "sub1"));
        Path sub2 = cluster.mkdirs(new Path(sub1, "sub2"));
        ops.add(new DeleteSnapshotOp(cluster.rename(sub2, dbDir)));
        sub2 = new Path(dbDir, "sub2");
        ops.add(new DeleteSnapshotOp(cluster.rename(sub1, sub2)));
        sub1 = new Path(sub2, "sub1");
        MyDirs dirs = new MyDirs(sub1, depth);
        cluster.mkdirs(dirs.getPath());
        ArrayList<MyFile> buckets = new ArrayList<MyFile>();
        for (int i2 = 0; i2 < dirs.depth() / 2; ++i2) {
            ops.add(dirs.rename());
        }
        int offset = numFiles / 4;
        for (i = 0; i < numFiles; ++i) {
            String bucket = tmpDir + String.format("/bucket_%04d", i);
            TestFsShellMoveToTrashWithSnapshots.createSnapshot(ops);
            buckets.add(this.createTmp(bucket));
            if (i >= offset) {
                int j = i - offset;
                ops.add(this.moveFromTmp2Dst((MyFile)buckets.get(j), dirs.getPath()));
            }
            if (randomSleepMaxMs == null) continue;
            Thread.sleep(ThreadLocalRandom.current().nextInt(randomSleepMaxMs));
        }
        for (i = dirs.depth() / 2; i < dirs.depth(); ++i) {
            ops.add(dirs.rename());
        }
        ops.add(new DeleteSnapshotOp(cluster.rename(dirs.getSubPath(1), sub2)));
        ops.add(new DeleteSnapshotOp(cluster.rename(sub1, dbDir)));
        sub1 = new Path(dbDir, "sub1");
        ops.add(new DeleteSnapshotOp(cluster.rename(sub2, sub1)));
        sub2 = new Path(sub1, "sub2");
        ops.add(new DeleteSnapshotOp(cluster.rename(sub2, new Path(sub1, "sub1"))));
        ops.add(new DeleteSnapshotOp(cluster.rename(sub1, new Path(dbDir, "sub2"))));
        MoveToTrashOp m = new MoveToTrashOp(dbDir);
        m.trashPath.thenAccept(p -> this.updateTrashPath((String)p, (List<MyFile>)buckets));
        ops.add(m);
        LOG.info("ops count: {}", (Object)ops.size());
        while (!ops.isEmpty()) {
            this.runOneOp(ops);
        }
        cluster.printFs("END");
        return buckets;
    }

    static Path removeSubstring(Path p) {
        if (p == null) {
            return null;
        }
        return new Path(p.toUri().getPath().replace(TO_BE_REMOVED, ""));
    }

    void updateTrashPath(String trashPathPrefix, List<MyFile> files) {
        int j = trashPathPrefix.lastIndexOf(47);
        String commonPrefix = trashPathPrefix.substring(0, j + 1);
        for (MyFile f : files) {
            String original = f.trash.toUri().getPath();
            if (original.startsWith(trashPathPrefix)) continue;
            Assertions.assertTrue((boolean)original.startsWith(commonPrefix));
            int i = original.indexOf(47, commonPrefix.length());
            String suffix = original.substring(i + 1);
            f.trash = new Path(trashPathPrefix, suffix);
        }
    }

    @Test
    @Timeout(value=300L)
    public void test100tasks20files() throws Exception {
        this.runMultipleTasks(100, 20);
    }

    @Test
    @Timeout(value=300L)
    public void test10tasks200files() throws Exception {
        this.runMultipleTasks(10, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runMultipleTasks(int numTasks, int filesPerTask) throws Exception {
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        ArrayList<MyFile> buckets = new ArrayList<MyFile>();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < numTasks; ++i) {
                String string = "db" + i;
                String tmp = "tmp" + i;
                futures.add(executor.submit(() -> {
                    Path dbDir = cluster.mkdirs(WAREHOUSE_DIR + db);
                    Path tmpDir = cluster.mkdirs(WAREHOUSE_DIR + tmp);
                    return this.runTestMoveToTrashWithShell(dbDir, tmpDir, filesPerTask, 4, 100);
                }));
            }
            for (Future future : futures) {
                buckets.addAll((Collection)future.get());
            }
        }
        finally {
            executor.shutdown();
        }
        this.assertExists(buckets, f -> TestFsShellMoveToTrashWithSnapshots.removeSubstring(f.getPath()));
    }

    @Test
    @Timeout(value=100L)
    public void test4files() throws Exception {
        Path dbDir = cluster.mkdirs("/warehouse/sub/db");
        Path tmpDir = cluster.mkdirs("/warehouse/sub/tmp");
        List<MyFile> buckets = this.runTestMoveToTrashWithShell(dbDir, tmpDir, 4, 2, null);
        this.assertExists(buckets, f -> TestFsShellMoveToTrashWithSnapshots.removeSubstring(f.getPath()));
    }

    @Test
    @Timeout(value=300L)
    public void test200files() throws Exception {
        Path dbDir = cluster.mkdirs("/warehouse/sub/db");
        Path tmpDir = cluster.mkdirs("/warehouse/sub/tmp");
        List<MyFile> buckets = this.runTestMoveToTrashWithShell(dbDir, tmpDir, 200);
        this.assertExists(buckets, f -> TestFsShellMoveToTrashWithSnapshots.removeSubstring(f.getPath()));
    }

    @Test
    @Timeout(value=300L)
    public void test50files10times() throws Exception {
        Path tmpDir = cluster.mkdirs("/warehouse/sub/tmp");
        ArrayList<MyFile> buckets = new ArrayList<MyFile>();
        for (int i = 0; i < 10; ++i) {
            Path dbDir = cluster.mkdirs("/warehouse/sub/db");
            buckets.addAll(this.runTestMoveToTrashWithShell(dbDir, tmpDir, 50));
        }
        cluster.setPrintTree(true);
        cluster.printFs("test_10files_10times");
        this.assertExists(buckets, f -> TestFsShellMoveToTrashWithSnapshots.removeSubstring(f.getPath()));
    }

    static void createSnapshot(List<Op> ops) throws Exception {
        if (ThreadLocalRandom.current().nextBoolean()) {
            ops.add(new DeleteSnapshotOp(cluster.createSnapshot()));
        }
    }

    void runOneOp(List<Op> ops) throws Exception {
        Collections.shuffle(ops);
        Op op = ops.remove(ops.size() - 1);
        if (op instanceof MoveToTrashOp) {
            TestFsShellMoveToTrashWithSnapshots.createSnapshot(ops);
        }
        op.execute();
    }

    void assertExists(List<MyFile> files, Function<MyFile, Path> getPath) throws Exception {
        for (MyFile f : files) {
            Path p = getPath.apply(f);
            boolean exists = cluster.assertExists(p);
            if (!cluster.getPrintTree()) continue;
            LOG.info("{} exists? {}, {}", new Object[]{p, exists, f});
        }
    }

    static {
        SnapshotTestHelper.disableLogs();
        LOG = LoggerFactory.getLogger((String)"XXX");
    }

    static class DeleteSnapshotOp
    extends Op {
        private final String name;

        DeleteSnapshotOp(String name) {
            this.name = name;
        }

        @Override
        void executeImpl() throws Exception {
            cluster.deleteSnapshot(this.name);
        }
    }

    static class MoveToTrashOp
    extends Op {
        private final Path path;
        private final CompletableFuture<String> trashPath = new CompletableFuture();

        MoveToTrashOp(Path path) {
            this.path = path;
        }

        @Override
        public void executeImpl() throws Exception {
            Path p = cluster.moveToTrash(this.path, true);
            LOG.info("MoveToTrash: {} -> {}", (Object)this.path, (Object)p);
            this.trashPath.complete(p.toUri().getPath());
        }
    }

    static abstract class Op {
        private final AtomicBoolean executed = new AtomicBoolean();

        Op() {
        }

        final void execute() throws Exception {
            if (this.executed.compareAndSet(false, true)) {
                this.executeImpl();
            }
        }

        final boolean isExecuted() {
            return this.executed.get();
        }

        abstract void executeImpl() throws Exception;
    }

    static class MyFile {
        private final Path tmp;
        private Path dst;
        private Path trash;

        MyFile(String filePath) {
            this.tmp = new Path(filePath + TestFsShellMoveToTrashWithSnapshots.TMP);
        }

        public String toString() {
            return "MyFile{tmp=" + this.tmp + ", dst=" + this.dst + ", trash=" + this.trash + '}';
        }

        synchronized Path getPath() {
            return this.trash != null ? this.trash : (this.dst != null ? this.dst : this.tmp);
        }

        synchronized String moveFromTmp2Dst(Path dstDir) throws Exception {
            String tmpName = this.tmp.getName();
            this.dst = new Path(dstDir, tmpName.substring(0, tmpName.length() - 4));
            String snapshot = cluster.rename(this.tmp, this.dst);
            this.trash = cluster.getTrashPath(this.dst);
            return snapshot;
        }
    }

    static class MyDirs {
        private final Path base;
        private final boolean[] moved;
        private final List<Integer> renames = new ArrayList<Integer>();

        MyDirs(Path base, int depth) {
            this.base = base;
            this.moved = new boolean[depth];
            for (int i = 0; i < depth; ++i) {
                this.renames.add(i);
            }
            Collections.shuffle(this.renames);
        }

        int depth() {
            return this.moved.length;
        }

        DeleteSnapshotOp rename() throws Exception {
            int i = this.renames.remove(this.renames.size() - 1);
            String snapshot = cluster.rename(this.getSubPath(i + 1), this.getSubPath(i));
            this.moved[i] = true;
            return new DeleteSnapshotOp(snapshot);
        }

        Path getSubPath(int n) {
            if (n == 0) {
                return this.base;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (!this.moved[i]) {
                    b.append(TestFsShellMoveToTrashWithSnapshots.TO_BE_REMOVED);
                }
                b.append("dir").append(i).append("/");
            }
            return new Path(this.base, b.toString());
        }

        Path getPath() {
            return this.getSubPath(this.moved.length);
        }
    }
}

