/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCheckpointsWithSnapshots {
    private static final Path TEST_PATH = new Path("/foo");
    private static final Configuration conf = new HdfsConfiguration();

    @BeforeEach
    public void setUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpoint() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            secondary = new SecondaryNameNode(conf);
            SnapshotManager nnSnapshotManager = cluster.getNamesystem().getSnapshotManager();
            SnapshotManager secondarySnapshotManager = secondary.getFSNamesystem().getSnapshotManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            HdfsAdmin admin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)conf), conf);
            Assertions.assertEquals((int)0, (int)nnSnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)0, (int)nnSnapshotManager.getNumSnapshottableDirs());
            Assertions.assertEquals((int)0, (int)secondarySnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)0, (int)secondarySnapshotManager.getNumSnapshottableDirs());
            fs.mkdirs(TEST_PATH);
            admin.allowSnapshot(TEST_PATH);
            Assertions.assertEquals((int)0, (int)nnSnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)1, (int)nnSnapshotManager.getNumSnapshottableDirs());
            Path snapshotPath = fs.createSnapshot(TEST_PATH);
            Assertions.assertEquals((int)1, (int)nnSnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)1, (int)nnSnapshotManager.getNumSnapshottableDirs());
            secondary.doCheckpoint();
            Assertions.assertEquals((int)1, (int)secondarySnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)1, (int)secondarySnapshotManager.getNumSnapshottableDirs());
            fs.deleteSnapshot(TEST_PATH, snapshotPath.getName());
            admin.disallowSnapshot(TEST_PATH);
            Assertions.assertEquals((int)0, (int)nnSnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)0, (int)nnSnapshotManager.getNumSnapshottableDirs());
            NameNodeAdapter.enterSafeMode(cluster.getNameNode(), false);
            NameNodeAdapter.saveNamespace(cluster.getNameNode());
            NameNodeAdapter.leaveSafeMode(cluster.getNameNode());
            secondary.doCheckpoint();
            Assertions.assertEquals((int)0, (int)secondarySnapshotManager.getNumSnapshots());
            Assertions.assertEquals((int)0, (int)secondarySnapshotManager.getNumSnapshottableDirs());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            if (secondary != null) {
                secondary.shutdown();
            }
        }
    }

    static {
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
    }
}

