/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestStandbyBlockManagement {
    protected static final Logger LOG = LoggerFactory.getLogger(TestStandbyBlockManagement.class);
    private static final String TEST_FILE_DATA = "hello world";
    private static final String TEST_FILE = "/TestStandbyBlockManagement";
    private static final Path TEST_FILE_PATH = new Path("/TestStandbyBlockManagement");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testInvalidateBlock() throws Exception {
        Configuration conf = new Configuration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            Thread.sleep(1000L);
            LOG.info("==================================");
            DFSTestUtil.writeFile((FileSystem)fs, TEST_FILE_PATH, TEST_FILE_DATA);
            nn1.getRpcServer().rollEditLog();
            LOG.info("==================================");
            fs.delete(TEST_FILE_PATH, false);
            BlockManagerTestUtil.computeAllPendingWork(nn1.getNamesystem().getBlockManager());
            nn1.getRpcServer().rollEditLog();
            Assertions.assertEquals((long)0L, (long)nn2.getNamesystem().getBlockManager().getPendingDeletionBlocksCount());
            cluster.triggerHeartbeats();
            cluster.triggerBlockReports();
            Assertions.assertEquals((long)0L, (long)nn2.getNamesystem().getBlockManager().getPendingDeletionBlocksCount());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testNotHandleRedundantReplica() throws Exception {
        Configuration conf = new Configuration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(4).build();){
            cluster.waitActive();
            cluster.transitionToActive(0);
            NameNode nn1 = cluster.getNameNode(0);
            Assertions.assertEquals((Object)"ACTIVE", (Object)nn1.getNamesystem().getState().name());
            NameNode nn2 = cluster.getNameNode(1);
            Assertions.assertEquals((Object)"STANDBY", (Object)nn2.getNamesystem().getState().name());
            cluster.triggerHeartbeats();
            cluster.triggerBlockReports();
            Assertions.assertEquals((long)0L, (long)nn1.getNamesystem().getBlockManager().getExcessBlocksCount());
            Assertions.assertEquals((long)0L, (long)nn2.getNamesystem().getBlockManager().getExcessBlocksCount());
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            Path file = new Path("/test");
            long fileLength = 512L;
            DFSTestUtil.createFile((FileSystem)fs, file, fileLength, (short)4, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)4);
            fs.setReplication(file, (short)3);
            HATestUtil.waitForStandbyToCatchUp(nn1, nn2);
            cluster.triggerHeartbeats();
            HATestUtil.waitForDNDeletions(cluster);
            cluster.triggerDeletionReports();
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)3);
            Assertions.assertEquals((long)0L, (long)nn1.getNamesystem().getBlockManager().getExcessBlocksCount());
            Assertions.assertEquals((long)0L, (long)nn2.getNamesystem().getBlockManager().getExcessBlocksCount());
        }
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
    }
}

