/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.MockNameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNNHealthCheck {
    private MiniDFSCluster cluster;
    private Configuration conf;

    @BeforeEach
    public void setup() {
        this.conf = new Configuration();
    }

    @AfterEach
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testNNHealthCheck() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        this.doNNHealthCheckTest();
    }

    @Test
    public void testNNHealthCheckWithLifelineAddress() throws IOException {
        this.conf.set("dfs.namenode.lifeline.rpc-address", "0.0.0.0:0");
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        this.doNNHealthCheckTest();
    }

    @Test
    public void testNNHAServiceTargetWithProvidedAddr() {
        this.conf.set("dfs.namenode.lifeline.rpc-address", "0.0.0.1:1");
        this.conf.set("dfs.namenode.rpc-address", "0.0.0.1:2");
        NNHAServiceTarget target = new NNHAServiceTarget(this.conf, "ns", "nn1", "0.0.0.0:1", "0.0.0.0:2");
        Assertions.assertEquals((Object)"/0.0.0.0:1", (Object)target.getAddress().toString());
        Assertions.assertEquals((Object)"/0.0.0.0:2", (Object)target.getHealthMonitorAddress().toString());
    }

    @Test
    public void testNNHealthCheckWithSafemodeAsUnhealthy() throws Exception {
        this.conf.setBoolean("dfs.ha.nn.not-become-active-in-safemode", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        this.cluster.waitActive();
        this.cluster.getFileSystem(0).setSafeMode(SafeModeAction.ENTER);
        NNHAServiceTarget haTarget = new NNHAServiceTarget(this.conf, DFSUtil.getNamenodeNameServiceId((Configuration)this.conf), "nn1");
        String expectedTargetString = haTarget.getAddress().toString();
        Assertions.assertTrue((boolean)haTarget.toString().contains(expectedTargetString), (String)("Expected haTarget " + haTarget + " containing " + expectedTargetString));
        HAServiceProtocol rpc = haTarget.getHealthMonitorProxy(this.conf, 5000);
        LambdaTestUtils.intercept(RemoteException.class, (String)"The NameNode is configured to report UNHEALTHY to ZKFC in Safemode.", () -> rpc.monitorHealth());
    }

    private void doNNHealthCheckTest() throws IOException {
        MockNameNodeResourceChecker mockResourceChecker = new MockNameNodeResourceChecker(this.conf);
        this.cluster.getNameNode(0).getNamesystem().setNNResourceChecker((NameNodeResourceChecker)mockResourceChecker);
        NNHAServiceTarget haTarget = new NNHAServiceTarget(this.conf, DFSUtil.getNamenodeNameServiceId((Configuration)this.conf), "nn1");
        String expectedTargetString = this.conf.get("dfs.namenode.lifeline.rpc-address." + DFSUtil.getNamenodeNameServiceId((Configuration)this.conf) + ".nn1") != null ? haTarget.getHealthMonitorAddress().toString() : haTarget.getAddress().toString();
        Assertions.assertTrue((boolean)haTarget.toString().contains(expectedTargetString), (String)("Expected haTarget " + haTarget + " containing " + expectedTargetString));
        HAServiceProtocol rpc = haTarget.getHealthMonitorProxy(this.conf, this.conf.getInt("ha.health-monitor.rpc-timeout.ms", 45000));
        rpc.monitorHealth();
        mockResourceChecker.setResourcesAvailable(false);
        try {
            rpc.monitorHealth();
            Assertions.fail((String)"Should not have succeeded in calling monitorHealth");
        }
        catch (HealthCheckFailedException hcfe) {
            GenericTestUtils.assertExceptionContains((String)"The NameNode has no resources available", (Throwable)hcfe);
        }
        catch (RemoteException re) {
            GenericTestUtils.assertExceptionContains((String)"The NameNode has no resources available", (Throwable)re.unwrapRemoteException(new Class[]{HealthCheckFailedException.class}));
        }
    }
}

