/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInitializeSharedEdits {
    private static final Logger LOG = LoggerFactory.getLogger(TestInitializeSharedEdits.class);
    private static final Path TEST_PATH = new Path("/test");
    private Configuration conf;
    private MiniDFSCluster cluster;

    @BeforeEach
    public void setupCluster() throws IOException {
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.log-roll.period", 1);
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        MiniDFSNNTopology topology = MiniDFSNNTopology.simpleHATopology();
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(topology).numDataNodes(0).build();
        this.cluster.waitActive();
        this.shutdownClusterAndRemoveSharedEditsDir();
    }

    @AfterEach
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void shutdownClusterAndRemoveSharedEditsDir() throws IOException {
        this.cluster.shutdownNameNode(0);
        this.cluster.shutdownNameNode(1);
        File sharedEditsDir = new File(this.cluster.getSharedEditsDir(0, 1));
        Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)sharedEditsDir));
    }

    private void assertCannotStartNameNodes() {
        try {
            this.cluster.restartNameNode(0, false, new String[0]);
            Assertions.fail((String)"Should not have been able to start NN1 without shared dir");
        }
        catch (IOException ioe) {
            LOG.info("Got expected exception", (Throwable)ioe);
            GenericTestUtils.assertExceptionContains((String)"storage directory does not exist or is not accessible", (Throwable)ioe);
        }
        try {
            this.cluster.restartNameNode(1, false, new String[0]);
            Assertions.fail((String)"Should not have been able to start NN2 without shared dir");
        }
        catch (IOException ioe) {
            LOG.info("Got expected exception", (Throwable)ioe);
            GenericTestUtils.assertExceptionContains((String)"storage directory does not exist or is not accessible", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCanStartHaNameNodes(String pathSuffix) throws ServiceFailedException, IOException, URISyntaxException, InterruptedException {
        this.cluster.restartNameNode(0, false, new String[0]);
        this.cluster.restartNameNode(1, true, new String[0]);
        this.cluster.getNameNode(0).getRpcServer().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER));
        try (DistributedFileSystem fs = null;){
            Path newPath = new Path(TEST_PATH, pathSuffix);
            fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
            Assertions.assertTrue((boolean)fs.mkdirs(newPath));
            HATestUtil.waitForStandbyToCatchUp(this.cluster.getNameNode(0), this.cluster.getNameNode(1));
            Assertions.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), newPath.toString(), false, false, false).isDirectory());
        }
    }

    @Test
    public void testInitializeSharedEdits() throws Exception {
        this.assertCannotStartNameNodes();
        Assertions.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)this.cluster.getConfiguration(0)));
        this.assertCanStartHaNameNodes("1");
        this.shutdownClusterAndRemoveSharedEditsDir();
        this.assertCannotStartNameNodes();
        Assertions.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)this.cluster.getConfiguration(0)));
        this.assertCanStartHaNameNodes("2");
    }

    @Test
    public void testFailWhenNoSharedEditsSpecified() throws Exception {
        Configuration confNoShared = new Configuration(this.conf);
        confNoShared.unset("dfs.namenode.shared.edits.dir");
        Assertions.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)confNoShared, (boolean)true));
    }

    @Test
    public void testDontOverWriteExistingDir() throws IOException {
        Assertions.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)this.conf, (boolean)false));
        Assertions.assertTrue((boolean)NameNode.initializeSharedEdits((Configuration)this.conf, (boolean)false));
    }

    @Test
    public void testInitializeSharedEditsConfiguresGenericConfKeys() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), "localhost:1234");
        Assertions.assertNull((Object)conf.get("dfs.namenode.rpc-address"));
        NameNode.initializeSharedEdits((Configuration)conf);
        Assertions.assertNotNull((Object)conf.get("dfs.namenode.rpc-address"));
    }
}

