/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHAMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TestHAMetrics.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testHAMetrics() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            Assertions.assertEquals((Object)nn0.getHAState(), (Object)"standby");
            Assertions.assertTrue((0L < nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assertions.assertEquals((Object)nn1.getHAState(), (Object)"standby");
            Assertions.assertTrue((0L < nn1.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            cluster.transitionToActive(0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeStatus");
            Long ltt1 = (Long)mbs.getAttribute(mxbeanName, "LastHATransitionTime");
            Assertions.assertTrue((ltt1 > 0L ? 1 : 0) != 0, (String)"lastHATransitionTime should be > 0");
            Assertions.assertEquals((Object)"active", (Object)nn0.getHAState());
            Assertions.assertEquals((long)0L, (long)nn0.getMillisSinceLastLoadedEdits());
            Assertions.assertEquals((Object)"standby", (Object)nn1.getHAState());
            Assertions.assertTrue((0L < nn1.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            cluster.transitionToStandby(0);
            Long ltt2 = (Long)mbs.getAttribute(mxbeanName, "LastHATransitionTime");
            Assertions.assertTrue((ltt2 > ltt1 ? 1 : 0) != 0, (String)("lastHATransitionTime should be > " + ltt1));
            cluster.transitionToActive(1);
            Assertions.assertEquals((Object)"standby", (Object)nn0.getHAState());
            Assertions.assertTrue((0L < nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"active", (Object)nn1.getHAState());
            Assertions.assertEquals((long)0L, (long)nn1.getMillisSinceLastLoadedEdits());
            Thread.sleep(2000L);
            Assertions.assertTrue((2000L <= nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assertions.assertEquals((int)0, (int)nn0.getPendingDataNodeMessageCount());
            Assertions.assertEquals((int)0, (int)nn1.getPendingDataNodeMessageCount());
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/foo"), 10L, (short)1, 1L);
            Assertions.assertTrue((0 < nn0.getPendingDataNodeMessageCount() ? 1 : 0) != 0);
            Assertions.assertEquals((int)0, (int)nn1.getPendingDataNodeMessageCount());
            long millisSinceLastLoadedEdits = nn0.getMillisSinceLastLoadedEdits();
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(1), cluster.getNameNode(0));
            Assertions.assertEquals((int)0, (int)nn0.getPendingDataNodeMessageCount());
            Assertions.assertEquals((int)0, (int)nn1.getPendingDataNodeMessageCount());
            long newMillisSinceLastLoadedEdits = nn0.getMillisSinceLastLoadedEdits();
            Assertions.assertTrue((millisSinceLastLoadedEdits > newMillisSinceLastLoadedEdits ? 1 : 0) != 0, (String)("expected " + millisSinceLastLoadedEdits + " > " + newMillisSinceLastLoadedEdits));
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAInodeCount() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount1"), 10L, (short)1, 1L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount2"), 10L, (short)1, 1L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount3"), 10L, (short)1, 1L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount4"), 10L, (short)1, 1L);
            Assertions.assertEquals((long)5L, (long)nn0.getFilesTotal());
            Assertions.assertEquals((long)1L, (long)nn1.getFilesTotal());
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            cluster.restartNameNode(0);
            Assertions.assertEquals((Object)nn0.getHAState(), (Object)"standby");
            nn0 = cluster.getNamesystem(0);
            Assertions.assertEquals((long)5L, (long)nn0.getFilesTotal());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }

    @Test
    public void testGetNameNodeState() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology(3)).numDataNodes(1).build();
        cluster.waitActive();
        NameNode nn0 = cluster.getNameNode(0);
        NameNode nn1 = cluster.getNameNode(1);
        NameNode nn2 = cluster.getNameNode(2);
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.STANDBY.ordinal(), (int)nn0.getNameNodeState());
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.STANDBY.ordinal(), (int)nn1.getNameNodeState());
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.STANDBY.ordinal(), (int)nn2.getNameNodeState());
        cluster.transitionToActive(0);
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.ACTIVE.ordinal(), (int)nn0.getNameNodeState());
        cluster.transitionToStandby(0);
        cluster.transitionToActive(1);
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.STANDBY.ordinal(), (int)nn0.getNameNodeState());
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.ACTIVE.ordinal(), (int)nn1.getNameNodeState());
        cluster.transitionToObserver(2);
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.OBSERVER.ordinal(), (int)nn2.getNameNodeState());
        cluster.shutdownNameNode(2);
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.INITIALIZING.ordinal(), (int)nn2.getNameNodeState());
    }
}

