/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyCheckpointer;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHAConfiguration {
    private final FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);

    @Test
    public void testCheckpointerValidityChecks() throws Exception {
        try {
            Configuration conf = new Configuration();
            new StandbyCheckpointer(conf, this.fsn);
            Assertions.fail((String)"Bad config did not throw an error");
        }
        catch (IllegalArgumentException iae) {
            GenericTestUtils.assertExceptionContains((String)"Invalid URI for NameNode address", (Throwable)iae);
        }
    }

    private Configuration getHAConf(String nsId, String ... hosts) {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", nsId);
        conf.set("dfs.ha.namenode.id", "nn1");
        Object[] nnids = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            String nnid = "nn" + (i + 1);
            nnids[i] = nnid;
            conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{nsId, nnid}), hosts[i] + ":12345");
        }
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{nsId}), Joiner.on((char)',').join(nnids));
        return conf;
    }

    @Test
    public void testGetOtherNNHttpAddress() throws IOException {
        Configuration conf = this.getHAConf("ns1", "1.2.3.1", "1.2.3.2");
        conf.set("dfs.nameservice.id", "ns1");
        NameNode.initializeGenericKeys((Configuration)conf, (String)"ns1", (String)"nn1");
        StandbyCheckpointer checkpointer = new StandbyCheckpointer(conf, this.fsn);
        this.assertAddressMatches("1.2.3.2", (URL)checkpointer.getActiveNNAddresses().get(0));
        conf = this.getHAConf("ns1", "1.2.3.1", "1.2.3.2", "1.2.3.3");
        NameNode.initializeGenericKeys((Configuration)conf, (String)"ns1", (String)"nn1");
        checkpointer = new StandbyCheckpointer(conf, this.fsn);
        Assertions.assertEquals((int)2, (int)checkpointer.getActiveNNAddresses().size(), (String)"Got an unexpected number of possible active NNs");
        Assertions.assertEquals((Object)new URL("http", "1.2.3.2", 9870, ""), checkpointer.getActiveNNAddresses().get(0));
        this.assertAddressMatches("1.2.3.2", (URL)checkpointer.getActiveNNAddresses().get(0));
        this.assertAddressMatches("1.2.3.3", (URL)checkpointer.getActiveNNAddresses().get(1));
    }

    private void assertAddressMatches(String address, URL url) throws MalformedURLException {
        Assertions.assertEquals((Object)new URL("http", address, 9870, ""), (Object)url);
    }

    @Test
    public void testHAUniqueEditDirs() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.dir", "file://edits/dir, file://edits/shared/dir");
        conf.set("dfs.namenode.shared.edits.dir", "file://edits/shared/dir");
        List editsDirs = FSNamesystem.getNamespaceEditsDirs((Configuration)conf);
        Assertions.assertEquals((int)2, (int)editsDirs.size());
    }

    @Test
    public void testSecondaryNameNodeDoesNotStart() throws IOException {
        Configuration conf = this.getHAConf("ns1", "1.2.3.1", "1.2.3.2");
        try {
            new SecondaryNameNode(conf);
            Assertions.fail((String)"Created a 2NN with an HA config");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot use SecondaryNameNode in an HA cluster", (Throwable)ioe);
        }
    }

    @Test
    public void testGetOtherNNGenericConf() throws IOException {
        String nsId = "ns1";
        String host1 = "1.2.3.1";
        String host2 = "1.2.3.2";
        Configuration conf = this.getHAConf(nsId, host1, host2);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{nsId, "nn1"}), host1 + ":54321");
        conf.set("dfs.nameservice.id", "ns1");
        NameNode.initializeGenericKeys((Configuration)conf, (String)"ns1", (String)"nn1");
        List others = HAUtil.getConfForOtherNodes((Configuration)conf);
        Configuration nn2Conf = (Configuration)others.get(0);
        Assertions.assertEquals((Object)nn2Conf.get("dfs.ha.namenode.id"), (Object)"nn2");
        Assertions.assertTrue((!conf.get("dfs.namenode.rpc-address").equals(nn2Conf.get("dfs.namenode.rpc-address")) ? 1 : 0) != 0);
        Assertions.assertNull((Object)nn2Conf.get("dfs.namenode.servicerpc-address"));
    }
}

