/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.fgl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.fgl.FSNLockManager;
import org.apache.hadoop.hdfs.server.namenode.fgl.FineGrainedFSNamesystemLock;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFineGrainedFSNamesystemLock {
    private final Logger log = LoggerFactory.getLogger(TestFineGrainedFSNamesystemLock.class);

    private int getLoopNumber() {
        return ThreadLocalRandom.current().nextInt(2000, 3000);
    }

    @Test
    @Timeout(value=240L)
    public void testMultipleThreadsUsingLocks() throws InterruptedException, ExecutionException {
        FineGrainedFSNamesystemLock fsn = new FineGrainedFSNamesystemLock(new Configuration(), null);
        int threads = Math.min(128, Runtime.getRuntime().availableProcessors() * 4);
        ExecutorService service = HadoopExecutors.newFixedThreadPool((int)threads);
        AtomicLong globalCount = new AtomicLong(0L);
        AtomicLong fsCount = new AtomicLong(0L);
        AtomicLong bmCount = new AtomicLong(0L);
        AtomicLong globalNumber = new AtomicLong(0L);
        AtomicLong fsNumber = new AtomicLong(0L);
        AtomicLong bmNumber = new AtomicLong(0L);
        ArrayList<Callable<Boolean>> callableList = new ArrayList<Callable<Boolean>>(1000);
        for (int i = 0; i < 1000; ++i) {
            int index = i % 12;
            String opName = Integer.toString(i);
            if (index == 0) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.writeLock((FSNLockManager)fsn, RwLockMode.GLOBAL, opName, globalCount);
                        globalNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 1) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.writeLock((FSNLockManager)fsn, RwLockMode.FS, opName, fsCount);
                        fsNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 2) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.writeLock((FSNLockManager)fsn, RwLockMode.BM, opName, bmCount);
                        bmNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 3) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.readLock((FSNLockManager)fsn, RwLockMode.BM, opName, bmCount);
                        bmNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 4) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.readLock((FSNLockManager)fsn, RwLockMode.FS, opName, fsCount);
                        fsNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 5) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.readLock((FSNLockManager)fsn, RwLockMode.GLOBAL, opName, globalCount);
                        globalNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 6) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.writeLockInterruptibly((FSNLockManager)fsn, RwLockMode.GLOBAL, opName, globalCount);
                        globalNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 7) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.writeLockInterruptibly((FSNLockManager)fsn, RwLockMode.FS, opName, fsCount);
                        fsNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 8) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.writeLockInterruptibly((FSNLockManager)fsn, RwLockMode.BM, opName, bmCount);
                        bmNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 9) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.readLockInterruptibly((FSNLockManager)fsn, RwLockMode.BM, opName, bmCount);
                        bmNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            if (index == 10) {
                callableList.add(() -> {
                    for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                        this.readLockInterruptibly((FSNLockManager)fsn, RwLockMode.FS, opName, fsCount);
                        fsNumber.incrementAndGet();
                    }
                    return true;
                });
                continue;
            }
            callableList.add(() -> {
                for (int startIndex = 0; startIndex < this.getLoopNumber(); ++startIndex) {
                    this.readLockInterruptibly((FSNLockManager)fsn, RwLockMode.GLOBAL, opName, globalCount);
                    globalNumber.incrementAndGet();
                }
                return true;
            });
        }
        List futures = service.invokeAll(callableList);
        for (Future f : futures) {
            f.get();
        }
        this.log.info("Global executed {} times, FS executed {} times, BM executed {} times.", new Object[]{globalNumber.get(), fsNumber.get(), bmNumber.get()});
        assert (globalCount.get() == 0L);
        assert (fsCount.get() == 0L);
        assert (bmCount.get() == 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLock(FSNLockManager fsn, RwLockMode mode, String opName, AtomicLong counter) {
        fsn.writeLock(mode);
        try {
            counter.incrementAndGet();
        }
        finally {
            fsn.writeUnlock(mode, opName);
        }
        fsn.writeLock(mode);
        try {
            counter.decrementAndGet();
        }
        finally {
            fsn.writeUnlock(mode, opName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLock(FSNLockManager fsn, RwLockMode mode, String opName, AtomicLong counter) {
        fsn.readLock(mode);
        try {
            counter.get();
        }
        finally {
            fsn.readUnlock(mode, opName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLockInterruptibly(FSNLockManager fsn, RwLockMode mode, String opName, AtomicLong counter) {
        boolean success = false;
        try {
            fsn.writeLockInterruptibly(mode);
            try {
                counter.incrementAndGet();
                success = true;
            }
            finally {
                fsn.writeUnlock(mode, opName);
            }
        }
        catch (InterruptedException e) {
            this.log.info("InterruptedException happens in thread {} during increasing the Count.", (Object)opName);
        }
        while (success) {
            try {
                fsn.writeLockInterruptibly(mode);
                try {
                    counter.decrementAndGet();
                    success = false;
                }
                finally {
                    fsn.writeUnlock(mode, opName);
                }
            }
            catch (InterruptedException e) {
                this.log.info("InterruptedException happens in thread {} during decreasing the Count.", (Object)opName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLockInterruptibly(FSNLockManager fsn, RwLockMode mode, String opName, AtomicLong counter) {
        try {
            fsn.readLockInterruptibly(mode);
            try {
                counter.get();
            }
            finally {
                fsn.readUnlock(mode, opName);
            }
        }
        catch (InterruptedException e) {
            this.log.info("InterruptedException happens in thread {} during getting the Count.", (Object)opName);
        }
    }
}

