/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.RedundantEditLogInputStream;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestRedundantEditLogInputStream {
    private static final String FAKE_EDIT_STREAM_NAME = "FAKE_STREAM";

    @Test
    public void testNextOp() throws IOException {
        EditLogInputStream fakeStream1 = (EditLogInputStream)Mockito.mock(EditLogInputStream.class);
        EditLogInputStream fakeStream2 = (EditLogInputStream)Mockito.mock(EditLogInputStream.class);
        ArrayList<EditLogInputStream> list = new ArrayList<EditLogInputStream>();
        list.add(fakeStream1);
        list.add(fakeStream2);
        for (int i = 0; i < list.size(); ++i) {
            EditLogInputStream stream = (EditLogInputStream)list.get(i);
            Mockito.when((Object)stream.getName()).thenReturn((Object)(FAKE_EDIT_STREAM_NAME + i));
            Mockito.when((Object)stream.getFirstTxId()).thenReturn((Object)1L);
            Mockito.when((Object)stream.getLastTxId()).thenReturn((Object)2L);
            Mockito.when((Object)stream.length()).thenReturn((Object)1L);
        }
        Mockito.when((Object)fakeStream1.skipUntil(1L)).thenThrow(new Throwable[]{new IOException("skipUntil failed.")});
        Mockito.when((Object)fakeStream2.skipUntil(1L)).thenReturn((Object)true);
        FSEditLogOp.MkdirOp op = new FSEditLogOp.MkdirOp();
        op.setTransactionId(100L);
        Mockito.when((Object)fakeStream2.readOp()).thenReturn((Object)op);
        GenericTestUtils.LogCapturer capture = GenericTestUtils.LogCapturer.captureLogs((Logger)RedundantEditLogInputStream.LOG);
        RedundantEditLogInputStream redundantEditLogInputStream = new RedundantEditLogInputStream(list, 1L);
        FSEditLogOp returnOp = redundantEditLogInputStream.nextOp();
        String log = capture.getOutput();
        Assertions.assertTrue((boolean)log.contains("Got error skipUntil edit log input stream FAKE_STREAM0"));
        Assertions.assertTrue((boolean)log.contains("Got error reading edit log input stream FAKE_STREAM0; failing over to edit log FAKE_STREAM1"));
        Assertions.assertEquals((Object)op, (Object)returnOp);
    }
}

